---
generated_at: 2026-02-10 10:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：12-createRelease.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/createRelease.sh` 1-204行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 12行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Etherpad 1.7.0以降非推奨 | E-01 (3-6行目: `WARNING: since Etherpad 1.7.0 (2018-08-17), this script is DEPRECATED`) | ○ |
| C-02 | 非推奨警告と続行確認プロンプト表示 | E-01 (24-32行目: while true + read -p) | ○ |
| C-03 | GitHub APIトークンの有効性確認 | E-01 (74-79行目: check_api_token関数) | ○ |
| C-04 | CHANGELOG.mdへのリリースノート追記 | E-01 (81-93行目: modify_files関数内sed) | ○ |
| C-05 | src/package.jsonのバージョン番号更新 | E-01 (95-97行目: sed -i -r) | ○ |
| C-06 | リリースブランチの作成とプッシュ | E-01 (100-118行目: create_release_branch関数) | ○ |
| C-07 | masterブランチへのマージ | E-01 (120-127行目: merge_release_branch関数) | ○ |
| C-08 | buildForWindows.shの呼び出し | E-01 (137行目: `bin/buildForWindows.sh`) | ○ |
| C-09 | make docsでドキュメント生成 | E-01 (140行目: `make docs`) | ○ |
| C-10 | ether.github.comリポジトリへの成果物コピー | E-01 (144-162行目: push_builds関数) | ○ |
| C-11 | GitHub Releaseの作成（オプション） | E-01 (173-185行目: publish_release関数) | ○ |
| C-12 | 手動作業の案内表示 | E-01 (187-192行目: todo_notification関数) | ○ |
| C-13 | バージョン番号はx.x.x形式 | E-01 (55-56行目: `echo -n "Enter new version (x.x.x): "`) | ○ |
| C-14 | エディタでCHANGELOG入力 | E-01 (60-63行目: `"${EDITOR:-vi}" $tmp`) | ○ |
| C-15 | ETHER_REPOはetherpad-lite.git | E-01 (34行目: `ETHER_REPO="https://github.com/ether/etherpad-lite.git"`) | ○ |
| C-16 | ETHER_WEB_REPOはether.github.com.git | E-01 (35行目: `ETHER_WEB_REPO="https://github.com/ether/ether.github.com.git"`) | ○ |
| C-17 | 一時ディレクトリは/tmp/ | E-01 (36行目: `TMP_DIR="/tmp/"`) | ○ |
| C-18 | Windows ビルド名にGIT_SHA含む | E-01 (147-148行目: `GIT_SHA=$(git rev-parse HEAD | cut -c1-10)`, `etherpad-win-$VERSION-$GIT_SHA.zip`) | ○ |
| C-19 | ドキュメント出力先はdoc/v$VERSION | E-01 (150行目: `mv out/doc $TMP_DIR/ether.github.com/doc/v$VERSION`) | ○ |
| C-20 | 後継スクリプトはrelease.tsとpush-after-release.sh | E-02 (13-14行目に記載) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 非推奨スクリプトであり、使用は推奨されない点を強調すべき
- 1: 中リスク - GitHub API認証がURLパラメータ方式（旧式）である点

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨である旨が利用者に明確に伝わるか確認
- [ ] 後継スクリプト（release.ts）への移行ガイダンスが十分か確認
- [ ] セキュリティ上の懸念（API認証方式）について適切に記載されているか確認
