---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：13-release.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/release.ts` 1-232行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 13行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | リリースタイプはpatch/minor/major | E-01 (39-42行目: `if (release !== 'patch' && release !== 'minor' && release !== 'major')`) | ○ |
| C-02 | 作業ディレクトリのクリーン確認 | E-01 (56-75行目: assertWorkDirClean関数) | ○ |
| C-03 | developブランチのチェックアウト確認 | E-01 (77-85行目: assertBranchCheckedOut関数, 122行目) | ○ |
| C-04 | リモート追跡状態の確認 | E-01 (87-100行目: assertUpstreamOk関数) | ○ |
| C-05 | ether.github.comリポジトリの存在確認 | E-01 (127-130行目: `if (!dirExists('../ether.github.com'))`) | ○ |
| C-06 | CHANGELOGに新バージョン記載確認 | E-01 (145-147行目: `if (!changelog.startsWith(\`# ${newVersion}\n\`))`) | ○ |
| C-07 | asciidoctorのインストール確認 | E-01 (103-109行目: `exec('asciidoctor -v')`) | ○ |
| C-08 | semverで新バージョン計算 | E-01 (139行目: `const newVersion = semver.inc(currentVersion, release)`) | ○ |
| C-09 | 複数のpackage.jsonを更新 | E-01 (159-162行目: src/admin/bin/root package.json更新) | ○ |
| C-10 | jqコマンドでJSON更新 | E-01 (159-162行目: `jq '. += {"version": "'${newVersion}'"}'`) | ○ |
| C-11 | pnpm installの実行 | E-01 (165行目: `run('pnpm install')`) | ○ |
| C-12 | "bump version"コミット作成 | E-01 (168-169行目: `git add -A`, `git commit -m "bump version"`) | ○ |
| C-13 | masterブランチへのマージ | E-01 (174-175行目: `git merge --no-ff --no-edit develop`) | ○ |
| C-14 | タグ作成（VERSIONとvVERSION） | E-01 (176-178行目: `git tag -a '${newVersion}'`, `git tag -a 'v${newVersion}'`) | ○ |
| C-15 | developへのマージバック | E-01 (179-182行目: `git checkout develop`, `git merge --no-ff --no-edit master`) | ○ |
| C-16 | エラー時の自動ロールバック | E-01 (183-198行目: catch節でのreset処理) | ○ |
| C-17 | ドキュメントビルド（pnpm run makeDocs） | E-01 (202行目: `run('pnpm run makeDocs')`) | ○ |
| C-18 | ドキュメントをether.github.comにコピー | E-01 (206行目: `cp -R out/doc/ ../ether.github.com/public/doc/v'${newVersion}'`) | ○ |
| C-19 | WindowsビルドはGitHub Actionsで作成 | E-01 (226行目: "Windows build is not necessary anymore and will be created by GitHub action") | ○ |
| C-20 | push-after-release.shでプッシュ | E-01 (225行目: "Run ./bin/push-after-release.sh") | ○ |
| C-21 | log4jsでロギング設定 | E-01 (17-20行目: log4js.configure) | ○ |
| C-22 | 使用方法の表示 | E-01 (29-30行目: usage定数) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] CHANGELOGの先頭行フォーマット（`# {VERSION}\n`）が正しいか確認
- [ ] ether.github.comリポジトリのパス（../ether.github.com）が環境に合っているか確認
- [ ] 複数のpackage.jsonの更新対象が正しいか確認（src, admin, bin, root）
