---
generated_at: 2026-02-10 10:42:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-make_docs.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/make_docs.ts` 1-64行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 16行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | asciidoctorのインストール確認 | E-01 (45-51行目: `exec('asciidoctor -v', (err,stdout)=>{ if (err){ console.log('Please install asciidoctor') }})`) | ○ |
| C-02 | src/package.jsonからバージョン読み込み | E-01 (5行目: `import pjson from '../src/package.json'`, 7行目: `const VERSION=pjson.version`) | ○ |
| C-03 | ビルド開始時にバージョン表示 | E-01 (8行目: `console.log(\`Building docs for version ${VERSION}\`)`) | ○ |
| C-04 | 出力ディレクトリ作成（../out） | E-01 (54行目: `createDirIfNotExists('../out')`) | ○ |
| C-05 | 出力ディレクトリ作成（../out/doc） | E-01 (55行目: `createDirIfNotExists('../out/doc')`) | ○ |
| C-06 | 出力ディレクトリ作成（../out/doc/api） | E-01 (56行目: `createDirIfNotExists('../out/doc/api')`) | ○ |
| C-07 | メインドキュメント変換 | E-01 (60行目: `exec(\`asciidoctor -D ../out/doc ../doc/index.adoc ../*/**.adoc -a VERSION=${VERSION}\`)`) | ○ |
| C-08 | APIドキュメント変換 | E-01 (61行目: `exec(\`asciidoctor -D ../out/doc/api  ../doc/api/*.adoc -a VERSION=${VERSION}\`)`) | ○ |
| C-09 | 静的ファイルコピー | E-01 (63行目: `copyFolderSync('../doc/public/', '../out/doc/')`) | ○ |
| C-10 | VERSION変数をAsciiDocに渡す | E-01 (60-61行目: `-a VERSION=${VERSION}`) | ○ |
| C-11 | 既存ディレクトリは削除してから作成 | E-01 (18-26行目: `if(fs.existsSync(to)){ ... fs.rmSync(to, { recursive: true }) }`) | ○ |
| C-12 | copyFolderSyncは再帰的にコピー | E-01 (35-42行目: 再帰呼び出し `copyFolderSync(path.join(from, element), path.join(to, element))`) | ○ |
| C-13 | createDirIfNotExistsでディレクトリ作成 | E-01 (10-14行目: `const createDirIfNotExists = (dir) => { if (!fs.existsSync(dir)){ fs.mkdirSync(dir) } }`) | ○ |
| C-14 | ドキュメント生成処理である | E-02 ("asciidoctorを使用してドキュメントを生成するスクリプト") | ○ |
| C-15 | asciidoctor不在時はプロセス終了 | E-01 (49行目: `process.exit(1)`) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - exec関数が非同期で完了を待たない点は設計上の考慮事項

## 6) レビュアーチェックリスト（最小）
- [ ] asciidoctorのインストール手順URLが最新か確認（https://asciidoctor.org/docs/install-toolchain/）
- [ ] 出力パス（../out/doc/）がプロジェクト構成と一致しているか確認
- [ ] exec関数の非同期実行が問題にならないか確認
