---
generated_at: 2026-02-10 10:48:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-migrateDirtyDBtoRealDB.ts

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/migrateDirtyDBtoRealDB.ts` 1-61行目
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` 18行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | settings.jsonからdbType, dbSettingsを取得 | E-01 (6行目: `import settings from 'ep_etherpad-lite/node/utils/Settings'`, 26-27行目: `settings.dbType`, `settings.dbSettings`) | ○ |
| C-02 | キャッシュ無効化（cache: '0'） | E-01 (22行目: `cache: '0'`) | ○ |
| C-03 | 即時書き込みモード（writeInterval: 0） | E-01 (23行目: `writeInterval: 0`) | ○ |
| C-04 | DirtyDBは__dirname/../var/dirty.dbを参照 | E-01 (33行目: `new Database('dirty', \`${__dirname}/../var/dirty.db\`)`) | ○ |
| C-05 | findKeys('*', '')で全キー取得 | E-01 (35行目: `const keys = await dirty.findKeys('*', '')`) | ○ |
| C-06 | レコード数を表示 | E-01 (37行目: `console.log(\`Found ${keys.length} records, processing now.\`)`) | ○ |
| C-07 | 100件ごとに進捗表示 | E-01 (47行目: `if (++numWritten % 100 === 0) console.log(\`Wrote record ${numWritten} of ${length}\`)`) | ○ |
| C-08 | Promise.allで全書き込みを待機 | E-01 (53行目: `await Promise.all(p)`) | ○ |
| C-09 | "Wrote all {n} records"を出力 | E-01 (54行目: `console.log(\`Wrote all ${numWritten} records\`)`) | ○ |
| C-10 | 両DBをクローズ | E-01 (56-57行目: `await db.close(null)`, `await dirty.close(null)`) | ○ |
| C-11 | "Finished."を出力 | E-01 (58行目: `console.log('Finished.')`) | ○ |
| C-12 | "Waiting for dirtyDB to parse its file."を出力 | E-01 (32行目: `console.log('Waiting for dirtyDB to parse its file.')`) | ○ |
| C-13 | unhandledRejectionを例外に変換 | E-01 (9-10行目: `process.on('unhandledRejection', (err) => { throw err; })`) | ○ |
| C-14 | log4jsでueberDBのログを記録 | E-01 (5行目: `import log4js from 'log4js'`, 29行目: `log4js.getLogger('ueberDB')`) | ○ |
| C-15 | process.exit(0)で正常終了 | E-01 (59行目: `process.exit(0)`) | ○ |
| C-16 | コマンドライン引数は受け付けない | E-01（引数処理なし） | ○ |
| C-17 | DirtyDBから本番用DBへ移行 | E-02 ("DirtyDBから本番用データベースへデータを移行するスクリプト") | ○ |
| C-18 | --max-old-space-size=4096オプションの案内 | E-01 (17-18行目: コメント "It might be necessary to run the script using more memory") | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張に根拠あり）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 大量データ時のメモリ使用量に注意が必要
- 0: 低リスク - データの上書き動作について事前確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] settings.jsonが本番用DB設定に更新されているか確認
- [ ] dirty.dbのバックアップが取得されているか確認
- [ ] Etherpadが停止しているか確認
