---
generated_at: 2026-02-10 14:44:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-plugins.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/plugins.ts` - メインスクリプト
- E-02: `bin/commonPlugins.ts` - プラグイン永続化モジュール
- E-03: `src/static/js/pluginfw/installer.ts` - プラグインインストーラー
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 引数なしでエラー終了（exit 1） | E-01 (L8-11) | ○ |
| C-02 | i/install, rm/remove, ls/listをサポート | E-01 (L16-23, L96-117) | ○ |
| C-03 | 無効アクションでエラー終了 | E-01 (L115-117) | ○ |
| C-04 | レジストリプラグインの正規表現解析 | E-01 (L27-30) | ○ |
| C-05 | --pathオプションのサポート | E-01 (L28, L48-51) | ○ |
| C-06 | --githubオプションのサポート | E-01 (L29, L53-56) | ○ |
| C-07 | バージョン指定は@区切り | E-01 (L40-43) | ○ |
| C-08 | linkInstaller.installPlugin()呼び出し | E-01 (L42, L45) | ○ |
| C-09 | linkInstaller.installFromPath()呼び出し | E-01 (L50) | ○ |
| C-10 | linkInstaller.installFromGitHub()呼び出し | E-01 (L55) | ○ |
| C-11 | checkForMigration()呼び出し | E-01 (L60, L89), E-03 (L81-130) | ○ |
| C-12 | persistInstalledPlugins()呼び出し | E-01 (L62, L85), E-02 (L6-17) | ○ |
| C-13 | linkInstaller.uninstallPlugin()呼び出し | E-01 (L83) | ○ |
| C-14 | installed_plugins.json読み込み | E-01 (L68) | ○ |
| C-15 | プラグイン名をカンマ区切りで出力 | E-01 (L69, L71) | ○ |
| C-16 | switchでアクション分岐 | E-01 (L96-117) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（すべての主張に対して根拠が確認できた）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ファイルシステムへの書き込み操作を行う
- 0: 低リスク - Etherpad再起動まで変更が反映されないため、即座の影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] Etherpad再起動の手順がドキュメント化されているか確認
- [ ] プラグイン削除後のクリーンアップ手順が適切か確認
- [ ] --path/--githubオプションの使用例が十分か確認
