---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：36-adminrunner.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. **admin引数による動作の違い**：remote_runner.jsとの整合性確認
  2. **Chromeのみでのテスト実行**：テストカバレッジの妥当性確認
  3. **runner.shとの差分**：重複部分の保守性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/frontend/travis/adminrunner.sh` - メインスクリプト
- E-02: `src/tests/frontend/travis/remote_runner.js` - リモートテストランナー
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pecho, log, error, fatal, try関数を定義 | E-01 (行3-7) | ○ |
| C-02 | Etherpadベースディレクトリへ移動 | E-01 (行10-11) | ○ |
| C-03 | npm run dev --experimental-workerで起動 | E-01 (行14) | ○ |
| C-04 | バックグラウンドで起動しPID保存 | E-01 (行14-15) | ○ |
| C-05 | curlでlocalhost:9001への接続確認 | E-01 (行19-20) | ○ |
| C-06 | 最大15秒間接続待機 | E-01 (行25) | ○ |
| C-07 | 1秒間隔でリトライ | E-01 (行26) | ○ |
| C-08 | 接続失敗時はタイムアウトエラー | E-01 (行28-29) | ○ |
| C-09 | remote_runner.js adminを実行 | E-01 (行35) | ○ |
| C-10 | テスト終了後にEtherpadプロセスを終了 | E-01 (行38) | ○ |
| C-11 | テスト結果の終了コードで終了 | E-01 (行40) | ○ |
| C-12 | isAdminRunnerでadmin判定 | E-02 (行13) | ○ |
| C-13 | admin時はChromeのみでテスト | E-02 (行96-101) | ○ |
| C-14 | Safari、Firefox、Edgeスキップ | E-02 (行97-101) | ○ |
| C-15 | installDeps.shの事前実行が必要 | E-01 (行13) | ○ |
| C-16 | runner.shとほぼ同一構造 | E-01, runner.sh比較 | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。スクリプトとremote_runner.jsの両方から動作が確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テスト実行のみで本番環境への影響なし
- 0: 低リスク - Chromeのみのテストは管理画面として適切な範囲

## 6) レビュアーチェックリスト（最小）
- [ ] admin引数によるremote_runner.jsの動作確認
- [ ] Chromeのみでのテストカバレッジの妥当性確認
- [ ] runner.shとの差分の保守性確認
