---
generated_at: 2026-02-10 10:42:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-runnerBackend.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **非推奨スクリプト**：代替手段（npm test）への移行確認
  2. **settings.jsonの上書き**：既存設定への影響確認
  3. **レート制限緩和設定**：テスト環境の妥当性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/frontend/travis/runnerBackend.sh` - メインスクリプト
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | pecho, log, error, fatal, try関数を定義 | E-01 (行3-7) | ○ |
| C-02 | Etherpadベースディレクトリへ移動 | E-01 (行10-11) | ○ |
| C-03 | sedでsofficeパスを/usr/bin/sofficeに設定 | E-01 (行14) | ○ |
| C-04 | maxを100に設定 | E-01 (行16) | ○ |
| C-05 | pointsを1000に設定 | E-01 (行17) | ○ |
| C-06 | settings.json.templateからsettings.jsonを生成 | E-01 (行18) | ○ |
| C-07 | 非推奨警告を出力 | E-01 (行20) | ○ |
| C-08 | cd src && npm testを推奨 | E-01 (行20) | ○ |
| C-09 | npm run devで起動（--experimental-workerなし） | E-01 (行22) | ○ |
| C-10 | バックグラウンドで起動しPID保存 | E-01 (行22-23) | ○ |
| C-11 | curlでlocalhost:9001への接続確認 | E-01 (行27-28) | ○ |
| C-12 | 最大15秒間接続待機 | E-01 (行33) | ○ |
| C-13 | 1秒間隔でリトライ | E-01 (行34) | ○ |
| C-14 | 接続失敗時はタイムアウトエラー | E-01 (行36-37) | ○ |
| C-15 | cd src && npm testを実行 | E-01 (行41-42) | ○ |
| C-16 | テスト終了後にEtherpadプロセスを終了 | E-01 (行45) | ○ |
| C-17 | テスト結果の終了コードで終了 | E-01 (行47) | ○ |
| C-18 | バックエンドテスト実行ログ出力 | E-01 (行40) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。スクリプトの動作はコードから完全に確認可能

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - 非推奨スクリプトのため、新規使用は避けるべき
- 1: 中リスク - settings.jsonを上書きするため、既存設定が失われる可能性
- 0: 低リスク - テスト実行のみで本番環境への影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] 非推奨スクリプトの代替（npm test）への移行状況確認
- [ ] settings.json上書きの影響範囲確認
- [ ] レート制限緩和設定の妥当性確認
- [ ] sofficeパス設定の環境依存性確認
