---
generated_at: 2026-02-10 10:44:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-runnerLoadTest.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **etherpad-loadtestツールの依存関係**：パッケージインストール確認
  2. **レート制限緩和設定**：テスト環境の妥当性確認
  3. **パラメータの適正値**：期間・著者数の推奨範囲確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/frontend/travis/runnerLoadTest.sh` - メインスクリプト
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -eでエラー時の即座終了設定 | E-01 (行3) | ○ |
| C-02 | pecho, log, error, fatal, try関数を定義 | E-01 (行5-9) | ○ |
| C-03 | $1（期間）の検証 | E-01 (行11) | ○ |
| C-04 | $2（著者数）の検証 | E-01 (行12) | ○ |
| C-05 | Etherpadベースディレクトリへ移動 | E-01 (行15-16) | ○ |
| C-06 | importExportRateLimiting.maxを100000000に設定 | E-01 (行18) | ○ |
| C-07 | loadTestをtrueに設定 | E-01 (行21) | ○ |
| C-08 | pointsを1000に設定 | E-01 (行23) | ○ |
| C-09 | settings.json.templateからsettings.jsonを生成 | E-01 (行24) | ○ |
| C-10 | pnpm run prodで本番モード起動 | E-01 (行27) | ○ |
| C-11 | バックグラウンドで起動しPID保存 | E-01 (行27-28) | ○ |
| C-12 | curlでlocalhost:9001への接続確認 | E-01 (行32-33) | ○ |
| C-13 | 最大60秒間接続待機 | E-01 (行38) | ○ |
| C-14 | 1秒間隔でリトライ | E-01 (行39) | ○ |
| C-15 | 接続失敗時はタイムアウトエラー | E-01 (行41-42) | ○ |
| C-16 | /p/minifymeにアクセスしてminifiedファイルビルド | E-01 (行46) | ○ |
| C-17 | 10秒待機 | E-01 (行49) | ○ |
| C-18 | etherpad-loadtest -d $1 -a $2を実行 | E-01 (行54) | ○ |
| C-19 | -dは期間オプション | E-01 (行52) | ○ |
| C-20 | -aは著者数オプション | E-01 (行53) | ○ |
| C-21 | テスト終了後にEtherpadプロセスを終了 | E-01 (行57) | ○ |
| C-22 | テスト結果の終了コードで終了 | E-01 (行59) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。スクリプトの動作はコードから完全に確認可能

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 負荷テストによりシステムリソースが大量消費される
- 1: 中リスク - settings.jsonを上書きするため、既存設定が失われる可能性
- 0: 低リスク - テスト実行のみで本番環境への影響なし（隔離環境推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] etherpad-loadtestパッケージのインストール確認
- [ ] 負荷テスト実行環境のリソース確認
- [ ] settings.json上書きの影響範囲確認
- [ ] パラメータ（期間・著者数）の適正値確認
