---
generated_at: 2026-02-10 10:46:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：39-testlimits.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **Dockerコンテナ設定**：anotheripコンテナの設定確認が必要
  2. **プロキシ設定**：172.23.42.1のプロキシ設定確認が必要
  3. **レート制限閾値100ms**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/ratelimit/testlimits.sh` - メインスクリプト
- E-02: `src/tests/ratelimit/send_changesets.js` - Changeset送信スクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 101ms間隔でsend_changesets.js実行 | E-01 (行4) | ○ |
| C-02 | 終了コード0でレート制限未発動確認 | E-01 (行5-8) | ○ |
| C-03 | 99ms間隔でsend_changesets.js実行 | E-01 (行11) | ○ |
| C-04 | 終了コード1でレート制限発動確認 | E-01 (行12-15) | ○ |
| C-05 | プロキシ経由101ms送信をバックグラウンド実行 | E-01 (行18-19) | ○ |
| C-06 | Docker経由別IP送信をバックグラウンド実行 | E-01 (行22-23) | ○ |
| C-07 | 両プロセスの終了を待機 | E-01 (行25-28) | ○ |
| C-08 | 両テストの終了コードを確認 | E-01 (行33-36) | ○ |
| C-09 | エラー時のFAILEDメッセージ出力 | E-01 (行6,13,34) | ○ |
| C-10 | テスト用パッド名にBACKEND_TESTプレフィックス | E-01 (行4,11,18,22) | ○ |
| C-11 | etherpad-cli-clientを使用 | E-02 (行3) | ○ |
| C-12 | WebSocket経由でChangeset送信 | E-02 (行5-6) | ○ |
| C-13 | 500ms待機後に送信開始 | E-02 (行11) | ○ |
| C-14 | 11秒後にプロセス終了 | E-02 (行13-15) | ○ |
| C-15 | rateLimitedメッセージで終了コード1 | E-02 (行18-21) | ○ |
| C-16 | ポート8081でEtherpadに接続 | E-01 (行4) | ○ |
| C-17 | anotherip Dockerコンテナ使用 | E-01 (行22) | ○ |
| C-18 | 172.23.42.1プロキシ経由アクセス | E-01 (行22) | ○ |
| C-19 | Dockerコンテナanotheripの設定詳細 | **根拠なし** | △ |
| C-20 | レート制限閾値100msの設定 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Dockerコンテナ「anotherip」の設定・構築方法
  - 候補：docker-compose.yml / Dockerfile / テスト環境構築ドキュメント
- レート制限閾値100msの設定箇所
  - 候補：settings.json / settings.json.template / ソースコード

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Dockerコンテナ設定が不明で、テスト環境構築に支障がある可能性
- 0: 低リスク - テスト実行のみで本番環境への影響なし
- 0: 低リスク - テストデータはBACKEND_TESTプレフィックス付きで識別可能

## 6) レビュアーチェックリスト（最小）
- [ ] Dockerコンテナ「anotherip」の設定・構築方法確認
- [ ] レート制限閾値100msの設定箇所確認
- [ ] ポート8081でのEtherpad起動方法確認
- [ ] プロキシ設定（172.23.42.1）の確認
- [ ] etherpad-cli-clientパッケージのインストール確認
