---
generated_at: 2026-02-10 10:15:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：4-debugRun.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：すべての主張に根拠あり
  2. **該当なし**：-
  3. **該当なし**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/debugRun.sh` - メインスクリプト（20行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧
- E-03: `bin/functions.sh` - 共通関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Chrome DevToolsでデバッグ可能なモードで起動 | E-01 (line 13-15, 20), E-02 (No.4) | ○ |
| C-02 | ベースディレクトリへの移動処理 | E-01 (line 4-5) | ○ |
| C-03 | functions.shの読み込み | E-01 (line 8) | ○ |
| C-04 | installDeps.shの呼び出し | E-01 (line 11) | ○ |
| C-05 | デバッグガイドメッセージの表示 | E-01 (line 13-15) | ○ |
| C-06 | chrome://inspectの案内 | E-01 (line 15) | ○ |
| C-07 | srcディレクトリへの移動 | E-01 (line 17) | ○ |
| C-08 | --inspect=0.0.0.0:9229オプション | E-01 (line 20) | ○ |
| C-09 | 外部接続許可（0.0.0.0） | E-01 (line 18-19, 20) | ○ |
| C-10 | デフォルトポート9229使用 | E-01 (line 19) | ○ |
| C-11 | tsxによるTypeScript直接実行 | E-01 (line 20: --import tsx) | ○ |
| C-12 | server.tsの起動 | E-01 (line 20) | ○ |
| C-13 | execによるプロセス置換 | E-01 (line 20) | ○ |
| C-14 | Dockerコンテナ対応の説明 | E-01 (line 18-19 コメント) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：すべての主張にソースコードからの根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理内容はすべてソースコードから確認可能
- 2: 高リスク（運用観点） - デバッグポートが0.0.0.0でリッスンするためセキュリティ注意

## 6) レビュアーチェックリスト（最小）
- [ ] 本番環境での使用禁止がドキュメントで明確か
- [ ] デバッグポート公開のセキュリティリスクが周知されているか
- [ ] Dockerコンテナ使用時のポートマッピング手順が明確か
