---
generated_at: 2026-02-10 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-cleanRun.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：すべての主張に根拠あり
  2. **該当なし**：-
  3. **該当なし**：-

## 2) 参照した情報（Evidence一覧）

- E-01: `bin/cleanRun.sh` - メインスクリプト（39行）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧
- E-03: `bin/functions.sh` - 共通関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | node_modulesを削除してクリーン起動 | E-01 (line 31), E-02 (No.5) | ○ |
| C-02 | ベースディレクトリへの移動処理 | E-01 (line 4-5) | ○ |
| C-03 | functions.shの読み込み | E-01 (line 8) | ○ |
| C-04 | --root引数によるroot権限チェックスキップ | E-01 (line 10-16) | ○ |
| C-05 | root権限実行時の確認メッセージ処理 | E-01 (line 19-28) | ○ |
| C-06 | 確認フレーズ「Etherpad rocks my socks」 | E-01 (line 23) | ○ |
| C-07 | rm -rf src/node_modulesの実行 | E-01 (line 31) | ○ |
| C-08 | installDeps.shの呼び出し | E-01 (line 34) | ○ |
| C-09 | srcディレクトリへの移動 | E-01 (line 38) | ○ |
| C-10 | node --import tsxによるサーバー起動 | E-01 (line 39) | ○ |
| C-11 | server.tsの起動 | E-01 (line 39) | ○ |
| C-12 | execによるプロセス置換 | E-01 (line 39) | ○ |
| C-13 | "Starting Etherpad..."メッセージ表示 | E-01 (line 37) | ○ |
| C-14 | exit 1によるエラー終了 | E-01 (line 25-26, 34) | ○ |
| C-15 | readコマンドによる入力受付（-rなし） | E-01 (line 22) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし：すべての主張にソースコードからの根拠が存在する

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 処理内容はすべてソースコードから確認可能
- 1: 中リスク - rm -rfによる削除処理は確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] rm -rfの対象パスが正しいか（src/node_modulesのみ）
- [ ] root権限チェックのセキュリティ要件が現行ポリシーと一致しているか
- [ ] トラブルシューティング用途であることがドキュメントで明確か
