---
generated_at: 2026-02-10 13:30:00
metrics:
  claims_total: 109
  claims_with_evidence: 107
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：bin-cli単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：107 / 109、根拠なし：2
- 優先レビュー（高）
  1. **C-56**: dirtyDB移行の「レコードが0件の場合」のテストケースは、コード上で明示的な分岐がないため、実際の動作確認が必要
  2. **C-108/C-109**: stalePluginsの境界値テストは、日付計算ロジックの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bin/checkAllPads.ts` - 全パッドチェックCLIスクリプト
- E-02: `bin/checkPad.ts` - 単一パッドチェックCLIスクリプト
- E-03: `bin/commonPlugins.ts` - プラグイン永続化ユーティリティ
- E-04: `bin/createUserSession.ts` - ユーザーセッション作成スクリプト
- E-05: `bin/deleteAllGroupSessions.ts` - グループセッション一括削除スクリプト
- E-06: `bin/deletePad.ts` - パッド削除スクリプト
- E-07: `bin/extractPadData.ts` - パッドデータ抽出スクリプト
- E-08: `bin/generateReleaseNotes.ts` - リリースノート生成スクリプト
- E-09: `bin/importSqlFile.ts` - SQLファイルインポートスクリプト
- E-10: `bin/make_docs.ts` - ドキュメント生成スクリプト
- E-11: `bin/migrateDB.ts` - DB間移行スクリプト
- E-12: `bin/migrateDirtyDBtoRealDB.ts` - dirtyDBから本番DB移行スクリプト
- E-13: `bin/plugins.ts` - プラグイン管理CLIスクリプト
- E-14: `bin/rebuildPad.ts` - パッド再構築スクリプト
- E-15: `bin/repairPad.ts` - パッド修復スクリプト
- E-16: `bin/release.ts` - リリース処理スクリプト
- E-17: `bin/plugins/checkPlugin.ts` - プラグインチェックスクリプト
- E-18: `bin/plugins/stalePlugins.ts` - 古いプラグイン検出スクリプト

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 全パッドチェックが正常完了 | E-01: L13-28 | ○ |
| C-02 | 引数不正時エラースロー (checkAllPads) | E-01: L11 | ○ |
| C-03 | パッドチェックエラー時のログ出力 | E-01: L21-23 | ○ |
| C-04 | パッド0件時の正常終了 | E-01: L17, L27 | ○ |
| C-05 | 単一パッドチェック正常完了 | E-02: L15-25 | ○ |
| C-06 | 引数不正時エラースロー (checkPad) | E-02: L11 | ○ |
| C-07 | 存在しないパッド指定時エラー | E-02: L20 | ○ |
| C-08 | パッドチェックエラーのキャッチ | E-02: L27-29 | ○ |
| C-09 | プラグイン永続化正常動作 | E-03: L6-17 | ○ |
| C-10 | プラグイン0件時の空配列保存 | E-03: L7-16 | ○ |
| C-11 | 重複プラグイン除去 | E-03: L15 | ○ |
| C-12 | ユーザーセッション作成正常動作 | E-04: L22-57 | ○ |
| C-13 | APIバージョン取得失敗時エラー | E-04: L33 | ○ |
| C-14 | グループ作成失敗時エラー | E-04: L38 | ○ |
| C-15 | グループパッド作成失敗時エラー | E-04: L43 | ○ |
| C-16 | 作者作成失敗時エラー | E-04: L47 | ○ |
| C-17 | セッション作成失敗時エラー | E-04: L54 | ○ |
| C-18 | 全グループセッション削除正常動作 | E-05: L24-52 | ○ |
| C-19 | グループ0件時の正常終了 | E-05: L35-50 | ○ |
| C-20 | セッションnull時のスキップ | E-05: L40, L43 | ○ |
| C-21 | パッド削除正常動作 | E-06: L31-41 | ○ |
| C-22 | 引数不正時エラースロー (deletePad) | E-06: L22 | ○ |
| C-23 | APIバージョン取得失敗時エラー (deletePad) | E-06: L34 | ○ |
| C-24 | パッド削除失敗時エラー | E-06: L39 | ○ |
| C-25 | パッドデータ抽出正常動作 | E-07: L19-63 | ○ |
| C-26 | 引数不正時エラースロー (extractPadData) | E-07: L14 | ○ |
| C-27 | 全リビジョン抽出 | E-07: L45-47 | ○ |
| C-28 | 全チャット抽出 | E-07: L50-52 | ○ |
| C-29 | 全著者情報抽出 | E-07: L42 | ○ |
| C-30 | JSON文字列パース | E-07: L56-58 | ○ |
| C-31 | リリースノート抽出正常動作 | E-08: L23-38 | ○ |
| C-32 | タグ未指定時エラー終了 | E-08: L12-15 | ○ |
| C-33 | タグプレフィックス除去 | E-08: L17 | ○ |
| C-34 | 該当バージョン不存在時の動作 | E-08: L38 | ○ |
| C-35 | 文字列アンエスケープ正常動作 | E-09: L20-36 | ○ |
| C-36 | NULL値変換 | E-09: L39-41 | ○ |
| C-37 | true文字列変換 | E-09: L42-44 | ○ |
| C-38 | false文字列変換 | E-09: L45-47 | ○ |
| C-39 | 数値文字列の処理 | E-09: L50 | ○ |
| C-40 | エスケープシーケンス変換 | E-09: L25-33 | ○ |
| C-41 | 経過時間付きログ出力 | E-09: L16-18 | ○ |
| C-42 | SQLインポート正常動作 | E-09: L53-103 | ○ |
| C-43 | SQLファイル未指定時エラー | E-09: L69 | ○ |
| C-44 | REPLACE INTO文パース | E-09: L82-93 | ○ |
| C-45 | ディレクトリ作成 | E-10: L10-14 | ○ |
| C-46 | 既存ディレクトリ処理 | E-10: L11-13 | ○ |
| C-47 | フォルダ再帰コピー | E-10: L17-43 | ○ |
| C-48 | コピー先既存ディレクトリ削除 | E-10: L18-25 | ○ |
| C-49 | コピー先既存ファイル削除 | E-10: L22-24 | ○ |
| C-50 | asciidoctor未インストール時エラー | E-10: L45-51 | ○ |
| C-51 | DB間移行正常動作 | E-11: L66-80 | ○ |
| C-52 | 引数不正時エラー (migrateDB) | E-11: L12-15 | ○ |
| C-53 | 全キー移行 | E-11: L70-74 | ○ |
| C-54 | 移行エラー時ログ出力 | E-11: L79-80 | ○ |
| C-55 | dirtyDB移行正常動作 | E-12: L31-58 | ○ |
| C-56 | レコード0件時の正常終了 | E-12: L37, L54 | △ |
| C-57 | 進捗100件ごと出力 | E-12: L47 | ○ |
| C-58 | レジストリからプラグインインストール | E-13: L35-46 | ○ |
| C-59 | バージョン指定インストール | E-13: L40-43 | ○ |
| C-60 | ローカルパスからインストール | E-13: L48-51 | ○ |
| C-61 | GitHubからインストール | E-13: L53-56 | ○ |
| C-62 | プラグイン一覧表示 | E-13: L66-77 | ○ |
| C-63 | プラグイン削除 | E-13: L79-92 | ○ |
| C-64 | 引数未指定時エラー (plugins) | E-13: L8-11 | ○ |
| C-65 | 不明アクション時エラー | E-13: L115-117 | ○ |
| C-66 | パッド再構築正常動作 | E-14: L21-85 | ○ |
| C-67 | カスタムID指定再構築 | E-14: L19 | ○ |
| C-68 | 引数不正時エラー (rebuildPad) | E-14: L12-13 | ○ |
| C-69 | 無効パッドID時エラー | E-14: L29-31 | ○ |
| C-70 | 既存パッドID時エラー | E-14: L32-33 | ○ |
| C-71 | リビジョン不存在時エラー | E-14: L55 | ○ |
| C-72 | チャットリビジョンクローン | E-14: L39-44 | ○ |
| C-73 | 保存済みリビジョンコピー | E-14: L68-75 | ○ |
| C-74 | パッド修復正常動作 | E-15: L22-60 | ○ |
| C-75 | 引数不正時エラー (repairPad) | E-15: L15 | ○ |
| C-76 | 進捗100件ごと出力 (repairPad) | E-15: L50 | ○ |
| C-77 | runcコマンド実行結果返却 | E-16: L49-50 | ○ |
| C-78 | 末尾改行除去 | E-16: L50 | ○ |
| C-79 | runコマンドstdio継承実行 | E-16: L52 | ○ |
| C-80 | JSON読み込み・パース | E-16: L54 | ○ |
| C-81 | クリーン作業ディレクトリ検証成功 | E-16: L56-75 | ○ |
| C-82 | 変更ファイル検出時エラー | E-16: L64-66 | ○ |
| C-83 | 未追跡ファイル検出時エラー | E-16: L67-69 | ○ |
| C-84 | ステージ変更検出時エラー | E-16: L71-74 | ○ |
| C-85 | ブランチ検証成功 | E-16: L77-85 | ○ |
| C-86 | ブランチ不一致時エラー | E-16: L81-84 | ○ |
| C-87 | アップストリーム検証成功 | E-16: L87-100 | ○ |
| C-88 | プッシュ漏れ検出時エラー | E-16: L97-99 | ○ |
| C-89 | ディレクトリ存在確認true | E-16: L111-118 | ○ |
| C-90 | ディレクトリ不存在確認false | E-16: L114-117 | ○ |
| C-91 | リリースタイプ未指定時エラー | E-16: L34-37 | ○ |
| C-92 | 無効リリースタイプ時エラー | E-16: L39-42 | ○ |
| C-93 | CHANGELOGレコード不存在時エラー | E-16: L145-147 | ○ |
| C-94 | ドキュメントリポジトリ不存在時エラー | E-16: L127-130 | ○ |
| C-95 | package.json書き込み | E-17: L54-59 | ○ |
| C-96 | エントリ一致時false返却 | E-17: L61-76 | ○ |
| C-97 | エントリ不一致時自動修正 | E-17: L66-73 | ○ |
| C-98 | 依存関係更新 | E-17: L78-114 | ○ |
| C-99 | 依存関係null時削除 | E-17: L105-106 | ○ |
| C-100 | リポジトリ検証成功 | E-17: L116-144 | ○ |
| C-101 | 未追跡ファイル検出時エラー (checkPlugin) | E-17: L124-125 | ○ |
| C-102 | ファイル内容一致時正常 | E-17: L146-167 | ○ |
| C-103 | ファイル自動修正 | E-17: L162-165 | ○ |
| C-104 | テンプレート処理 | E-17: L288-294 | ○ |
| C-105 | プラグイン名未指定時エラー | E-17: L34 | ○ |
| C-106 | .git不存在時エラー | E-17: L178 | ○ |
| C-107 | 古いプラグイン検出 | E-18: L9-22 | ○ |
| C-108 | 730日ちょうどの境界値 | E-18: L18 | △ |
| C-109 | 731日の境界値 | E-18: L18 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-56**: dirtyDBが空の場合の動作は、コード上明示的に0件時の分岐がないため、実際の動作確認が必要。ただし、空配列のイテレーションは問題なく動作すると推測される。
- **C-108**: 境界値が730日（365*2）「ちょうど」の場合、条件 `diffDays > (365 * 2)` により出力されないが、テストでの明示的な検証が望ましい。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 大部分のテストケースはソースコードから直接導出可能
- **1: 中リスク** - 日付計算やファイル操作の境界値テストは実行時の確認が推奨される
- **0: 低リスク** - エラーハンドリングのテストケースはコード上のthrow文から確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 各CLIスクリプトの引数バリデーションテストが網羅されているか確認
- [ ] 外部API呼び出し（Etherpad API、npm registry、GitHub）のモック戦略を検討
- [ ] DB接続が必要なテストのセットアップ/ティアダウン方法を確認
- [ ] ファイルシステム操作（作成、削除、コピー）のテスト環境を確認
- [ ] git操作を含むテストの隔離方法を検討
- [ ] 非同期処理のテストタイムアウト設定を確認
