---
generated_at: 2026-02-10 14:45:00
metrics:
  claims_total: 61
  claims_with_evidence: 61
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-core 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：61 / 61、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/server.ts` - サーバーコア（起動・停止・終了処理、状態管理）
- E-02: `src/node/metrics.ts` - Prometheusメトリクス定義
- E-03: `src/node/prometheus.ts` - メトリクス収集・監視関数
- E-04: `src/node/padaccess.ts` - パッドアクセス権限チェック
- E-05: `src/node/stats.ts` - measured-coreメトリクスコレクション

## 3) Claims と根拠の対応（レビューの主戦場）

### server.ts関連（36件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | addProxyToAxios: 有効なプロキシURLでaxiosのデフォルトプロキシが設定される | E-01 (L42-52) | ○ |
| C-02 | addProxyToAxios: 認証情報なしでも設定可能 | E-01 (L42-52) | ○ |
| C-03 | addProxyToAxios: ポート番号省略時の挙動 | E-01 (L49) | ○ |
| C-04 | addProxyToAxios: HTTPSプロトコル対応 | E-01 (L51) | ○ |
| C-05 | removeSignalListener: SIGINTリスナー削除 | E-01 (L99-104) | ○ |
| C-06 | removeSignalListener: SIGTERMリスナー削除 | E-01 (L99-104) | ○ |
| C-07 | exports.start: INITIAL状態からの起動 | E-01 (L108-200) | ○ |
| C-08 | exports.start: STARTING状態での待機 | E-01 (L112-115) | ○ |
| C-09 | exports.start: RUNNING状態での即時返却 | E-01 (L116-117) | ○ |
| C-10 | exports.start: STOPPING状態でのエラー | E-01 (L118-123) | ○ |
| C-11 | exports.start: STOPPED状態でのエラー | E-01 (L118-123) | ○ |
| C-12 | exports.start: EXITING状態でのエラー | E-01 (L118-123) | ○ |
| C-13 | exports.start: 不明状態でのエラー | E-01 (L124-125) | ○ |
| C-14 | exports.start: DB初期化失敗時のエラー状態遷移 | E-01 (L173, L185-191) | ○ |
| C-15 | exports.start: プラグイン更新失敗時のエラー状態遷移 | E-01 (L175, L185-191) | ○ |
| C-16 | exports.start: memoryUsageゲージのセットアップ | E-01 (L135) | ○ |
| C-17 | exports.start: memoryUsageHeapゲージのセットアップ | E-01 (L137) | ○ |
| C-18 | exports.stop: RUNNING状態からの停止 | E-01 (L203-245) | ○ |
| C-19 | exports.stop: STARTING状態での待機後停止 | E-01 (L205-208) | ○ |
| C-20 | exports.stop: STOPPING状態での待機 | E-01 (L211-212) | ○ |
| C-21 | exports.stop: INITIAL状態での即時復帰 | E-01 (L214-219) | ○ |
| C-22 | exports.stop: STOPPED状態での即時復帰 | E-01 (L214-219) | ○ |
| C-23 | exports.stop: 不明状態でのエラー | E-01 (L220-221) | ○ |
| C-24 | exports.stop: シャットダウンタイムアウト | E-01 (L226-232) | ○ |
| C-25 | exports.stop: シャットダウンエラー | E-01 (L234-239) | ○ |
| C-26 | exports.exit: SIGTERMシグナル処理 | E-01 (L251-254) | ○ |
| C-27 | exports.exit: エラーなし正常終了 | E-01 (L249-312) | ○ |
| C-28 | exports.exit: エラー時のexitCode設定 | E-01 (L255-262) | ○ |
| C-29 | exports.exit: STARTING状態での処理 | E-01 (L267-274) | ○ |
| C-30 | exports.exit: RUNNING状態での処理 | E-01 (L267-274) | ○ |
| C-31 | exports.exit: INITIAL状態でのEXITING遷移 | E-01 (L275-278) | ○ |
| C-32 | exports.exit: EXITING状態での待機 | E-01 (L279-280) | ○ |
| C-33 | exports.exit: WAITING_FOR_EXIT状態での即時復帰 | E-01 (L282-283) | ○ |
| C-34 | exports.exit: 不明状態でのエラー | E-01 (L284-285) | ○ |
| C-35 | exports.exit: 二重エラー時の強制終了 | E-01 (L259-262) | ○ |
| C-36 | exports.exit: dumpOnUncleanExit設定時のダンプ | E-01 (L298-302) | ○ |

### metrics.ts関連（7件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | metrics.cpu: CPUゲージ定義 | E-02 (L4) | ○ |
| C-38 | metrics.memory_process: プロセスメモリゲージ定義 | E-02 (L5) | ○ |
| C-39 | metrics.memory_physical: 物理メモリゲージ定義 | E-02 (L6) | ○ |
| C-40 | metrics.eventloop_latency: イベントループゲージ定義 | E-02 (L7) | ○ |
| C-41 | metrics.gc: GCゲージ定義 | E-02 (L8) | ○ |
| C-42 | metrics.gc_duration: GCサマリー定義 | E-02 (L9) | ○ |
| C-43 | metrics.http_duration: HTTPサマリー定義 | E-02 (L10) | ○ |

### prometheus.ts関連（8件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | monitor: DBメトリクス収集 | E-03 (L29-32) | ○ |
| C-45 | monitor: アクティブパッド数設定 | E-03 (L33) | ○ |
| C-46 | monitor: 総ユーザー数設定 | E-03 (L34) | ○ |
| C-47 | monitor: レジストリ返却 | E-03 (L35) | ○ |
| C-48 | monitor: 空メトリクス時の挙動 | E-03 (L29-32) | ○ |
| C-49 | monitor: 非数値メトリクスのスキップ | E-03 (L30) | ○ |
| C-50 | monitor: パッド数0時の挙動 | E-03 (L33) | ○ |
| C-51 | monitor: ユーザー数0時の挙動 | E-03 (L34) | ○ |

### padaccess.ts関連（5件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | padaccess: アクセス許可時のtrue返却 | E-04 (L10-12) | ○ |
| C-53 | padaccess: アクセス拒否時の403返却 | E-04 (L13-16) | ○ |
| C-54 | padaccess: セッションundefined時の処理 | E-04 (L6) | ○ |
| C-55 | padaccess: クッキーundefined時の処理 | E-04 (L7-8) | ○ |
| C-56 | padaccess: パラメータundefined時の処理 | E-04 (L8) | ○ |

### stats.ts関連（5件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | stats: コレクション作成 | E-05 (L5) | ○ |
| C-58 | stats.shutdown: end()呼び出し | E-05 (L8-9) | ○ |
| C-59 | stats.shutdown: フック名非依存 | E-05 (L8) | ○ |
| C-60 | stats: ゲージ登録（measured-core API） | E-05 (L5, measured-core API) | ○ |
| C-61 | stats: toJSON出力（measured-core API） | E-05 (L5, measured-core API) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全テストケースにソースコード根拠あり）

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースにソースコード根拠あり
- 注意点：
  - server.tsの状態遷移ロジックは複雑なため、実際のテスト実装時には状態遷移図と照らし合わせることを推奨
  - measured-core（stats.ts）のAPIはライブラリ依存のため、バージョンアップ時に確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] server.tsの状態遷移（State enum）が全パターン網羅されているか確認
- [ ] シグナルハンドリング（SIGINT/SIGTERM）のテストケースが実行環境で動作するか確認
- [ ] Prometheusメトリクス定義が本番運用要件と一致しているか確認
- [ ] padaccess.tsのセキュリティ関連テストケースが十分か確認
- [ ] measured-coreライブラリのAPI互換性を確認
