---
generated_at: 2026-02-10 12:00:00
metrics:
  claims_total: 200
  claims_with_evidence: 200
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-db 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：200 / 200、根拠なし：0
- 優先レビュー（高）
  1. なし - 全テストケースはソースコードに基づいて生成されています

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/db/DB.ts` - データベース初期化・終了処理
- E-02: `src/node/db/Pad.ts` - Padクラスの定義、メソッド実装
- E-03: `src/node/db/PadManager.ts` - Pad管理機能（キャッシュ、作成、削除）
- E-04: `src/node/db/AuthorManager.ts` - 著者管理機能
- E-05: `src/node/db/SessionManager.ts` - セッション管理機能
- E-06: `src/node/db/GroupManager.ts` - グループ管理機能
- E-07: `src/node/db/SecurityManager.ts` - アクセス制御機能
- E-08: `src/node/db/ReadOnlyManager.ts` - 読み取り専用ID管理
- E-09: `src/node/db/SessionStore.ts` - express-session用ストア
- E-10: `src/node/db/API.ts` - 外部API関数群

## 3) Claims と根拠の対応（レビューの主戦場）

### DB.ts（UT-NDB-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | DB.init()でデータベースが初期化される | E-01 L39-54 | ○ |
| C-002 | メトリクスがあればstats.gaugeが登録される | E-01 L42-47 | ○ |
| C-003 | DB.shutdown()でデータベースが閉じられる | E-01 L56-60 | ○ |
| C-004 | DBがnullでもshutdownが正常終了する | E-01 L57 (null check) | ○ |

### Pad.ts（UT-NDB-005〜057）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-005 | Padコンストラクタで初期化される | E-02 L58-67 | ○ |
| C-006 | getHeadRevisionNumber()でhead返却 | E-02 L73-75 | ○ |
| C-007 | getSavedRevisionsNumber()でlength返却 | E-02 L77-79 | ○ |
| C-008 | getSavedRevisionsList()でソート済み返却 | E-02 L81-85 | ○ |
| C-009 | 空savedRevisionsで空配列返却 | E-02 L81-85 | ○ |
| C-010 | getPublicStatus()でpublicStatus返却 | E-02 L87-89 | ○ |
| C-011 | appendRevision()で新リビジョン追加 | E-02 L97-144 | ○ |
| C-012 | 変更なしで既存head返却 | E-02 L99-102 | ○ |
| C-013 | authorIdがpoolに追加される | E-02 L108 | ○ |
| C-014 | toJSON()でシリアライズ | E-02 L146-153 | ○ |
| C-015 | saveToDatabase()でDB保存 | E-02 L156-159 | ○ |
| C-016 | getLastEdit()でタイムスタンプ返却 | E-02 L162-166 | ○ |
| C-017 | getRevisionChangeset()でchangeset返却 | E-02 L168-171 | ○ |
| C-018 | getRevisionAuthor()で著者ID返却 | E-02 L173-176 | ○ |
| C-019 | getRevisionDate()でタイムスタンプ返却 | E-02 L178-181 | ○ |
| C-020 | getAllAuthors()で著者リスト返却 | E-02 L196-206 | ○ |
| C-021 | 著者なしで空配列返却 | E-02 L196-206 | ○ |
| C-022 | getInternalRevisionAText()でAtext返却 | E-02 L208-221 | ○ |
| C-023 | targetRev>headでhead返却 | E-02 L211 | ○ |
| C-024 | getAllAuthorColors()で色マップ返却 | E-02 L227-239 | ○ |
| C-025 | getValidRevisionRange()で範囲返却 | E-02 L241-260 | ○ |
| C-026 | 不正startRevでnull返却 | E-02 L246-248 | ○ |
| C-027 | endRev>headでhead調整 | E-02 L252-254 | ○ |
| C-028 | getKeyRevisionNumber()で100刻み | E-02 L262-264 | ○ |
| C-029 | text()でテキスト返却 | E-02 L269-271 | ○ |
| C-030 | spliceText()でテキストスプライス | E-02 L284-299 | ○ |
| C-031 | start<0でRangeError | E-02 L285 | ○ |
| C-032 | ndel<0でRangeError | E-02 L286 | ○ |
| C-033 | 範囲外でRangeError | E-02 L289 | ○ |
| C-034 | 改行自動追加 | E-02 L291-295 | ○ |
| C-035 | setText()でテキスト置換 | E-02 L309-311 | ○ |
| C-036 | appendText()で末尾追加 | E-02 L320-322 | ○ |
| C-037 | appendChatMessage()でチャット追加 | E-02 L334-345 | ○ |
| C-038 | 文字列でもChatMessage作成 | E-02 L335-336 | ○ |
| C-039 | getChatMessage()でメッセージ取得 | E-02 L351-357 | ○ |
| C-040 | 存在しないentryNumでnull | E-02 L353 | ○ |
| C-041 | getChatMessages()で範囲取得 | E-02 L366-380 | ○ |
| C-042 | 壊れたエントリフィルタ | E-02 L373-379 | ○ |
| C-043 | init()で既存Padロード | E-02 L382-401 | ○ |
| C-044 | init()で新規Pad作成 | E-02 L391-399 | ○ |
| C-045 | text=nullでdefaultPadText使用 | E-02 L392-395 | ○ |
| C-046 | copy()でPadコピー | E-02 L403-454 | ○ |
| C-047 | グループ不存在でエラー | E-02 L464-466 | ○ |
| C-048 | force=trueで上書き | E-02 L471-492 | ○ |
| C-049 | force=falseで重複エラー | E-02 L483-486 | ○ |
| C-050 | copyPadWithoutHistory()で履歴なしコピー | E-02 L500-555 | ○ |
| C-051 | remove()でPad削除 | E-02 L557-615 | ○ |
| C-052 | グループPad削除時グループ更新 | E-02 L570-580 | ○ |
| C-053 | setPublicStatus()で公開設定 | E-02 L618-621 | ○ |
| C-054 | addSavedRevision()でリビジョン保存 | E-02 L623-642 | ○ |
| C-055 | 重複保存防止 | E-02 L625-628 | ○ |
| C-056 | check()で整合性検証 | E-02 L651-766 | ○ |
| C-057 | cleanText()でテキストクリーン | E-02 L36-39 | ○ |

### PadManager.ts（UT-NDB-058〜073）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-058 | getPad()でキャッシュから返却 | E-03 L128-133 | ○ |
| C-059 | getPad()で新規作成・キャッシュ追加 | E-03 L136-143 | ○ |
| C-060 | 不正padIdでエラー | E-03 L111-113 | ○ |
| C-061 | textが文字列でなくエラー | E-03 L118-120 | ○ |
| C-062 | text>100kでエラー | E-03 L123-125 | ○ |
| C-063 | listAllPads()で一覧返却 | E-03 L146-150 | ○ |
| C-064 | doesPadExist()でtrue | E-03 L156-159 | ○ |
| C-065 | doesPadExist()でfalse | E-03 L156-159 | ○ |
| C-066 | sanitizePadId()で空白置換 | E-03 L175-193 | ○ |
| C-067 | sanitizePadId()でコロン置換 | E-03 L169-172 | ○ |
| C-068 | lowerCasePadIds設定で小文字化 | E-03 L189 | ○ |
| C-069 | isValidPadId()でtrue | E-03 L195 | ○ |
| C-070 | グループパッドIDで有効 | E-03 L195 | ○ |
| C-071 | 50文字超でfalse | E-03 L195 | ○ |
| C-072 | removePad()でDB・キャッシュ削除 | E-03 L200-205 | ○ |
| C-073 | unloadPad()でキャッシュ削除 | E-03 L208-210 | ○ |

### AuthorManager.ts（UT-NDB-074〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-074 | getColorPalette()で色配列返却 | E-04 L27-92 | ○ |
| C-075 | doesAuthorExist()でtrue | E-04 L98-102 | ○ |
| C-076 | doesAuthorExist()でfalse | E-04 L98-102 | ○ |
| C-077 | getAuthorId()でauthorId取得 | E-04 L158-163 | ○ |
| C-078 | フックで上書き | E-04 L160-161 | ○ |
| C-079 | createAuthorIfNotExistsFor()で既存返却 | E-04 L182-191 | ○ |
| C-080 | createAuthorIfNotExistsFor()で新規作成 | E-04 L182-191 | ○ |
| C-081 | createAuthor()で新規作成 | E-04 L198-213 | ○ |
| C-082 | name=nullでも作成 | E-04 L198-213 | ○ |
| C-083 | getAuthor()で著者オブジェクト返却 | E-04 L219 | ○ |
| C-084 | getAuthorColorId()で色ID返却 | E-04 L225 | ○ |
| C-085 | setAuthorColorId()で色ID設定 | E-04 L232-233 | ○ |
| C-086 | getAuthorName()で名前返却 | E-04 L239 | ○ |
| C-087 | setAuthorName()で名前設定 | E-04 L246-247 | ○ |
| C-088 | listPadsOfAuthor()でPadリスト返却 | E-04 L253-271 | ○ |
| C-089 | 著者不存在でエラー | E-04 L262-264 | ○ |
| C-090 | padIDs=undefinedで空配列 | E-04 L268 | ○ |
| C-091 | addPad()でPad追加 | E-04 L278-298 | ○ |
| C-092 | 著者不存在で何もしない | E-04 L282 | ○ |
| C-093 | removePad()でPad削除 | E-04 L305-314 | ○ |
| C-094 | 著者不存在で何もしない | E-04 L308 | ○ |

### SessionManager.ts（UT-NDB-095〜115）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-095 | findAuthorID()で著者ID返却 | E-05 L39-85 | ○ |
| C-096 | sessionCookie=falsyでundefined | E-05 L40 | ○ |
| C-097 | 引用符除去 | E-05 L64 | ○ |
| C-098 | 期限切れでundefined | E-05 L81 | ○ |
| C-099 | doesSessionExist()でtrue | E-05 L92-96 | ○ |
| C-100 | doesSessionExist()でfalse | E-05 L92-96 | ○ |
| C-101 | createSession()でセッション作成 | E-05 L105-159 | ○ |
| C-102 | グループ不存在でエラー | E-05 L107-110 | ○ |
| C-103 | 著者不存在でエラー | E-05 L113-116 | ○ |
| C-104 | validUntilが数値でなくエラー | E-05 L124-126 | ○ |
| C-105 | validUntilが負でエラー | E-05 L129-131 | ○ |
| C-106 | validUntilが小数でエラー | E-05 L134-136 | ○ |
| C-107 | validUntilが過去でエラー | E-05 L139-141 | ○ |
| C-108 | getSessionInfo()でセッション情報返却 | E-05 L166-177 | ○ |
| C-109 | セッション不存在でエラー | E-05 L170-173 | ○ |
| C-110 | deleteSession()でセッション削除 | E-05 L184-206 | ○ |
| C-111 | セッション不存在でエラー | E-05 L187-189 | ○ |
| C-112 | listSessionsOfGroup()でセッション一覧 | E-05 L213-222 | ○ |
| C-113 | グループ不存在でエラー | E-05 L215-218 | ○ |
| C-114 | listSessionsOfAuthor()でセッション一覧 | E-05 L229-237 | ○ |
| C-115 | 著者不存在でエラー | E-05 L231-234 | ○ |

### GroupManager.ts（UT-NDB-116〜130）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | listAllGroups()でグループ一覧 | E-06 L32-38 | ○ |
| C-117 | グループなしで空配列 | E-06 L34 | ○ |
| C-118 | deleteGroup()でグループ削除 | E-06 L45-78 | ○ |
| C-119 | グループ不存在でエラー | E-06 L49-52 | ○ |
| C-120 | doesGroupExist()でtrue | E-06 L85-90 | ○ |
| C-121 | doesGroupExist()でfalse | E-06 L85-90 | ○ |
| C-122 | createGroup()でグループ作成 | E-06 L96-104 | ○ |
| C-123 | createGroupIfNotExistsFor()で既存返却 | E-06 L111-127 | ○ |
| C-124 | createGroupIfNotExistsFor()で新規作成 | E-06 L117-126 | ○ |
| C-125 | groupMapperが文字列でなくエラー | E-06 L112-114 | ○ |
| C-126 | createGroupPad()でグループPad作成 | E-06 L137-163 | ○ |
| C-127 | グループ不存在でエラー | E-06 L144-146 | ○ |
| C-128 | Pad既存でエラー | E-06 L151-154 | ○ |
| C-129 | listPads()でグループPad一覧 | E-06 L170-183 | ○ |
| C-130 | グループ不存在でエラー | E-06 L174-176 | ○ |

### SecurityManager.ts（UT-NDB-131〜141）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-131 | checkAccess()でgrant返却 | E-07 L60-150 | ○ |
| C-132 | padID=nullでdeny | E-07 L61-64 | ○ |
| C-133 | readOnlyID解決 | E-07 L68-75 | ○ |
| C-134 | 不正readOnlyIDでdeny | E-07 L71-74 | ○ |
| C-135 | 認証必須でuserSettings=nullでdeny | E-07 L82-85 | ○ |
| C-136 | 認可なしでdeny | E-07 L92-95 | ○ |
| C-137 | フックfalseでdeny | E-07 L101-104 | ○ |
| C-138 | Pad不存在・canCreate=falseでdeny | E-07 L106-110 | ○ |
| C-139 | requireSession・セッションなしでdeny | E-07 L113-116 | ○ |
| C-140 | 不正tokenでdeny | E-07 L117-121 | ○ |
| C-141 | 非公開グループ・セッションなしでdeny | E-07 L144-147 | ○ |

### ReadOnlyManager.ts（UT-NDB-142〜149）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-142 | isReadOnlyId()でr.でtrue | E-08 L32 | ○ |
| C-143 | isReadOnlyId()でr.以外でfalse | E-08 L32 | ○ |
| C-144 | getReadOnlyId()で既存ID返却 | E-08 L39-53 | ○ |
| C-145 | getReadOnlyId()で新規作成 | E-08 L44-50 | ○ |
| C-146 | getPadId()でpadId返却 | E-08 L60 | ○ |
| C-147 | マッピングなしでnull | E-08 L60 | ○ |
| C-148 | getIds()でreadOnlyから変換 | E-08 L67-75 | ○ |
| C-149 | getIds()でpadIdから変換 | E-08 L67-75 | ○ |

### SessionStore.ts（UT-NDB-150〜156）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-150 | SessionStore初期化 | E-09 L24-33 | ○ |
| C-151 | shutdown()でタイムアウトクリア | E-09 L35-37 | ○ |
| C-152 | _get()でセッション取得 | E-09 L73-77 | ○ |
| C-153 | _set()でセッション保存 | E-09 L79-83 | ○ |
| C-154 | _destroy()でセッション削除 | E-09 L85-90 | ○ |
| C-155 | _touch()で期限更新 | E-09 L95-107 | ○ |
| C-156 | refresh未達でDB書き込みなし | E-09 L104 | ○ |

### API.ts（UT-NDB-157〜200）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-157 | getAttributePool()で属性プール返却 | E-10 L109-112 | ○ |
| C-158 | getRevisionChangeset()でchangeset返却 | E-10 L127-150 | ○ |
| C-159 | rev>headでエラー | E-10 L140-142 | ○ |
| C-160 | getText()でテキスト返却 | E-10 L160-187 | ○ |
| C-161 | 指定revのテキスト返却 | E-10 L171-181 | ○ |
| C-162 | setText()でテキスト設定 | E-10 L205-216 | ○ |
| C-163 | textが文字列でなくエラー | E-10 L207-209 | ○ |
| C-164 | appendText()でテキスト追加 | E-10 L230-239 | ○ |
| C-165 | getHTML()でHTML返却 | E-10 L252-274 | ○ |
| C-166 | setHTML()でHTML設定 | E-10 L288-306 | ○ |
| C-167 | htmlが文字列でなくエラー | E-10 L290-292 | ○ |
| C-168 | 不正HTMLでエラー | E-10 L300-302 | ○ |
| C-169 | getChatHistory()でチャット履歴返却 | E-10 L329-364 | ○ |
| C-170 | start<0でエラー | E-10 L331-333 | ○ |
| C-171 | end<0でエラー | E-10 L334-336 | ○ |
| C-172 | start>endでエラー | E-10 L337-339 | ○ |
| C-173 | appendChatMessage()でチャット追加 | E-10 L379-394 | ○ |
| C-174 | textが文字列でなくエラー | E-10 L381-383 | ○ |
| C-175 | getRevisionsCount()でリビジョン数返却 | E-10 L409-413 | ○ |
| C-176 | getSavedRevisionsCount()で保存リビジョン数返却 | E-10 L424-428 | ○ |
| C-177 | listSavedRevisions()で保存リビジョン一覧 | E-10 L439-443 | ○ |
| C-178 | saveRevision()でリビジョン保存 | E-10 L455-476 | ○ |
| C-179 | getLastEdited()で最終編集時刻返却 | E-10 L488-493 | ○ |
| C-180 | createPad()でPad作成 | E-10 L506-521 | ○ |
| C-181 | padIDに$でエラー | E-10 L509-511 | ○ |
| C-182 | 特殊文字でエラー | E-10 L514-516 | ○ |
| C-183 | deletePad()でPad削除 | E-10 L532-535 | ○ |
| C-184 | restoreRevision()でリビジョン復元 | E-10 L548-601 | ○ |
| C-185 | rev=undefinedでエラー | E-10 L550-552 | ○ |
| C-186 | copyPad()でPadコピー | E-10 L615-618 | ○ |
| C-187 | copyPadWithoutHistory()で履歴なしコピー | E-10 L633-636 | ○ |
| C-188 | movePad()でPad移動 | E-10 L650-654 | ○ |
| C-189 | getReadOnlyID()でreadOnlyID返却 | E-10 L665-673 | ○ |
| C-190 | getPadID()でpadID返却 | E-10 L684-692 | ○ |
| C-191 | 不正roIDでエラー | E-10 L687-689 | ○ |
| C-192 | setPublicStatus()で公開設定 | E-10 L704-717 | ○ |
| C-193 | グループPad以外でエラー | E-10 L706 (checkGroupPad) | ○ |
| C-194 | getPublicStatus()で公開状態取得 | E-10 L728-735 | ○ |
| C-195 | listAuthorsOfPad()で著者一覧 | E-10 L746-751 | ○ |
| C-196 | sendClientsMessage()でメッセージ送信 | E-10 L778-781 | ○ |
| C-197 | checkToken()で常に成功 | E-10 L791-792 | ○ |
| C-198 | getChatHead()でchatHead返却 | E-10 L804-808 | ○ |
| C-199 | createDiffHTML()でDiff HTML返却 | E-10 L830-859 | ○ |
| C-200 | getStats()で統計情報返却 | E-10 L873-887 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全テストケースは実際のソースコードを根拠として生成されています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに直接基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] 高優先度テストケース（認証・認可、データ整合性関連）が漏れなくカバーされているか確認
- [ ] 各ファイルの主要関数がテストケースに含まれているか確認
- [ ] エラーハンドリング（CustomError、RangeError）のテストケースが適切か確認
- [ ] 境界値テストケース（空配列、null、最大値）が適切に設計されているか確認
- [ ] データベース操作（CRUD）のテストケースが網羅されているか確認
