---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 155
  claims_with_evidence: 155
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-handler 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：155 / 155、根拠なし：0
- 優先レビュー（高）
  1. **UT-HND-022〜025**：セキュリティ関連のテストケース（権限チェック、レート制限、Author ID検証）
  2. **UT-HND-051〜057**：リアルタイム編集のコア機能（handleUserChanges）
  3. **UT-HND-126〜135**：API認証・認可のテストケース

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/handler/PadMessageHandler.ts` (1355行)
- E-02: `src/node/handler/ImportHandler.ts` (265行)
- E-03: `src/node/handler/ExportHandler.ts` (127行)
- E-04: `src/node/handler/RestAPI.ts` (1528行)
- E-05: `src/node/handler/SocketIORouter.ts` (107行)
- E-06: `src/node/handler/APIHandler.ts` (220行)
- E-07: `src/node/handler/APIKeyHandler.ts` (36行)
- E-08: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト構成情報

## 3) Claims と根拠の対応（レビューの主戦場）

### PadMessageHandler.ts (UT-HND-001〜087)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Channelsクラスはタスクをキューイングし順次実行する | E-01 (L121-152) | ○ |
| C-02 | exports.socketioはRateLimiterMemoryを初期化する | E-01 (L69-74) | ○ |
| C-03 | exports.handleConnectはsessioninfosにエントリを作成する | E-01 (L171-176) | ○ |
| C-04 | exports.kickSessionsFromPadはPadから全セッションを切断する | E-01 (L181-190) | ○ |
| C-05 | exports.handleDisconnectはセッション情報を削除しUSER_LEAVEを送信する | E-01 (L196-227) | ○ |
| C-06 | handlePadDeleteはPad作成者のみ削除を許可する | E-01 (L230-265) | ○ |
| C-07 | exports.handleMessageはメッセージタイプに応じて適切なハンドラを呼び出す | E-01 (L273-436) | ○ |
| C-08 | handleSaveRevisionMessageはリビジョンを保存する | E-01 (L444-448) | ○ |
| C-09 | handleChatMessageはチャットメッセージを送信する | E-01 (L492-499) | ○ |
| C-10 | exports.sendChatMessageToPadClientsはチャットをPadクライアントに送信する | E-01 (L512-526) | ○ |
| C-11 | handleGetChatMessagesは指定範囲のチャット履歴を返す | E-01 (L533-552) | ○ |
| C-12 | handleSuggestUserNameは対象ユーザーにユーザー名提案を送信する | E-01 (L559-571) | ○ |
| C-13 | handleUserInfoUpdateはユーザー情報を更新しブロードキャストする | E-01 (L579-611) | ○ |
| C-14 | handleUserChangesはチェンジセットを処理し適用する | E-01 (L627-736) | ○ |
| C-15 | exports.updatePadClientsは全クライアントに変更を通知する | E-01 (L738-795) | ○ |
| C-16 | _correctMarkersInPadは不正なマーカーを修正する | E-01 (L800-838) | ○ |
| C-17 | handleClientReadyはクライアント初期化を処理する | E-01 (L847-1149) | ○ |
| C-18 | handleChangesetRequestはチェンジセット情報を返す | E-01 (L1154-1169) | ○ |
| C-19 | getChangesetInfoはチェンジセット情報を計算する | E-01 (L1175-1246) | ○ |
| C-20 | getPadLinesはPadの行データを取得する | E-01 (L1252-1266) | ○ |
| C-21 | exports.composePadChangesetsはチェンジセットを合成する | E-01 (L1272-1308) | ○ |
| C-22 | exports.padUsersCountはPadのユーザー数を返す | E-01 (L1327-1329) | ○ |
| C-23 | exports.padUsersはPadのユーザー一覧を返す | E-01 (L1334-1352) | ○ |
| C-24 | getTotalActiveUsersは総アクティブユーザー数を返す | E-01 (L97-99) | ○ |
| C-25 | getActivePadCountFromSessionInfosはアクティブPad数を返す | E-01 (L103-111) | ○ |

### ImportHandler.ts (UT-HND-088〜104)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | ImportErrorクラスはステータス付きエラーを生成する | E-02 (L39-49) | ○ |
| C-27 | rm関数はファイルを削除し、存在しない場合はエラーを無視する | E-02 (L51-57) | ○ |
| C-28 | doImport関数はファイル形式に応じてインポート処理を行う | E-02 (L82-239) | ○ |
| C-29 | exports.doImportはHTTPレスポンスを返す | E-02 (L249-264) | ○ |
| C-30 | ファイルサイズ超過時はmaxFileSizeエラーを返す | E-02 (L104-106) | ○ |
| C-31 | Etherpad形式はhead<10の場合のみ直接インポート可能 | E-02 (L146-157) | ○ |

### ExportHandler.ts (UT-HND-105〜114)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | exports.doExportはファイル形式に応じてエクスポート処理を行う | E-03 (L46-126) | ○ |
| C-33 | TXT形式はexporttxt.getPadTXTDocumentを使用する | E-03 (L72-74) | ○ |
| C-34 | HTML形式はexporthtml.getPadHTMLDocumentを使用する | E-03 (L77) | ○ |
| C-35 | Etherpad形式はexportEtherpad.getPadRawを使用する | E-03 (L70-71) | ○ |
| C-36 | コンバーター使用時は一時ファイルを作成・削除する | E-03 (L91-124) | ○ |
| C-37 | exportFileNameフックでファイル名を変更可能 | E-03 (L51-56) | ○ |

### RestAPI.ts (UT-HND-139〜153)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-38 | expressCreateServerはAPIエンドポイントを登録する | E-04 (L315-1527) | ○ |
| C-39 | swagger-uiは/api-docsで提供される | E-04 (L1420-1425) | ○ |
| C-40 | OpenAPI定義は/api-docs.jsonで提供される | E-04 (L1429-1433) | ○ |
| C-41 | prepareDefinitionはOpenAPI3.0定義を生成する | E-04 (L171-312) | ○ |
| C-42 | prepareResponsesはレスポンススキーマを生成する | E-04 (L142-168) | ○ |
| C-43 | エラーは適切なHTTPステータスコードに変換される | E-04 (L1486-1516) | ○ |

### SocketIORouter.ts (UT-HND-115〜125)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | exports.addComponentはコンポーネントを登録する | E-05 (L44-48) | ○ |
| C-45 | exports.deleteComponentはコンポーネントを削除する | E-05 (L54) | ○ |
| C-46 | exports.setSocketIOはSocket.IOを設定しイベントハンドラを登録する | E-05 (L60-106) | ○ |
| C-47 | メッセージは適切なコンポーネントにルーティングされる | E-05 (L79-91) | ○ |
| C-48 | 切断時は全コンポーネントのhandleDisconnectが呼ばれる | E-05 (L93-104) | ○ |

### APIHandler.ts (UT-HND-126〜135)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | exports.handleはAPIリクエストを処理する | E-06 (L161-219) | ○ |
| C-50 | 未知のAPIバージョンはNotFoundエラーを返す | E-06 (L164-166) | ○ |
| C-51 | 未知の関数名はNotFoundエラーを返す | E-06 (L168-171) | ○ |
| C-52 | APIキー検証が行われる | E-06 (L175-200) | ○ |
| C-53 | OAuth JWTトークン検証が行われる | E-06 (L182-199) | ○ |
| C-54 | padID/padNameはサニタイズされる | E-06 (L202-211) | ○ |

### APIKeyHandler.ts (UT-HND-136〜138)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | APIKEYファイルが存在する場合は読み込まれる | E-07 (L26-28) | ○ |
| C-56 | APIKEYファイルが存在しない場合は生成される | E-07 (L29-34) | ○ |
| C-57 | authenticationMethodがapikey以外の場合はapikeyはnull | E-07 (L25) | ○ |

## 4) 不足情報（Unknown / Missing）
- 現時点で根拠なしの主張はありません
- 全てのテストケースはソースコードの実装に基づいて生成されています

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全テストケースがソースコード解析に基づいており、根拠が明確

### 注意すべき領域
1. **セキュリティテスト（UT-HND-022〜025, 126〜132）**: 認証・認可に関するテストは実際の攻撃シナリオに対する網羅性を確認すること
2. **リアルタイム編集（UT-HND-051〜057）**: Changesetの処理は複雑なため、エッジケースの追加を検討
3. **プラグインフック**: フック呼び出しのテストは、プラグインの実際の動作と整合性を確認すること

## 6) レビュアーチェックリスト（最小）
- [ ] セキュリティ関連テストケース（認証、認可、入力検証）の網羅性を確認
- [ ] 境界値テストケースが適切な値を使用しているか確認
- [ ] エラーメッセージの文言がソースコードと一致しているか確認
- [ ] プラグインフック呼び出しのテストが実際のフック定義と整合しているか確認
- [ ] レート制限テスト（UT-HND-024）の設定値が実際の運用設定と一致しているか確認
- [ ] WebSocketメッセージのテストケースが実際のプロトコルと整合しているか確認
