---
generated_at: 2026-02-10 15:30:00
metrics:
  claims_total: 146
  claims_with_evidence: 146
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-hooks 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：146 / 146、根拠なし：0
- 優先レビュー（高）
  1. なし：全てのテストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express.ts` - メインExpressサーバー設定、HTTPサーバー作成・再起動・停止機能
- E-02: `src/node/hooks/i18n.ts` - 国際化（i18n）機能、ロケールファイル読み込み・マージ
- E-03: `src/node/hooks/express/socketio.ts` - Socket.IO統合、WebSocket接続管理
- E-04: `src/node/hooks/express/errorhandling.ts` - Expressエラーハンドリングミドルウェア
- E-05: `src/node/hooks/express/specialpages.ts` - 特殊ページ（ヘルスチェック、メトリクス、Pad表示等）
- E-06: `src/node/hooks/express/static.ts` - 静的ファイル配信、プラグイン定義配信
- E-07: `src/node/hooks/express/apicalls.ts` - APIコール処理、診断情報・エラーレポート
- E-08: `src/node/hooks/express/pwa.ts` - PWAマニフェスト配信
- E-09: `src/node/hooks/express/admin.ts` - 管理画面静的ファイル配信
- E-10: `src/node/hooks/express/importexport.ts` - インポート・エクスポート機能
- E-11: `src/node/hooks/express/tokenTransfer.ts` - トークン転送機能
- E-12: `src/node/hooks/express/openapi.ts` - OpenAPI定義生成・APIルーティング
- E-13: `src/node/hooks/express/webaccess.ts` - 認証・認可ミドルウェア
- E-14: `src/node/hooks/express/adminplugins.ts` - 管理画面プラグイン管理Socket.IO
- E-15: `src/node/hooks/express/padurlsanitize.ts` - Pad URL検証・サニタイズ
- E-16: `src/node/hooks/express/adminsettings.ts` - 管理画面設定管理Socket.IO

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | HTTPサーバーが正常に作成されること | E-01 (express.ts L67-97, L99-260) | ○ |
| C-002 | HTTPSサーバーが正常に作成されること | E-01 (express.ts L104-127) | ○ |
| C-003 | Unixソケットでサーバーが起動すること | E-01 (express.ts L76-78) | ○ |
| C-004 | サーバーが正常に再起動すること | E-01 (express.ts L99-260) | ○ |
| C-005 | セッションストアが初期化されること | E-01 (express.ts L203) | ○ |
| C-006 | SecretRotatorが起動すること | E-01 (express.ts L186-198) | ○ |
| C-007 | セッションキーがない場合エラーになること | E-01 (express.ts L199) | ○ |
| C-008 | サーバーが正常に閉じられること | E-01 (express.ts L32-65) | ○ |
| C-009 | 接続中のソケットが切断されること | E-01 (express.ts L42-53) | ○ |
| C-010 | sessionStoreがシャットダウンされること | E-01 (express.ts L61-62) | ○ |
| C-011 | shutdownフックでサーバーが閉じられること | E-01 (express.ts L262-264) | ○ |
| C-012 | コアロケールファイルが読み込まれること | E-02 (i18n.ts L16-67) | ○ |
| C-013 | プラグインロケールがマージされること | E-02 (i18n.ts L45-50) | ○ |
| C-014 | カスタムロケール文字列が適用されること | E-02 (i18n.ts L69-101) | ○ |
| C-015 | 不正なカスタムロケール形式でエラーになること | E-02 (i18n.ts L71-79) | ○ |
| C-016 | 存在しない言語コードでエラーになること | E-02 (i18n.ts L83-96) | ○ |
| C-017 | JSONパースエラー時にエラーがスローされること | E-02 (i18n.ts L58-64) | ○ |
| C-018 | 利用可能な言語情報が返却されること | E-02 (i18n.ts L108-114) | ○ |
| C-019 | ロケールインデックスが生成されること | E-02 (i18n.ts L117-123) | ○ |
| C-020 | /locales/:localeエンドポイントが応答すること | E-02 (i18n.ts L132-142) | ○ |
| C-021 | 存在しないロケールで404が返ること | E-02 (i18n.ts L139-141) | ○ |
| C-022 | /locales.jsonエンドポイントが応答すること | E-02 (i18n.ts L144-148) | ○ |
| C-023 | Socket.IOエンジンが閉じられること | E-03 (socketio.ts L20-49) | ○ |
| C-024 | 全クライアントの切断を待機すること | E-03 (socketio.ts L40-47) | ○ |
| C-025 | クライアント接続がない場合即時終了すること | E-03 (socketio.ts L41) | ○ |
| C-026 | Socket.IOサーバーが初期化されること | E-03 (socketio.ts L68-78) | ○ |
| C-027 | 接続時にセッションカウンタがインクリメントされること | E-03 (socketio.ts L85-87) | ○ |
| C-028 | 切断時にソケットが削除されること | E-03 (socketio.ts L88-91) | ○ |
| C-029 | プロキシ経由のIPアドレスが設定されること | E-03 (socketio.ts L51-66) | ○ |
| C-030 | 直接接続のIPアドレスが設定されること | E-03 (socketio.ts L57-58) | ○ |
| C-031 | クエリパラメータからクッキーが設定されること | E-03 (socketio.ts L61-64) | ○ |
| C-032 | エラーハンドラがアプリに登録されること | E-04 (errorhandling.ts L8-21) | ○ |
| C-033 | エラー発生時に500レスポンスが返ること | E-04 (errorhandling.ts L12-16) | ○ |
| C-034 | エラー発生時にhttp500メトリクスが記録されること | E-04 (errorhandling.ts L18) | ○ |
| C-035 | ioインスタンスが保存されること | E-05 (specialpages.ts L21-23) | ○ |
| C-036 | /healthエンドポイントが応答すること | E-05 (specialpages.ts L29-35) | ○ |
| C-037 | /statsエンドポイントが応答すること | E-05 (specialpages.ts L37-40) | ○ |
| C-038 | /stats/prometheusエンドポイントが応答すること | E-05 (specialpages.ts L42-46) | ○ |
| C-039 | /javascriptエンドポイントが応答すること | E-05 (specialpages.ts L50-52) | ○ |
| C-040 | /robots.txtがデフォルトで応答すること | E-05 (specialpages.ts L54-68) | ○ |
| C-041 | /robots.txtがスキン固有で応答すること | E-05 (specialpages.ts L59-67) | ○ |
| C-042 | /favicon.icoがリダイレクトされること | E-05 (specialpages.ts L75-78) | ○ |
| C-043 | /favicon.icoがローカルファイルで応答すること | E-05 (specialpages.ts L82-96) | ○ |
| C-044 | TypeScriptがバンドルされること | E-05 (specialpages.ts L104-129) | ○ |
| C-045 | 本番環境でminifyされること | E-05 (specialpages.ts L116) | ○ |
| C-046 | /p/:padエンドポイントが応答すること | E-05 (specialpages.ts L339-356) | ○ |
| C-047 | /p/:pad/timesliderエンドポイントが応答すること | E-05 (specialpages.ts L359-370) | ○ |
| C-048 | /_extendExpressSessionLifetimeエンドポイントが応答すること | E-05 (specialpages.ts L377-380) | ○ |
| C-049 | 開発モードでライブリロードが有効になること | E-05 (specialpages.ts L371-372) | ○ |
| C-050 | tar.jsonが読み込まれること | E-06 (static.ts L14-32) | ○ |
| C-051 | /static/*へのリクエストがminifyされること | E-06 (static.ts L38) | ○ |
| C-052 | /pluginfw/plugin-definitions.jsonが応答すること | E-06 (static.ts L43-56) | ○ |
| C-053 | オブジェクトが文字列化されること | E-07 (apicalls.ts L12-24) | ○ |
| C-054 | ネストしたオブジェクトが処理されること | E-07 (apicalls.ts L17-19) | ○ |
| C-055 | /ep/pad/connection-diagnostic-infoが受け付けられること | E-07 (apicalls.ts L29-38) | ○ |
| C-056 | 診断情報がない場合400が返ること | E-07 (apicalls.ts L30-33) | ○ |
| C-057 | /jserrorがエラー情報を受け付けること | E-07 (apicalls.ts L49-61) | ○ |
| C-058 | /apiが最新バージョンを返すこと | E-07 (apicalls.ts L64-66) | ○ |
| C-059 | /manifest.jsonが応答すること | E-08 (pwa.ts L26-31) | ○ |
| C-060 | マニフェストにタイトルが含まれること | E-08 (pwa.ts L4-6) | ○ |
| C-061 | /admin/{*filename}が静的ファイルを返すこと | E-09 (admin.ts L24-85) | ○ |
| C-062 | パストラバーサル攻撃が防止されること | E-09 (admin.ts L29-32) | ○ |
| C-063 | 存在しないファイルでindex.htmlが返ること | E-09 (admin.ts L52-56) | ○ |
| C-064 | MIMEタイプが正しく設定されること | E-09 (admin.ts L36-49, L73) | ○ |
| C-065 | プロキシパスが書き換えられること | E-09 (admin.ts L74-79) | ○ |
| C-066 | /adminがリダイレクトされること | E-09 (admin.ts L86-88) | ○ |
| C-067 | テンプレートディレクトリがない場合スキップすること | E-09 (admin.ts L20-23) | ○ |
| C-068 | エクスポートがレート制限されること | E-10 (importexport.ts L16-25) | ○ |
| C-069 | サポートされる形式でエクスポートできること | E-10 (importexport.ts L29-70) | ○ |
| C-070 | サポートされない形式で404が返ること | E-10 (importexport.ts L32-35) | ○ |
| C-071 | abiword未設定でodt/pdf/docが拒否されること | E-10 (importexport.ts L38-47) | ○ |
| C-072 | 読み取り専用IDでエクスポートできること | E-10 (importexport.ts L55-59) | ○ |
| C-073 | 存在しないPadで404が返ること | E-10 (importexport.ts L61-65) | ○ |
| C-074 | インポートがレート制限されること | E-10 (importexport.ts L74) | ○ |
| C-075 | インポートが正常に処理されること | E-10 (importexport.ts L75-86) | ○ |
| C-076 | 編集権限がない場合インポートが拒否されること | E-10 (importexport.ts L81-83) | ○ |
| C-077 | トークン保存が成功すること | E-11 (tokenTransfer.ts L15-26) | ○ |
| C-078 | トークンがない場合400が返ること | E-11 (tokenTransfer.ts L17-19) | ○ |
| C-079 | トークン取得が成功すること | E-11 (tokenTransfer.ts L28-44) | ○ |
| C-080 | 存在しないトークンで404が返ること | E-11 (tokenTransfer.ts L35-37) | ○ |
| C-081 | OpenAPI定義が生成されること | E-12 (openapi.ts L422-558) | ○ |
| C-082 | FLAT形式のパスが生成されること | E-12 (openapi.ts L537-541) | ○ |
| C-083 | REST形式のパスが生成されること | E-12 (openapi.ts L538-540) | ○ |
| C-084 | /api/{version}/openapi.jsonが応答すること | E-12 (openapi.ts L573-577) | ○ |
| C-085 | /rest/{version}/openapi.jsonが応答すること | E-12 (openapi.ts L566-577) | ○ |
| C-086 | /api/openapi.jsonが最新バージョンを返すこと | E-12 (openapi.ts L580-586) | ○ |
| C-087 | APIリクエストがルーティングされること | E-12 (openapi.ts L607-666) | ○ |
| C-088 | 存在しない関数で404が返ること | E-12 (openapi.ts L599-601) | ○ |
| C-089 | パラメータエラーで400が返ること | E-12 (openapi.ts L640-643) | ○ |
| C-090 | 内部エラーで500が返ること | E-12 (openapi.ts L644-648) | ○ |
| C-091 | APIルートパスが生成されること | E-12 (openapi.ts L725) | ○ |
| C-092 | サーバーURLが生成されること | E-12 (openapi.ts L733-737) | ○ |
| C-093 | trueがcreateに正規化されること | E-13 (webaccess.ts L24-37) | ○ |
| C-094 | readOnlyがそのまま返ること | E-13 (webaccess.ts L29) | ○ |
| C-095 | modifyがそのまま返ること | E-13 (webaccess.ts L30) | ○ |
| C-096 | createがそのまま返ること | E-13 (webaccess.ts L31) | ○ |
| C-097 | falseがfalseを返すこと | E-13 (webaccess.ts L25) | ○ |
| C-098 | 未知のレベルがfalseを返すこと | E-13 (webaccess.ts L33-35) | ○ |
| C-099 | 編集可能ユーザーがtrueを返すこと | E-13 (webaccess.ts L39-47) | ○ |
| C-100 | 読み取り専用IDでfalseを返すこと | E-13 (webaccess.ts L40) | ○ |
| C-101 | 認証不要時にtrueを返すこと | E-13 (webaccess.ts L41) | ○ |
| C-102 | 未認証ユーザーがfalseを返すこと | E-13 (webaccess.ts L42-43) | ○ |
| C-103 | 読み取り専用ユーザーがfalseを返すこと | E-13 (webaccess.ts L43) | ○ |
| C-104 | readOnly権限のみでfalseを返すこと | E-13 (webaccess.ts L45-46) | ○ |
| C-105 | 静的リソースがスキップされること | E-13 (webaccess.ts L52-65) | ○ |
| C-106 | preAuthorizeフックが呼ばれること | E-13 (webaccess.ts L77-90) | ○ |
| C-107 | 管理者ページでtrueが除外されること | E-13 (webaccess.ts L92-96) | ○ |
| C-108 | 認証成功後にセッションにユーザーが設定されること | E-13 (webaccess.ts L197-201) | ○ |
| C-109 | 認証失敗時に1秒遅延後401が返ること | E-13 (webaccess.ts L188-191) | ○ |
| C-110 | 認可失敗時に403が返ること | E-13 (webaccess.ts L223-226) | ○ |
| C-111 | プロトタイプ汚染が防止されること | E-13 (webaccess.ts L169-170, L193-196) | ○ |
| C-112 | 管理者が/admin-authに200を返すこと | E-13 (webaccess.ts L143-146, L218-220) | ○ |
| C-113 | 管理者接続時にイベントが登録されること | E-14 (adminplugins.ts L17-123) | ○ |
| C-114 | 非管理者接続時に何も登録されないこと | E-14 (adminplugins.ts L21-22) | ○ |
| C-115 | getInstalledで登録プラグイン一覧が返ること | E-14 (adminplugins.ts L47-59) | ○ |
| C-116 | checkUpdatesで更新可能プラグインが返ること | E-14 (adminplugins.ts L62-74) | ○ |
| C-117 | getAvailableで利用可能プラグインが返ること | E-14 (adminplugins.ts L76-84) | ○ |
| C-118 | searchでプラグイン検索結果が返ること | E-14 (adminplugins.ts L86-100) | ○ |
| C-119 | search失敗時にエラーが返ること | E-14 (adminplugins.ts L96-99) | ○ |
| C-120 | installでプラグインがインストールされること | E-14 (adminplugins.ts L102-112) | ○ |
| C-121 | uninstallでプラグインがアンインストールされること | E-14 (adminplugins.ts L115-121) | ○ |
| C-122 | プラグインが昇順ソートされること | E-14 (adminplugins.ts L133-146) | ○ |
| C-123 | プラグインが降順ソートされること | E-14 (adminplugins.ts L133-146) | ○ |
| C-124 | 正常なpadIdがnextを呼ぶこと | E-15 (padurlsanitize.ts L7-31) | ○ |
| C-125 | 不正なpadIdで404が返ること | E-15 (padurlsanitize.ts L12-15) | ○ |
| C-126 | 末尾スラッシュで404が返ること | E-15 (padurlsanitize.ts L12) | ○ |
| C-127 | サニタイズ後にリダイレクトされること | E-15 (padurlsanitize.ts L22-28) | ○ |
| C-128 | 管理者接続時にイベントが登録されること | E-16 (adminsettings.ts L21-314) | ○ |
| C-129 | 非管理者接続時に何も登録されないこと | E-16 (adminsettings.ts L24-25) | ○ |
| C-130 | loadで設定ファイルが読み込まれること | E-16 (adminsettings.ts L27-40) | ○ |
| C-131 | showSettingsInAdminPage=falseでNOT_ALLOWEDが返ること | E-16 (adminsettings.ts L35-37) | ○ |
| C-132 | saveSettingsで設定が保存されること | E-16 (adminsettings.ts L42-50) | ○ |
| C-133 | shoutでメッセージがブロードキャストされること | E-16 (adminsettings.ts L58-72) | ○ |
| C-134 | helpでシステム情報が返ること | E-16 (adminsettings.ts L75-103) | ○ |
| C-135 | padLoadでPad一覧が返ること | E-16 (adminsettings.ts L106-241) | ○ |
| C-136 | padLoadでパターンフィルタが効くこと | E-16 (adminsettings.ts L119-121) | ○ |
| C-137 | padLoadでソートが効くこと | E-16 (adminsettings.ts L146-238) | ○ |
| C-138 | padLoadでoffsetが範囲外の場合調整されること | E-16 (adminsettings.ts L131-135) | ○ |
| C-139 | padLoadでlimitが最大値を超えた場合調整されること | E-16 (adminsettings.ts L137-143) | ○ |
| C-140 | deletePadでPadが削除されること | E-16 (adminsettings.ts L244-252) | ○ |
| C-141 | 存在しないPad削除で何も起きないこと | E-16 (adminsettings.ts L245-246) | ○ |
| C-142 | createPadでPadが作成されること | E-16 (adminsettings.ts L258-271) | ○ |
| C-143 | 既存Pad作成でエラーが返ること | E-16 (adminsettings.ts L260-265) | ○ |
| C-144 | cleanupPadRevisionsでリビジョンが削除されること | E-16 (adminsettings.ts L273-305) | ○ |
| C-145 | cleanup無効時にエラーが返ること | E-16 (adminsettings.ts L274-279) | ○ |
| C-146 | restartServerでサーバーが再起動されること | E-16 (adminsettings.ts L307-313) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし：全てのテストケースに対してソースコードによる根拠が確認できています

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースにソースコード根拠あり
- セキュリティ関連（認証・認可・パストラバーサル防止）のテストケースは優先度「高」で設定済み
- 外部依存（Socket.IO、OpenAPI Backend、esbuild等）のモック化が必要なテストケースあり

## 6) レビュアーチェックリスト（最小）
- [ ] 各ファイルの主要関数・メソッドがテスト対象として網羅されているか確認
- [ ] セキュリティ関連テストケース（認証・認可・入力検証）が十分かレビュー
- [ ] 境界値テストケースの妥当性を確認
- [ ] エラーハンドリングテストケースの網羅性を確認
- [ ] 外部依存コンポーネントのモック戦略を検討
- [ ] Socket.IO関連のテストケースで接続・切断シナリオが十分か確認
- [ ] Express フック（expressPreSession、expressCreateServer等）の呼び出し順序を考慮したテスト設計か確認
