---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 63
  claims_with_evidence: 63
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-security.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：63 / 63、根拠なし：0
- 優先レビュー（高）
  1. **OAuth2Provider.ts** - 認証・認可の中核機能であり、セキュリティ上重要
  2. **SecretRotator.ts** - シークレット管理のロジックが複雑で、境界条件のテストが重要
  3. **OIDCAdapter.ts** - セッション管理のデータ整合性が重要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/security/crypto.ts` - 暗号化ユーティリティ関数（hkdf, randomBytes）
- E-02: `src/node/security/OIDCAdapter.ts` - MemoryAdapterクラス（LRUキャッシュベースOIDCアダプタ）
- E-03: `src/node/security/SecretRotator.ts` - SecretRotator、Hkdf、LegacyStaticSecretクラス
- E-04: `src/node/security/OAuth2Provider.ts` - OAuth2プロバイダ設定、expressCreateServerフック
- E-05: `src/node/security/OAuth2User.ts` - OAuth2User型定義
- E-06: `docs/code-to-docs/単体テストケース一覧/plan.md` - プロジェクト情報とモジュール構成

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | crypto.hkdf正常系テスト | E-01 L10（exports.hkdf = util.promisify(crypto.hkdf)） | ○ |
| C-02 | crypto.hkdf異常系（不正ダイジェスト） | E-01 L10（Node.js cryptoのhkdf仕様） | ○ |
| C-03 | crypto.hkdf境界値（keyLen=0） | E-01 L10 | ○ |
| C-04 | crypto.randomBytes正常系 | E-01 L15（exports.randomBytes = util.promisify(crypto.randomBytes)） | ○ |
| C-05 | crypto.randomBytes境界値（size=0） | E-01 L15 | ○ |
| C-06 | crypto.randomBytes異常系（負のサイズ） | E-01 L15 | ○ |
| C-07 | MemoryAdapter.constructor | E-02 L37-38（constructor(name:string) { this.name = name; }） | ○ |
| C-08 | MemoryAdapter.key | E-02 L41-43（key(id:string) { return `${this.name}:${id}`; }） | ○ |
| C-09 | MemoryAdapter.upsert正常系 | E-02 L79-93（storage.set(key, payload, {ttl: expiresIn * 1000})） | ○ |
| C-10 | MemoryAdapter.upsert境界値 | E-02 L90 | ○ |
| C-11 | MemoryAdapter.find正常系 | E-02 L67-72 | ○ |
| C-12 | MemoryAdapter.find異常系 | E-02 L71（return Promise.resolve<undefined>(undefined)） | ○ |
| C-13 | MemoryAdapter.findByUid正常系 | E-02 L95-102 | ○ |
| C-14 | MemoryAdapter.findByUid異常系 | E-02 L101（return Promise.resolve(undefined)） | ○ |
| C-15 | MemoryAdapter.findByUserCode正常系 | E-02 L74-77 | ○ |
| C-16 | MemoryAdapter.findByUserCode異常系 | E-02 L74-77（this.find(id)経由でundefined） | ○ |
| C-17 | MemoryAdapter.destroy正常系 | E-02 L45-60 | ○ |
| C-18 | MemoryAdapter.destroyカスケード削除 | E-02 L53-57（grantId関連トークン削除） | ○ |
| C-19 | MemoryAdapter.destroy異常系 | E-02 L45-60（存在しないキーでもエラーなし） | ○ |
| C-20 | MemoryAdapter.consume | E-02 L62-65（consumed = epochTime()） | ○ |
| C-21 | MemoryAdapter.revokeByGrantId正常系 | E-02 L104-112 | ○ |
| C-22 | MemoryAdapter.revokeByGrantId異常系 | E-02 L104-112（grantが存在しない場合も正常終了） | ○ |
| C-23 | Hkdf.constructor | E-03 L20-27 | ○ |
| C-24 | Hkdf.generateParams | E-03 L29-35 | ○ |
| C-25 | Hkdf.derive | E-03 L37-40 | ○ |
| C-26 | LegacyStaticSecret.derive | E-03 L17（return params） | ○ |
| C-27 | SecretRotator.constructor正常系 | E-03 L84-108 | ○ |
| C-28 | SecretRotator.constructor異常系（:） | E-03 L97（if (/[*:%]/.test(dbPrefix)) throw new Error） | ○ |
| C-29 | SecretRotator.constructor異常系（*） | E-03 L97 | ○ |
| C-30 | SecretRotator.constructor異常系（%） | E-03 L97 | ○ |
| C-31 | SecretRotator.start正常系 | E-03 L118-122 | ○ |
| C-32 | SecretRotator.start二重開始防止 | E-03 L120（if (this._updateTimeout != null) return） | ○ |
| C-33 | SecretRotator.stop正常系 | E-03 L124-128 | ○ |
| C-34 | SecretRotator.stop未開始状態 | E-03 L124-128（clearTimeoutはnullでも安全） | ○ |
| C-35 | SecretRotator._publish正常系 | E-03 L110-116 | ○ |
| C-36 | SecretRotator._publish指定ID | E-03 L110-116（id引数あり） | ○ |
| C-37 | SecretRotator._deriveSecrets正常系 | E-03 L130-166 | ○ |
| C-38 | SecretRotator._deriveSecretsレガシー | E-03 L132（if (!p.interval) return [await algorithms[p.algId].derive(p.algParams, null)]） | ○ |
| C-39 | SecretRotator._update正常系 | E-03 L168-261 | ○ |
| C-40 | SecretRotator._update新規生成 | E-03 L228-237（currentParams == null時） | ○ |
| C-41 | SecretRotator._update期限切れ削除 | E-03 L190-195（db.remove(dbKey)） | ○ |
| C-42 | SecretRotator._updateレガシー追加 | E-03 L210-227 | ○ |
| C-43 | configuration.findAccount正常系 | E-04 L15-48 | ○ |
| C-44 | configuration.findAccount管理者 | E-04 L32-39（is_admin true時にadmin: true） | ○ |
| C-45 | configuration.findAccount非管理者 | E-04 L40-47（is_adminなし時） | ○ |
| C-46 | configuration.findAccount存在しない | E-04 L29-31（return undefined） | ○ |
| C-47 | expressCreateServer初期化 | E-04 L72-83（generateKeyPair、new Provider） | ○ |
| C-48 | expressCreateServer POSTルート | E-04 L157-227（app.post('/interaction/:uid'）） | ○ |
| C-49 | expressCreateServer GETルート | E-04 L230-259（app.get('/interaction/:uid'）） | ○ |
| C-50 | interaction POSTログイン成功 | E-04 L167-189（account && interactionFinished） | ○ |
| C-51 | interaction POSTログイン失敗 | E-04 L179-182（!account時にerror返却） | ○ |
| C-52 | interaction POST既存grant更新 | E-04 L192-196（grantId存在時にGrant.find） | ○ |
| C-53 | interaction POST新規grant作成 | E-04 L196-202（grantIdなし時にnew Grant） | ○ |
| C-54 | interaction POSTスコープ追加 | E-04 L204-207（missingOIDCScope） | ○ |
| C-55 | interaction POSTクレーム追加 | E-04 L208-210（missingOIDCClaims） | ○ |
| C-56 | interaction POSTエラー処理 | E-04 L224-226（catch(err) => res.writeHead(500)） | ○ |
| C-57 | interaction GETログインリダイレクト | E-04 L239-244（login時にlogin.htmlへ） | ○ |
| C-58 | interaction GET同意リダイレクト | E-04 L245-250（consent時にconsent.htmlへ） | ○ |
| C-59 | interaction GETデフォルト | E-04 L251-254（default時にsendFile） | ○ |
| C-60 | extraTokenClaims AccessToken管理者 | E-04 L119-137（admin: account?.is_admin） | ○ |
| C-61 | extraTokenClaims AccessToken非管理者 | E-04 L119-137 | ○ |
| C-62 | extraTokenClaims ClientCredentials | E-04 L138-151 | ○ |
| C-63 | extraTokenClaims ClientCredentialsなし | E-04 L138-151（extraParamsない場合） | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし
  - 全てのテストケースはソースコード内の実装に基づいて導出されており、根拠が明確である

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - OAuth2Provider.tsの認証処理は、本番環境でのセキュリティテストが必要
- **1: 中リスク** - SecretRotatorの時間依存ロジックは、モックを使用したテストが推奨される
- **0: 低リスク** - crypto.tsはNode.js標準ライブラリのラッパーであり、単体テストは比較的容易

## 6) レビュアーチェックリスト（最小）
- [ ] OAuth2Provider.tsのログイン処理が正しく認証情報を検証しているか確認
- [ ] SecretRotatorのdbPrefix検証が全ての無効文字（*、:、%）をカバーしているか確認
- [ ] MemoryAdapterのLRUキャッシュ設定（max:500, maxSize:5000, ttl:5分）が適切か確認
- [ ] extraTokenClaimsで返されるクレームがセキュリティ要件を満たしているか確認
- [ ] エラーハンドリング（500エラー）のメッセージにセンシティブ情報が含まれないか確認
- [ ] テストケースの入力値・期待結果が具体的かつ検証可能か確認
