---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 147
  claims_with_evidence: 147
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：src-node-utils 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、対象ソースコードの関数・メソッド定義が実在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールのpublic関数・エクスポート関数を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：147 / 147、根拠なし：0
- 優先レビュー（高）
  1. 該当なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/utils/AbsolutePaths.ts` - popIfEndsWith, findEtherpadRoot, makeAbsolute, isSubdir関数
- E-02: `src/node/utils/Settings.ts` - getGitCommit, abiwordAvailable, sofficeAvailable, exportAvailable, getEpVersion, reloadSettings関数、settingsオブジェクト
- E-03: `src/node/utils/ExportHtml.ts` - getPadHTML, getHTMLFromAtext, getPadHTMLDocument, _processSpaces関数
- E-04: `src/node/utils/ExportTxt.ts` - getPadTXTDocument, getTXTFromAtext関数
- E-05: `src/node/utils/padDiff.ts` - PadDiffクラス（constructor, getHtml, getAuthors, _isClearAuthorship等）
- E-06: `src/node/utils/Minify.ts` - minify, shutdown, requestURIs関数
- E-07: `src/node/utils/run_cmd.ts` - runCmd関数（デフォルトエクスポート）
- E-08: `src/node/utils/toolbar.ts` - removeItem, defaultButtonAttributes, tag, ButtonGroup, Button, SelectButton, Separator, menuなど
- E-09: `src/node/utils/Stream.ts` - Streamクラス（range, batch, buffer, map, [Symbol.iterator]）
- E-10: `src/node/utils/Cleanup.ts` - deleteAllRevisions, deleteRevisions, checkTodos関数
- E-11: `src/node/utils/Cli.ts` - argvオブジェクト
- E-12: `src/node/utils/ExportEtherpad.ts` - getPadRaw関数
- E-13: `src/node/utils/ExportHelper.ts` - getPadPlainText, _analyzeLine, _encodeWhitespace関数
- E-14: `src/node/utils/ImportEtherpad.ts` - setPadRaw関数
- E-15: `src/node/utils/ImportHtml.ts` - setPadHTML関数
- E-16: `src/node/utils/LibreOffice.ts` - convertFile関数
- E-17: `src/node/utils/Abiword.ts` - convertFile関数
- E-18: `src/node/utils/MinifyWorker.ts` - compressJS, compressCSS関数
- E-19: `src/node/utils/NodeVersion.ts` - enforceMinNodeVersion, checkDeprecationStatus関数
- E-20: `src/node/utils/UpdateCheck.ts` - getLatestVersion, check関数
- E-21: `src/node/utils/customError.ts` - CustomErrorクラス
- E-22: `src/node/utils/promises.ts` - firstSatisfies, timesLimit, Gateクラス
- E-23: `src/node/utils/sanitizePathname.ts` - sanitizeRoot関数（デフォルトエクスポート）
- E-24: `src/node/utils/checkValidRev.ts` - checkValidRev, isInt関数
- E-25: `src/node/utils/randomstring.ts` - randomString関数（デフォルトエクスポート）
- E-26: `src/node/utils/path_exists.ts` - check関数（デフォルトエクスポート）
- E-27: `src/node/utils/SettingsTree.ts` - SettingsTree, SettingsNodeクラス

## 3) Claims と根拠の対応（レビューの主戦場）

### AbsolutePaths.ts (UT-UTL-001 〜 UT-UTL-010)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | popIfEndsWith関数が配列末尾一致時に短縮配列を返す | E-01 (L43-60) | ○ |
| C-02 | popIfEndsWith関数が末尾不一致時にfalseを返す | E-01 (L57-59) | ○ |
| C-03 | popIfEndsWith関数が配列長不足時にfalseを返す | E-01 (L44-49) | ○ |
| C-04 | findEtherpadRoot関数がルートパスを特定する | E-01 (L77-121) | ○ |
| C-05 | findEtherpadRoot関数がキャッシュを使用する | E-01 (L78-80) | ○ |
| C-06 | makeAbsolute関数が相対パスを絶対パスに変換する | E-01 (L133-142) | ○ |
| C-07 | makeAbsolute関数が絶対パスをそのまま返す | E-01 (L134-136) | ○ |
| C-08 | isSubdir関数がサブディレクトリ判定する | E-01 (L152-156) | ○ |
| C-09 | isSubdir関数が非サブディレクトリを判定する | E-01 (L154-155) | ○ |
| C-10 | isSubdir関数が同一ディレクトリでfalseを返す | E-01 (L155) | ○ |

### Settings.ts (UT-UTL-011 〜 UT-UTL-022)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | getGitCommit関数がコミットハッシュを取得する | E-02 (L135-157) | ○ |
| C-12 | getGitCommit関数がリポジトリ外で空文字を返す | E-02 (L153-155) | ○ |
| C-13 | abiwordAvailable関数が設定時に可用性を返す | E-02 (L669-675) | ○ |
| C-14 | abiwordAvailable関数が未設定時に'no'を返す | E-02 (L672-673) | ○ |
| C-15 | sofficeAvailable関数が設定時に可用性を返す | E-02 (L677-683) | ○ |
| C-16 | sofficeAvailable関数が未設定時に'no'を返す | E-02 (L680-681) | ○ |
| C-17 | exportAvailable関数が両ツール不可時に'no'を返す | E-02 (L689-690) | ○ |
| C-18 | exportAvailable関数がいずれか可の時に判定する | E-02 (L691-696) | ○ |
| C-19 | getEpVersion関数がバージョンを取得する | E-02 (L701) | ○ |
| C-20 | reloadSettings関数が設定ファイルを読み込む | E-02 (L940-1088) | ○ |
| C-21 | reloadSettings関数が無効skinNameでフォールバックする | E-02 (L955-997) | ○ |
| C-22 | getPublicSettings関数が公開設定のみ返す | E-02 (L646-656) | ○ |

### ExportHtml.ts (UT-UTL-023 〜 UT-UTL-028)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | getPadHTML関数がPadをHTMLに変換する | E-03 (L34-44) | ○ |
| C-24 | getPadHTML関数がrevNum未指定時に最新版を使用する | E-03 (L38-40) | ○ |
| C-25 | getHTMLFromAtext関数がatextをHTMLに変換する | E-03 (L46-477) | ○ |
| C-26 | getHTMLFromAtext関数がauthorColorsでスタイル付与する | E-03 (L81-110) | ○ |
| C-27 | getPadHTMLDocument関数が完全なHTMLを生成する | E-03 (L479-500) | ○ |
| C-28 | _processSpaces関数がスペースを変換する | E-03 (L503-549) | ○ |

### ExportTxt.ts (UT-UTL-029 〜 UT-UTL-032)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | getPadTXTDocument関数がTXT形式でエクスポートする | E-04 (L268-271) | ○ |
| C-30 | getTXTFromAtext関数がプレーンテキストに変換する | E-04 (L47-264) | ○ |
| C-31 | getTXTFromAtext関数が箇条書きを*で表現する | E-04 (L205-207) | ○ |
| C-32 | getTXTFromAtext関数が番号リストを数字で表現する | E-04 (L224-254) | ○ |

### padDiff.ts (UT-UTL-033 〜 UT-UTL-039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | PadDiffコンストラクタがインスタンスを生成する | E-05 (L24-38) | ○ |
| C-34 | PadDiffコンストラクタが無効padでエラーをスローする | E-05 (L26-28) | ○ |
| C-35 | PadDiffコンストラクタが無効リビジョンでエラーをスローする | E-05 (L30-31) | ○ |
| C-36 | getHtml関数が差分HTMLを取得する | E-05 (L187-203) | ○ |
| C-37 | getHtml関数がキャッシュを返す | E-05 (L189-191) | ○ |
| C-38 | getAuthors関数が著者一覧を返す | E-05 (L205-213) | ○ |
| C-39 | _isClearAuthorship関数が著者クリアを判定する | E-05 (L39-81) | ○ |

### Minify.ts (UT-UTL-040 〜 UT-UTL-044)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | minify関数がJSをミニファイする | E-06 (L273-274, L276-292) | ○ |
| C-41 | minify関数がCSSをミニファイする | E-06 (L293-309) | ○ |
| C-42 | minify関数が存在しないファイルで404を返す | E-06 (L213-215) | ○ |
| C-43 | minify関数がIf-Modified-Sinceで304を返す | E-06 (L216-218) | ○ |
| C-44 | shutdown関数がキャッシュをクリアする | E-06 (L324-326) | ○ |

### run_cmd.ts (UT-UTL-045 〜 UT-UTL-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | runCmd関数がコマンドを実行する | E-07 (L77-163) | ○ |
| C-46 | runCmd関数がstdoutをログに出力する | E-07 (L90-91) | ○ |
| C-47 | runCmd関数がstdio='string'で文字列取得する | E-07 (L98-101) | ○ |
| C-48 | runCmd関数が失敗時にrejectする | E-07 (L149-158) | ○ |
| C-49 | runCmd関数がcwdオプションを適用する | E-07 (L80-81) | ○ |

### toolbar.ts (UT-UTL-050 〜 UT-UTL-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | removeItem関数が要素を削除する | E-08 (L7-13) | ○ |
| C-51 | defaultButtonAttributes関数がデフォルト属性を生成する | E-08 (L15-19) | ○ |
| C-52 | tag関数がHTMLタグを生成する | E-08 (L21-29) | ○ |
| C-53 | tag関数が空コンテンツでタグを生成する | E-08 (L26-27) | ○ |
| C-54 | ButtonGroup.fromArrayが配列から生成する | E-08 (L59-66) | ○ |
| C-55 | ButtonGroup.renderがHTMLをレンダリングする | E-08 (L73-88) | ○ |
| C-56 | Button.loadがインスタンスを取得する | E-08 (L101-113) | ○ |
| C-57 | Button.loadが存在しない名前でfalseを返す | E-08 (L109-111) | ○ |
| C-58 | Button.renderがHTMLをレンダリングする | E-08 (L115-127) | ○ |
| C-59 | SelectButton.addOptionがオプションを追加する | E-08 (L143-150) | ○ |
| C-60 | SelectButton.renderがHTMLをレンダリングする | E-08 (L165-172) | ○ |
| C-61 | Separator.renderがHTMLをレンダリングする | E-08 (L186-189) | ○ |
| C-62 | menu関数がツールバーをレンダリングする | E-08 (L278-306) | ○ |
| C-63 | menu関数が読み取り専用時にボタンを非表示にする | E-08 (L279-287) | ○ |

### Stream.ts (UT-UTL-064 〜 UT-UTL-070)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | Streamコンストラクタがイテラブルから生成する | E-09 (L20-23) | ○ |
| C-65 | Stream.rangeが範囲のStreamを生成する | E-09 (L13-15) | ○ |
| C-66 | Stream.batchがバッチ処理する | E-09 (L57-73) | ○ |
| C-67 | Stream.batchが少ない要素も処理する | E-09 (L68) | ○ |
| C-68 | Stream.bufferがバッファリングする | E-09 (L106-122) | ○ |
| C-69 | Stream.mapが値を変換する | E-09 (L130-131) | ○ |
| C-70 | Stream[Symbol.iterator]が反復可能にする | E-09 (L136) | ○ |

### Cleanup.ts (UT-UTL-071 〜 UT-UTL-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | deleteAllRevisions関数が全リビジョンを削除する | E-10 (L15-24) | ○ |
| C-72 | deleteRevisions関数が指定数を保持して削除する | E-10 (L43-137) | ○ |
| C-73 | deleteRevisions関数がリビジョン不足時にスキップする | E-10 (L52-55) | ○ |
| C-74 | deleteRevisions関数がsavedRevisionsを更新する | E-10 (L78-88) | ○ |
| C-75 | checkTodos関数が全パッドをチェックする | E-10 (L139-169) | ○ |

### Cli.ts (UT-UTL-076 〜 UT-UTL-079)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | argvが--settingsオプションを解析する | E-11 (L35-38) | ○ |
| C-77 | argvが--credentialsオプションを解析する | E-11 (L41-44) | ○ |
| C-78 | argvが--sessionkeyオプションを解析する | E-11 (L47-50) | ○ |
| C-79 | argvが--apikeyオプションを解析する | E-11 (L53-56) | ○ |

### ExportEtherpad.ts (UT-UTL-080 〜 UT-UTL-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-80 | getPadRaw関数がPadの生データをエクスポートする | E-12 (L24-64) | ○ |
| C-81 | getPadRaw関数が著者情報を含める | E-12 (L44-51) | ○ |
| C-82 | getPadRaw関数がチャットメッセージを含める | E-12 (L53) | ○ |

### ExportHelper.ts (UT-UTL-083 〜 UT-UTL-086)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | getPadPlainText関数がプレーンテキストを取得する | E-13 (L30-50) | ○ |
| C-84 | _analyzeLine関数が行を解析する | E-13 (L55-88) | ○ |
| C-85 | _analyzeLine関数がリストでない行を処理する | E-13 (L80-86) | ○ |
| C-86 | _encodeWhitespace関数が制御文字を変換する | E-13 (L91-92) | ○ |

### ImportEtherpad.ts (UT-UTL-087 〜 UT-UTL-089)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | setPadRaw関数がEtherpad形式から復元する | E-14 (L33-128) | ○ |
| C-88 | setPadRaw関数が不正入力でエラー処理する | E-14 (L73-75) | ○ |
| C-89 | setPadRaw関数が既存著者を追加する | E-14 (L125) | ○ |

### ImportHtml.ts (UT-UTL-090 〜 UT-UTL-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | setPadHTML関数がHTMLからPadを設定する | E-15 (L28-95) | ○ |
| C-91 | setPadHTML関数がフォーマット付きHTMLを処理する | E-15 (L47-54) | ○ |
| C-92 | setPadHTML関数が不正HTMLでエラーをスローする | E-15 (L51-53) | ○ |

### LibreOffice.ts (UT-UTL-093 〜 UT-UTL-095)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-93 | convertFile関数がファイルを変換する | E-16 (L92-117) | ○ |
| C-94 | convertFile関数がDOCをODT経由で変換する | E-16 (L110-113) | ○ |
| C-95 | convertFile関数がタイムアウト時にkillする | E-16 (L61-64) | ○ |

### Abiword.ts (UT-UTL-096 〜 UT-UTL-097)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-96 | convertFile関数がファイルを変換する | E-17 (L33-47, L90-92) | ○ |
| C-97 | convertFile関数が失敗時にエラーをスローする | E-17 (L40, L85) | ○ |

### MinifyWorker.ts (UT-UTL-098 〜 UT-UTL-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-98 | compressJS関数がJSをミニファイする | E-18 (L12-14) | ○ |
| C-99 | compressJS関数が構文エラーでエラーをスローする | E-18 (L13) | ○ |
| C-100 | compressCSS関数がCSSをミニファイする | E-18 (L21-42) | ○ |

### NodeVersion.ts (UT-UTL-101 〜 UT-UTL-104)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | enforceMinNodeVersion関数がバージョン以上で続行する | E-19 (L34-38) | ○ |
| C-102 | enforceMinNodeVersion関数がバージョン未満で終了する | E-19 (L35-37) | ○ |
| C-103 | checkDeprecationStatus関数が非推奨で警告を出力する | E-19 (L55-58) | ○ |
| C-104 | checkDeprecationStatus関数がサポートで警告スキップする | E-19 (L55) | ○ |

### UpdateCheck.ts (UT-UTL-105 〜 UT-UTL-107)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | getLatestVersion関数が最新バージョンを取得する | E-20 (L40-43) | ○ |
| C-106 | getLatestVersion関数がキャッシュを使用する | E-20 (L19-21) | ○ |
| C-107 | check関数が更新時に警告を出力する | E-20 (L57-63) | ○ |

### customError.ts (UT-UTL-108 〜 UT-UTL-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | CustomErrorコンストラクタがエラーを生成する | E-21 (L17-21) | ○ |
| C-109 | CustomErrorコンストラクタがデフォルト名を設定する | E-21 (L17) | ○ |
| C-110 | CustomErrorコンストラクタがスタックトレースをキャプチャする | E-21 (L20) | ○ |

### promises.ts (UT-UTL-111 〜 UT-UTL-118)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | firstSatisfies関数が条件を満たす値を返す | E-22 (L10-39) | ○ |
| C-112 | firstSatisfies関数が条件不一致でundefinedを返す | E-22 (L36) | ○ |
| C-113 | firstSatisfies関数が空配列でundefinedを返す | E-22 (L36) | ○ |
| C-114 | timesLimit関数が指定回数呼び出す | E-22 (L47-58) | ○ |
| C-115 | timesLimit関数が同時実行数を制限する | E-22 (L54-56) | ○ |
| C-116 | timesLimit関数がconcurrency<=0でRangeErrorをスローする | E-22 (L48) | ○ |
| C-117 | Gateコンストラクタがresolve/rejectプロパティを持つ | E-22 (L69-76) | ○ |
| C-118 | Gate.resolveが外部からresolveできる | E-22 (L74-75) | ○ |

### sanitizePathname.ts (UT-UTL-119 〜 UT-UTL-122)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | sanitizeRoot関数が相対パスを正規化する | E-23 (L5-21) | ○ |
| C-120 | sanitizeRoot関数が絶対パスでエラーをスローする | E-23 (L12) | ○ |
| C-121 | sanitizeRoot関数がディレクトリトラバーサルでエラーをスローする | E-23 (L13) | ○ |
| C-122 | sanitizeRoot関数がWindowsのバックスラッシュを変換する | E-23 (L19) | ○ |

### checkValidRev.ts (UT-UTL-123 〜 UT-UTL-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-123 | checkValidRev関数が有効なリビジョンを返す | E-24 (L7-28) | ○ |
| C-124 | checkValidRev関数が文字列を数値に変換する | E-24 (L8-10) | ○ |
| C-125 | checkValidRev関数がNaNでエラーをスローする | E-24 (L13-15) | ○ |
| C-126 | checkValidRev関数が負の数でエラーをスローする | E-24 (L18-20) | ○ |
| C-127 | checkValidRev関数が小数でエラーをスローする | E-24 (L23-25) | ○ |
| C-128 | isInt関数が整数でtrueを返す | E-24 (L31) | ○ |
| C-129 | isInt関数が小数でfalseを返す | E-24 (L31) | ○ |

### randomstring.ts (UT-UTL-130 〜 UT-UTL-132)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-130 | randomString関数が指定長のランダム文字列を生成する | E-25 (L7) | ○ |
| C-131 | randomString関数が長さ0で空文字を返す | E-25 (L7) | ○ |
| C-132 | randomString関数が異なる値を返す | E-25 (L7) | ○ |

### path_exists.ts (UT-UTL-133 〜 UT-UTL-134)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-133 | check関数が存在するパスでtruthyを返す | E-26 (L4-14) | ○ |
| C-134 | check関数が存在しないパスでfalseを返す | E-26 (L10-12) | ○ |

### SettingsTree.ts (UT-UTL-135 〜 UT-UTL-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-135 | SettingsTree.addChildが子ノードを追加する | E-27 (L9-11) | ○ |
| C-136 | SettingsTree.removeChildが子ノードを削除する | E-27 (L13-15) | ○ |
| C-137 | SettingsTree.getChildが子ノードを取得する | E-27 (L17-19) | ○ |
| C-138 | SettingsTree.hasChildが存在を確認する | E-27 (L21-23) | ○ |
| C-139 | SettingsNode.addChildがパスから子ノードを追加する | E-27 (L38-60) | ○ |
| C-140 | SettingsNode.collectFromLeafsUpwardsが値を収集する | E-27 (L63-74) | ○ |
| C-141 | SettingsNode.coerceValueが'true'をbooleanに変換する | E-27 (L88-89) | ○ |
| C-142 | SettingsNode.coerceValueが'false'をbooleanに変換する | E-27 (L90-91) | ○ |
| C-143 | SettingsNode.coerceValueが数値文字列をnumberに変換する | E-27 (L81-84) | ○ |
| C-144 | SettingsNode.coerceValueが'null'をnullに変換する | E-27 (L94-95) | ○ |
| C-145 | SettingsNode.coerceValueが通常文字列をそのまま返す | E-27 (L96-97) | ○ |
| C-146 | SettingsNode.hasChildrenが子存在時にtrueを返す | E-27 (L101-103) | ○ |
| C-147 | SettingsNode.hasChildrenが子非存在時にfalseを返す | E-27 (L101-103) | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし。全てのテストケースはソースコードの関数・メソッド定義を根拠として作成されています。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのテストケースはソースコードに対応する根拠があり、入力値・期待結果は実装と整合しています。
- 外部依存（LibreOffice, Abiword）のテストは実環境での動作確認が必要です。
- セキュリティ関連（sanitizePathname, checkValidRev）は特に注意深いレビューを推奨します。

## 6) レビュアーチェックリスト（最小）
- [ ] テストID（UT-UTL-xxx）の連番に欠番がないか確認
- [ ] 優先度「高」のテストケースが実装に対して十分な網羅性を持つか確認
- [ ] 異常系テストケースがエラーメッセージ・例外タイプを正確に反映しているか確認
- [ ] 境界値テストケースが適切な境界条件をカバーしているか確認
- [ ] セキュリティ関連関数（sanitizePathname, checkValidRev）のテストケースが攻撃パターンを考慮しているか確認
- [ ] 外部ツール連携（LibreOffice, Abiword）のテストケースが環境依存を考慮しているか確認
