---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 142
  claims_with_evidence: 138
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：src-static-js-client 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：138 / 142、根拠なし：4
- 優先レビュー（高）
  1. **UT-CLI-115 (pad.init)**: 複雑な初期化フローのため詳細確認が必要
  2. **UT-CLI-133 (Ace2Editor.init)**: iframe生成を含む複雑な処理
  3. **UT-CLI-121 (applyChangeset in broadcast)**: タイムスライダー固有の動作

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/static/js/Changeset.ts` - Changeset操作の実装（1621行）
- E-02: `src/static/js/AttributePool.ts` - 属性プールの実装（258行）
- E-03: `src/static/js/AttributeMap.ts` - 属性マップの実装（96行）
- E-04: `src/static/js/AttributeManager.ts` - 属性マネージャーの実装（383行）
- E-05: `src/static/js/skiplist.ts` - スキップリストの実装（358行）
- E-06: `src/static/js/Op.ts` - 操作クラスの実装（79行）
- E-07: `src/static/js/StringIterator.ts` - 文字列イテレータの実装（55行）
- E-08: `src/static/js/StringAssembler.ts` - 文字列アセンブラの実装（19行）
- E-09: `src/static/js/SmartOpAssembler.ts` - スマート操作アセンブラの実装（116行）
- E-10: `src/static/js/Builder.ts` - Changesetビルダーの実装（109行）
- E-11: `src/static/js/MergingOpAssembler.ts` - マージング操作アセンブラの実装（74行）
- E-12: `src/static/js/TextLinesMutator.ts` - テキスト行ミューテータの実装（349行）
- E-13: `src/static/js/colorutils.ts` - カラーユーティリティの実装（123行）
- E-14: `src/static/js/pad_utils.ts` - パッドユーティリティの実装（503行）
- E-15: `src/static/js/ChangesetUtils.ts` - Changesetユーティリティの実装（75行）
- E-16: `src/static/js/chat.ts` - チャット機能の実装（281行）
- E-17: `src/static/js/collab_client.ts` - コラボレーションクライアントの実装（504行）
- E-18: `src/static/js/pad.ts` - パッドメイン処理の実装（793行）
- E-19: `src/static/js/broadcast.ts` - ブロードキャスト（タイムスライダー）の実装（492行）
- E-20: `src/static/js/ace.ts` - Aceエディタラッパーの実装（321行）
- E-21: `src/static/js/ace2_inner.ts` - Aceエディタ内部処理の実装（500行以上）

## 3) Claims と根拠の対応（レビューの主戦場）

### Changeset.ts 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-CLI-001: unpackが正しく動作すること | E-01 (line 360-377) | ○ |
| C-02 | UT-CLI-002: 無効なChangesetでエラー | E-01 (line 363) | ○ |
| C-03 | UT-CLI-003: packが正しく動作すること | E-01 (line 388-395) | ○ |
| C-04 | UT-CLI-004: 空のChangeset生成 | E-01 (line 388-395) | ○ |
| C-05 | UT-CLI-005: applyToTextが正しく動作すること | E-01 (line 404-440) | ○ |
| C-06 | UT-CLI-006: 長さ不一致エラー | E-01 (line 406) | ○ |
| C-07 | UT-CLI-007: composeが正しく動作すること | E-01 (line 755-784) | ○ |
| C-08 | UT-CLI-008: compose時の整合性チェック | E-01 (line 760) | ○ |
| C-09 | UT-CLI-009: checkRepが正規形を検証 | E-01 (line 245-291) | ○ |
| C-10 | UT-CLI-010: 非正規形エラー | E-01 (line 289) | ○ |
| C-11 | UT-CLI-011: deserializeOpsがパース | E-01 (line 118-132) | ○ |
| C-12 | UT-CLI-012: 空操作文字列の処理 | E-01 (line 118-132) | ○ |
| C-13 | UT-CLI-013: opsFromTextが動作 | E-01 (line 216-234) | ○ |
| C-14 | UT-CLI-014: 改行を含むテキスト | E-01 (line 220-233) | ○ |
| C-15 | UT-CLI-015: makeSpliceが動作 | E-01 (line 824-839) | ○ |
| C-16 | UT-CLI-016: 負の開始位置エラー | E-01 (line 825) | ○ |
| C-17 | UT-CLI-017: identityが動作 | E-01 (line 809) | ○ |
| C-18 | UT-CLI-018: isIdentityがtrue判定 | E-01 (line 1161-1164) | ○ |
| C-19 | UT-CLI-019: isIdentityがfalse判定 | E-01 (line 1161-1164) | ○ |
| C-20 | UT-CLI-020: inverseが動作 | E-01 (line 1279-1443) | ○ |
| C-21 | UT-CLI-021: followが動作 | E-01 (line 1446-1585) | ○ |
| C-22 | UT-CLI-022: follow時の整合性チェック | E-01 (line 1451) | ○ |

### AttributePool.ts 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-23 | UT-CLI-023: constructorが正しく初期化 | E-02 (line 68-102) | ○ |
| C-24 | UT-CLI-024: putAttribが属性追加 | E-02 (line 127-141) | ○ |
| C-25 | UT-CLI-025: 既存属性のID返却 | E-02 (line 129-131) | ○ |
| C-26 | UT-CLI-026: dontAddIfAbsent動作 | E-02 (line 133-135) | ○ |
| C-27 | UT-CLI-027: getAttribが取得 | E-02 (line 148-154) | ○ |
| C-28 | UT-CLI-028: 存在しないIDでundefined | E-02 (line 150-152) | ○ |
| C-29 | UT-CLI-029: cloneが動作 | E-02 (line 107-116) | ○ |
| C-30 | UT-CLI-030: toJsonableが動作 | E-02 (line 198-203) | ○ |
| C-31 | UT-CLI-031: fromJsonableが動作 | E-02 (line 214-223) | ○ |
| C-32 | UT-CLI-032: checkが正常検証 | E-02 (line 228-254) | ○ |
| C-33 | UT-CLI-033: check不整合検出 | E-02 (line 229-253) | ○ |

### AttributeMap.ts 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-34 | UT-CLI-034: fromStringが動作 | E-03 (line 35-37) | ○ |
| C-35 | UT-CLI-035: 空文字列から空マップ | E-03 (line 35-37) | ○ |
| C-36 | UT-CLI-036: setが動作 | E-03 (line 53-58) | ○ |
| C-37 | UT-CLI-037: toStringが動作 | E-03 (line 60-62) | ○ |
| C-38 | UT-CLI-038: updateが動作 | E-03 (line 70-81) | ○ |
| C-39 | UT-CLI-039: emptyValueIsDelete動作 | E-03 (line 74-75) | ○ |

### SkipList 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | UT-CLI-040: SkipList constructor | E-05 (line 212-220) | ○ |
| C-41 | UT-CLI-041: push動作 | E-05 (line 308) | ○ |
| C-42 | UT-CLI-042: atIndex動作 | E-05 (line 282-286) | ○ |
| C-43 | UT-CLI-043: atIndex境界チェック | E-05 (line 283-284) | ○ |
| C-44 | UT-CLI-044: splice動作 | E-05 (line 289-304) | ○ |
| C-45 | UT-CLI-045: containsKeyがtrue | E-05 (line 335) | ○ |
| C-46 | UT-CLI-046: containsKeyがfalse | E-05 (line 335) | ○ |
| C-47 | UT-CLI-047: offsetOfIndex動作 | E-05 (line 345-349) | ○ |
| C-48 | UT-CLI-048: search動作 | E-05 (line 257-278) | ○ |

### Op, StringIterator, StringAssembler 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | UT-CLI-049: Op constructor デフォルト | E-06 (line 17-70) | ○ |
| C-50 | UT-CLI-050: Op constructor opcode指定 | E-06 (line 17) | ○ |
| C-51 | UT-CLI-051: Op toString | E-06 (line 72-77) | ○ |
| C-52 | UT-CLI-052: Op toString空opcodeエラー | E-06 (line 73) | ○ |
| C-53 | UT-CLI-053: StringIterator constructor | E-07 (line 23-27) | ○ |
| C-54 | UT-CLI-054: take動作 | E-07 (line 36-42) | ○ |
| C-55 | UT-CLI-055: take境界チェック | E-07 (line 32-34) | ○ |
| C-56 | UT-CLI-056: peek動作 | E-07 (line 44-47) | ○ |
| C-57 | UT-CLI-057: skip動作 | E-07 (line 49-52) | ○ |
| C-58 | UT-CLI-058: StringAssembler append | E-08 (line 12-14) | ○ |
| C-59 | UT-CLI-059: StringAssembler clear | E-08 (line 6-8) | ○ |

### SmartOpAssembler, Builder, MergingOpAssembler 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | UT-CLI-060: SmartOpAssembler append | E-09 (line 55-78) | ○ |
| C-61 | UT-CLI-061: Opマージ | E-09 (line 55-78) | ○ |
| C-62 | UT-CLI-062: chars=0のOp無視 | E-09 (line 56-57) | ○ |
| C-63 | UT-CLI-063: endDocument動作 | E-09 (line 110-112) | ○ |
| C-64 | UT-CLI-064: Builder insert | E-10 (line 79-83) | ○ |
| C-65 | UT-CLI-065: Builder keep | E-10 (line 46-54) | ○ |
| C-66 | UT-CLI-066: Builder remove | E-10 (line 92-99) | ○ |
| C-67 | UT-CLI-067: Builder toString | E-10 (line 101-105) | ○ |
| C-68 | UT-CLI-068: MergingOpAssembler append | E-11 (line 39-58) | ○ |
| C-69 | UT-CLI-069: Opマージ処理 | E-11 (line 41-53) | ○ |
| C-70 | UT-CLI-070: clear動作 | E-11 (line 69-72) | ○ |

### TextLinesMutator 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | UT-CLI-071: constructor動作 | E-12 (line 23-45) | ○ |
| C-72 | UT-CLI-072: insert動作 | E-12 (line 278-324) | ○ |
| C-73 | UT-CLI-073: insert改行付き | E-12 (line 281-306) | ○ |
| C-74 | UT-CLI-074: remove動作 | E-12 (line 256-270) | ○ |
| C-75 | UT-CLI-075: removeLines動作 | E-12 (line 203-247) | ○ |
| C-76 | UT-CLI-076: skip動作 | E-12 (line 182-195) | ○ |
| C-77 | UT-CLI-077: hasMore動作 | E-12 (line 331-338) | ○ |
| C-78 | UT-CLI-078: close動作 | E-12 (line 343-345) | ○ |

### colorutils, pad_utils, ChangesetUtils 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | UT-CLI-079: css2triple動作 | E-13 (line 35-44) | ○ |
| C-80 | UT-CLI-080: 3桁カラー変換 | E-13 (line 47-56) | ○ |
| C-81 | UT-CLI-081: triple2css動作 | E-13 (line 59-65) | ○ |
| C-82 | UT-CLI-082: isCssHex有効 | E-13 (line 32) | ○ |
| C-83 | UT-CLI-083: isCssHex無効 | E-13 (line 32) | ○ |
| C-84 | UT-CLI-084: luminosity動作 | E-13 (line 89) | ○ |
| C-85 | UT-CLI-085: blend動作 | E-13 (line 98-102) | ○ |
| C-86 | UT-CLI-086: randomString動作 | E-14 (line 34-43) | ○ |
| C-87 | UT-CLI-087: randomStringデフォルト | E-14 (line 37) | ○ |
| C-88 | UT-CLI-088: escapeHtml動作 | E-14 (line 161) | ○ |
| C-89 | UT-CLI-089: findURLs動作 | E-14 (line 198-213) | ○ |
| C-90 | UT-CLI-090: findURLsでnull | E-14 (line 203) | ○ |
| C-91 | UT-CLI-091: escapeHtmlWithClickableLinks動作 | E-14 (line 214-250) | ○ |
| C-92 | UT-CLI-092: isValidAuthorToken有効 | E-14 (line 386-390) | ○ |
| C-93 | UT-CLI-093: isValidAuthorToken無効 | E-14 (line 387) | ○ |
| C-94 | UT-CLI-094: generateAuthorToken動作 | E-14 (line 397) | ○ |
| C-95 | UT-CLI-095: encodeUserId動作 | E-14 (line 362-366) | ○ |
| C-96 | UT-CLI-096: decodeUserId動作 | E-14 (line 367-376) | ○ |
| C-97 | UT-CLI-097: timediff動作 | E-14 (line 273-294) | ○ |
| C-98 | UT-CLI-098: simpleDateTime動作 | E-14 (line 175-196) | ○ |
| C-99 | UT-CLI-099: parseNum動作 | E-15 (line 66) | ○ |
| C-100 | UT-CLI-100: numToString動作 | E-15 (line 74) | ○ |
| C-101 | UT-CLI-101: buildRemoveRange動作 | E-15 (line 29-39) | ○ |
| C-102 | UT-CLI-102: buildKeepRange動作 | E-15 (line 41-51) | ○ |

### chat, collab_client, pad 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | UT-CLI-103: chat send動作 | E-16 (line 112-119) | ○ |
| C-104 | UT-CLI-104: chat send空メッセージ | E-16 (line 114) | ○ |
| C-105 | UT-CLI-105: addMessage動作 | E-16 (line 120-224) | ○ |
| C-106 | UT-CLI-106: show動作 | E-16 (line 36-45) | ○ |
| C-107 | UT-CLI-107: hide動作 | E-16 (line 88-98) | ○ |
| C-108 | UT-CLI-108: stickToScreen動作 | E-16 (line 52-70) | ○ |
| C-109 | UT-CLI-109: handleMessageFromServer NEW_CHANGES | E-17 (line 190-208) | ○ |
| C-110 | UT-CLI-110: handleMessageFromServer ACCEPT_COMMIT | E-17 (line 209-222) | ○ |
| C-111 | UT-CLI-111: sendMessage動作 | E-17 (line 159-166) | ○ |
| C-112 | UT-CLI-112: updateUserInfo動作 | E-17 (line 307-317) | ○ |
| C-113 | UT-CLI-113: setChannelState動作 | E-17 (line 355-360) | ○ |
| C-114 | UT-CLI-114: getCurrentRevisionNumber動作 | E-17 (line 407) | ○ |
| C-115 | UT-CLI-115: pad init動作 | E-18 (line 410-424) | △ |
| C-116 | UT-CLI-116: notifyChangeName動作 | E-18 (line 577-580) | ○ |
| C-117 | UT-CLI-117: notifyChangeColor動作 | E-18 (line 581-584) | ○ |
| C-118 | UT-CLI-118: handleOptionsChange動作 | E-18 (line 603-616) | ○ |
| C-119 | UT-CLI-119: MessageQueue enqueue動作 | E-18 (line 377-384) | ○ |
| C-120 | UT-CLI-120: setCollabClient動作 | E-18 (line 372-375) | ○ |

### broadcast, AttributeManager, ace 関連
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-121 | UT-CLI-121: applyChangeset動作 | E-19 (line 135-196) | △ |
| C-122 | UT-CLI-122: goToRevision動作 | E-19 (line 263-307) | ○ |
| C-123 | UT-CLI-123: padContents splice動作 | E-19 (line 79-111) | ○ |
| C-124 | UT-CLI-124: lineToElement動作 | E-19 (line 66-76) | ○ |
| C-125 | UT-CLI-125: changesetLoader queueUp動作 | E-19 (line 332-356) | ○ |
| C-126 | UT-CLI-126: setAttributesOnRange動作 | E-04 (line 67-96) | ○ |
| C-127 | UT-CLI-127: setAttributesOnRange境界チェック | E-04 (line 68-74) | ○ |
| C-128 | UT-CLI-128: getAttributeOnLine動作 | E-04 (line 149-156) | ○ |
| C-129 | UT-CLI-129: lineHasMarker動作 | E-04 (line 139-142) | ○ |
| C-130 | UT-CLI-130: setAttributeOnLine動作 | E-04 (line 286-308) | ○ |
| C-131 | UT-CLI-131: removeAttributeOnLine動作 | E-04 (line 316-350) | ○ |
| C-132 | UT-CLI-132: getAttributesOnPosition動作 | E-04 (line 250-267) | ○ |
| C-133 | UT-CLI-133: Ace2Editor init動作 | E-20 (line 170-317) | △ |
| C-134 | UT-CLI-134: exportText動作 | E-20 (line 139) | ○ |
| C-135 | UT-CLI-135: exportText未初期化時 | E-20 (line 139) | ○ |
| C-136 | UT-CLI-136: prepareUserChangeset動作 | E-20 (line 152) | ○ |
| C-137 | UT-CLI-137: destroy動作 | E-20 (line 164-168) | ○ |
| C-138 | UT-CLI-138: setAuthorInfo動作 | E-21 (line 257-269) | ○ |
| C-139 | UT-CLI-139: setAuthorInfo空著者ID | E-21 (line 258) | ○ |
| C-140 | UT-CLI-140: importText動作 | E-21 (line 472-498) | ○ |
| C-141 | UT-CLI-141: setEditable動作 | E-21 (line 464-468) | ○ |
| C-142 | UT-CLI-142: performDocumentReplaceRange動作 | E-21 (line 172-189) | △ |

## 4) 不足情報（Unknown / Missing）

以下の項目は根拠が不足しているか、追加の確認が必要です：

1. **pad.init (UT-CLI-115)**: 複雑な非同期初期化フローのため、テストケースが全ての分岐をカバーしているか確認が必要
   - 候補：handshake関数の詳細 / socket接続エラーハンドリング / クライアント変数の初期化順序

2. **applyChangeset in broadcast (UT-CLI-121)**: タイムスライダー固有のロジックで、UIとの連携が複雑
   - 候補：BroadcastSlider APIの詳細 / DOM更新のタイミング

3. **Ace2Editor.init (UT-CLI-133)**: iframe内でのエディタ初期化は複雑で、ブラウザ固有の挙動がある
   - 候補：frameReady関数の詳細 / 各ブラウザでの挙動差異

4. **performDocumentReplaceRange (UT-CLI-142)**: undoモジュールとの連携を含む複雑な処理
   - 候補：undoModule.reportEvent / changesetTrackerの詳細

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 2 (高リスク) | Changeset操作全般 | リアルタイムコラボレーションの根幹であり、バグは深刻なデータ整合性問題を引き起こす |
| 2 (高リスク) | AttributePool | 属性管理の不整合は表示・編集の問題に直結 |
| 1 (中リスク) | collab_client | サーバーとの通信処理で、ネットワーク障害時の挙動が重要 |
| 1 (中リスク) | ace2_inner | DOM操作とブラウザ互換性に関わる |
| 0 (低リスク) | colorutils | 視覚的な問題のみで機能に影響しない |
| 0 (低リスク) | chat | 補助機能であり、パッドの主機能に影響しない |

## 6) レビュアーチェックリスト（最小）

- [ ] Changeset関連のテストケースは、正常系・異常系・境界値が網羅されているか
- [ ] AttributePool/AttributeMapの整合性チェックテストは十分か
- [ ] SkipListの操作（splice, insert, delete）のテストは境界条件を含むか
- [ ] collab_clientのメッセージハンドリングは全メッセージタイプをカバーしているか
- [ ] 非同期処理（pad.init, handshake等）のテストは適切なモック/スタブを使用しているか
- [ ] セキュリティ関連（escapeHtml, isValidAuthorToken）のテストは十分か
- [ ] ブラウザ固有の挙動（ace.ts, ace2_inner.ts）に対するテスト戦略は明確か
