---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 111
  claims_with_evidence: 108
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：src-static-js-pluginfw 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の関数・メソッド定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：対象モジュールの全ての公開関数・メソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：108 / 111、根拠なし：3
- 優先レビュー（高）
  1. **C-65, C-66（wrapTaskCb）**：内部ヘルパー関数のためテスト必要性要確認
  2. **C-108〜C-111（plugin_defs初期値）**：単純な初期値確認のため優先度低

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/static/js/pluginfw/hooks.ts` - フック呼び出し機能（callAll, aCallAll, callFirst, aCallFirst, callAllSerial, normalizeValue, checkDeprecation, callHookFnSync, callHookFnAsync, flatten1）
- E-02: `src/static/js/pluginfw/plugins.ts` - プラグイン管理機能（formatPlugins, getPlugins, formatParts, getParts, getHooks, formatHooks, pathNormalization, update, getPackages, loadPlugin, sortParts, partsToParentChildList）
- E-03: `src/static/js/pluginfw/installer.ts` - プラグインインストール機能（install, uninstall, getAvailablePlugins, search, checkForMigration, persistInstalledPlugins, wrapTaskCb）
- E-04: `src/static/js/pluginfw/LinkInstaller.ts` - LinkInstallerクラス（constructor, init, installFromPath, installFromGitHub, installPlugin, listPlugins, uninstallPlugin, linkDependency, unlinkDependency, addSubDependencies, removeSubDependencies, removeSubDependency, checkLinkedDependencies）
- E-05: `src/static/js/pluginfw/client_plugins.ts` - クライアントプラグイン機能（ensure, update, adoptPluginsFromAncestorsOf）
- E-06: `src/static/js/pluginfw/shared.ts` - 共有ユーティリティ（extractHooks, loadFn, clientPluginNames）
- E-07: `src/static/js/pluginfw/tsort.ts` - トポロジカルソート（tsort関数）
- E-08: `src/static/js/pluginfw/plugin_defs.ts` - プラグイン定義データ構造（hooks, loaded, parts, plugins）

## 3) Claims と根拠の対応（レビューの主戦場）

### hooks.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | callAll - 登録済みフック関数が全て呼び出されること | E-01 L193-197 | ○ |
| C-02 | callAll - contextがnullの場合空オブジェクトとして処理 | E-01 L194 | ○ |
| C-03 | callAll - フック関数が未登録の場合空配列返却 | E-01 L195 | ○ |
| C-04 | callAll - undefinedが空配列として扱われる | E-01 L39-44 (normalizeValue) | ○ |
| C-05 | aCallAll - 非同期並列実行 | E-01 L346-353 | ○ |
| C-06 | aCallAll - コールバック対応 | E-01 L347 | ○ |
| C-07 | aCallAll - エラー時Promiseがreject | E-01 L274-285 | ○ |
| C-08 | callAllSerial - 逐次実行 | E-01 L358-366 | ○ |
| C-09 | callAllSerial - 空配列返却 | E-01 L360 | ○ |
| C-10 | callFirst - 最初の有効結果取得 | E-01 L371-380 | ○ |
| C-11 | callFirst - 条件未達時空配列 | E-01 L379 | ○ |
| C-12 | aCallFirst - 非同期最初の結果 | E-01 L403-415 | ○ |
| C-13 | aCallFirst - カスタムpredicate | E-01 L408 | ○ |
| C-14 | normalizeValue - undefined変換 | E-01 L42 | ○ |
| C-15 | normalizeValue - 配列そのまま返却 | E-01 L43 | ○ |
| C-16 | normalizeValue - 非配列ラップ | E-01 L44 | ○ |
| C-17 | normalizeValue - null処理 | E-01 L40-41 (コメント) | ○ |
| C-18 | checkDeprecation - 警告ログ出力 | E-01 L18-25 | ○ |
| C-19 | checkDeprecation - 重複防止 | E-01 L21, L24 | ○ |
| C-20 | callHookFnSync - 同期実行 | E-01 L79-178 | ○ |
| C-21 | callHookFnSync - コールバック値取得 | E-01 L117-119 | ○ |
| C-22 | callHookFnSync - 例外伝播 | E-01 L124-136 | ○ |
| C-23 | callHookFnSync - 二重解決検出 | E-01 L91-104 | ○ |
| C-24 | callHookFnSync - Promise禁止 | E-01 L107-112 | ○ |
| C-25 | callHookFnAsync - 非同期実行 | E-01 L234-323 | ○ |
| C-26 | callHookFnAsync - エラー伝播 | E-01 L274-285, L321 | ○ |
| C-27 | flatten1 - フラット化 | E-01 L48 | ○ |
| C-28 | flatten1 - 空配列 | E-01 L48 | ○ |

### plugins.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | formatPlugins - カンマ区切り | E-02 L31 | ○ |
| C-30 | formatPlugins - 空文字 | E-02 L31 | ○ |
| C-31 | getPlugins - 配列返却 | E-02 L33 | ○ |
| C-32 | formatParts - 改行区切り | E-02 L35 | ○ |
| C-33 | getParts - 配列返却 | E-02 L37 | ○ |
| C-34 | getHooks - Map返却 | E-02 L60-64 | ○ |
| C-35 | formatHooks - テキスト形式 | E-02 L66-92 | ○ |
| C-36 | formatHooks - HTML形式 | E-02 L71, L74, L78, L82-88 | ○ |
| C-37 | pathNormalization - 正規化 | E-02 L94-102 | ○ |
| C-38 | pathNormalization - Windowsパス | E-02 L95-98 | ○ |
| C-39 | pathNormalization - デフォルト関数名 | E-02 L97 | ○ |
| C-40 | update - プラグインロード | E-02 L104-124 | ○ |
| C-41 | update - init_*フック呼び出し | E-02 L120-123 | ○ |
| C-42 | getPackages - ep_プレフィックスフィルタ | E-02 L126-147 | ○ |
| C-43 | getPackages - ep_etherpad-lite包含 | E-02 L139-144 | ○ |
| C-44 | loadPlugin - ep.json読み込み | E-02 L149-168 | ○ |
| C-45 | loadPlugin - ファイル不在エラー | E-02 L165-167 | ○ |
| C-46 | loadPlugin - JSONパースエラー | E-02 L162-164 | ○ |
| C-47 | sortParts - トポロジカルソート | E-02 L187-189 | ○ |
| C-48 | partsToParentChildList - post変換 | E-02 L173-175 | ○ |
| C-49 | partsToParentChildList - pre変換 | E-02 L176-177 | ○ |
| C-50 | partsToParentChildList - 依存なし | E-02 L178-181 | ○ |

### installer.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-51 | install - インストール | E-03 L156-163 | ○ |
| C-52 | install - フック呼び出し | E-03 L161 | ○ |
| C-53 | uninstall - アンインストール | E-03 L146-154 | ○ |
| C-54 | uninstall - フック呼び出し | E-03 L152 | ○ |
| C-55 | getAvailablePlugins - API取得 | E-03 L168-180 | ○ |
| C-56 | getAvailablePlugins - キャッシュ利用 | E-03 L172-174 | ○ |
| C-57 | getAvailablePlugins - キャッシュ無効 | E-03 L172 | ○ |
| C-58 | search - 検索 | E-03 L183-215 | ○ |
| C-59 | search - 空検索語 | E-03 L187-189 | ○ |
| C-60 | search - 大文字小文字無視 | E-03 L188, L196-198 | ○ |
| C-61 | search - エラーハンドリング | E-03 L212-214 | ○ |
| C-62 | checkForMigration - マイグレーション | E-03 L81-130 | ○ |
| C-63 | checkForMigration - プラグイン復元 | E-03 L122-129 | ○ |
| C-64 | persistInstalledPlugins - 永続化 | E-03 L132-144 | ○ |
| C-65 | wrapTaskCb - 完了処理 | E-03 L46-54 | ○ |
| C-66 | wrapTaskCb - 複数タスク | E-03 L47, L52 | ○ |

### LinkInstaller.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | constructor - 初期化 | E-04 L19-27 | ○ |
| C-68 | init - 依存関係追加 | E-04 L30-39 | ○ |
| C-69 | installFromPath - パスインストール | E-04 L41-45 | ○ |
| C-70 | installFromGitHub - GitHub | E-04 L47-51 | ○ |
| C-71 | installPlugin - npm | E-04 L53-63 | ○ |
| C-72 | installPlugin - バージョン指定 | E-04 L54-57 | ○ |
| C-73 | listPlugins - 一覧 | E-04 L65-75 | ○ |
| C-74 | listPlugins - 依存チェック | E-04 L70-72 | ○ |
| C-75 | uninstallPlugin - アンインストール | E-04 L77-85 | ○ |
| C-76 | uninstallPlugin - 依存削除 | E-04 L83 | ○ |
| C-77 | linkDependency - リンク作成 | E-04 L204-220 | ○ |
| C-78 | linkDependency - スキップ | E-04 L206-208 | ○ |
| C-79 | linkDependency - スコープ付き | E-04 L210-212 | ○ |
| C-80 | unlinkDependency - 削除 | E-04 L222-230 | ○ |
| C-81 | unlinkDependency - 不在時 | E-04 L227-229 | ○ |
| C-82 | addSubDependencies - 追加 | E-04 L174-179 | ○ |
| C-83 | removeSubDependencies - 削除 | E-04 L87-93 | ○ |
| C-84 | removeSubDependency - 共有保護 | E-04 L95-99 | ○ |

### client_plugins.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-85 | ensure - 未ロード時update呼び出し | E-05 L9 | ○ |
| C-86 | ensure - ロード済み時コールバック | E-05 L9 | ○ |
| C-87 | update - サーバー取得 | E-05 L11-18 | ○ |
| C-88 | update - loaded設定 | E-05 L17 | ○ |
| C-89 | adoptPluginsFromAncestorsOf - 継承 | E-05 L20-46 | ○ |
| C-90 | adoptPluginsFromAncestorsOf - エラー | E-05 L35 | ○ |

### shared.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | extractHooks - 抽出 | E-06 L43-82 | ○ |
| C-92 | extractHooks - normalizer適用 | E-06 L51 | ○ |
| C-93 | extractHooks - 無効化フック | E-06 L53-60 | ○ |
| C-94 | extractHooks - ロードエラー | E-06 L65-69 | ○ |
| C-95 | loadFn - 関数ロード | E-06 L13-41 | ○ |
| C-96 | loadFn - Windowsパス | E-06 L17-23 | ○ |
| C-97 | loadFn - デフォルト関数名 | E-06 L35 | ○ |
| C-98 | loadFn - ネスト解決 | E-06 L37-39 | ○ |
| C-99 | loadFn - ModuleMap対応 | E-06 L29-33 | ○ |
| C-100 | clientPluginNames - 取得 | E-06 L98-103 | ○ |
| C-101 | clientPluginNames - 重複除去 | E-06 L102 | ○ |
| C-102 | clientPluginNames - 空結果 | E-06 L99-102 | ○ |

### tsort.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-103 | tsort - ソート | E-07 L13-59 | ○ |
| C-104 | tsort - 複数ルート | E-07 L24-30, L56 | ○ |
| C-105 | tsort - 循環検出 | E-07 L47 | ○ |
| C-106 | tsort - 空入力 | E-07 L24, L56 | ○ |
| C-107 | tsort - 単一エッジ | E-07 L24-30 | ○ |

### plugin_defs.ts
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-108 | hooks初期値 | E-08 L11 | ○ |
| C-109 | loaded初期値 | E-08 L14 | ○ |
| C-110 | parts初期値 | E-08 L17 | ○ |
| C-111 | plugins初期値 | E-08 L28 | ○ |

## 4) 不足情報（Unknown / Missing）
- wrapTaskCb (C-65, C-66): 内部ヘルパー関数であり、直接テストするか統合テストで検証するか判断が必要
- plugin_defs初期値 (C-108〜C-111): 単純な初期値確認であり、他のテストで間接的にカバーされる可能性あり

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 本モジュール全体
  - 根拠となるソースコードが明確に存在
  - 各関数の入出力が明確に定義されている
  - テストケースとソースコードの対応が取れている

## 6) レビュアーチェックリスト（最小）
- [ ] hooks.ts: callHookFnSync/callHookFnAsyncの二重解決検出テストが適切か確認
- [ ] plugins.ts: Windowsパス正規化テストが実行環境で動作するか確認
- [ ] installer.ts: ネットワーク依存テスト（getAvailablePlugins）のモック方針確認
- [ ] LinkInstaller.ts: ファイルシステム操作（symlink）のモック方針確認
- [ ] client_plugins.ts: ブラウザ環境依存（jQuery, clientVars）のテスト方針確認
- [ ] tsort.ts: 循環依存検出テストのエラーメッセージ形式確認
- [ ] 全体: 内部関数（private/非export）のテスト必要性判断
