---
generated_at: 2026-02-10 14:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：ui-src 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースがソースコードに基づいて生成されている

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `ui/src/main.ts` - ログイン画面のメインスクリプト（57行）
- E-02: `ui/src/consent.ts` - 同意画面のスクリプト（36行）
- E-03: `ui/login.html` - ログイン画面のHTMLテンプレート（39行）
- E-04: `ui/consent.html` - 同意画面のHTMLテンプレート（25行）
- E-05: `ui/package.json` - UIモジュールのパッケージ設定

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | client_id表示処理（正常系） | E-01（7行目: `document.getElementById('client')!.innerText = searchParams.get('client_id')!`）, E-03（13行目: `<span id="client">`) | ○ |
| C-02 | client_id表示処理（異常系） | E-01（7行目: non-null assertionを使用しているためnull時の動作は未定義） | ○ |
| C-03 | フォーム送信成功時の処理 | E-01（10-36行目: `form.addEventListener('submit', ...)`, `fetch('/interaction/' + sessionId, ...)`) | ○ |
| C-04 | リダイレクトレスポンス処理 | E-01（27-30行目: `if (response.redirected) { window.location.href = response.url; }`) | ○ |
| C-05 | サーバーエラー時のエラー表示 | E-01（32行目: `document.getElementById('error')!.innerText = "Error signing in"`) | ○ |
| C-06 | ネットワークエラー時のエラー表示 | E-01（34-35行目: `.catch(error => { ... "Error signing in" + error; })`) | ○ |
| C-07 | FormDataのJSON変換 | E-01（12-16行目: `const formData = new FormData(form)`, `formData.forEach((value, key) => { data[key] = value; })`) | ○ |
| C-08 | 空フォームデータの境界値 | E-01（12-16行目: FormData forEach処理はフィールドが空でも動作） | ○ |
| C-09 | パスワード非表示から表示への切替 | E-01（41-51行目: `togglePasswordVisibility`関数, `if (passwordInput.type === 'password')`) | ○ |
| C-10 | パスワード表示から非表示への切替 | E-01（47-51行目: `else`ブロック, `passwordInput.type = 'password'`) | ○ |
| C-11 | パスワード入力要素欠損時の挙動 | E-01（42行目: `document.getElementsByName('password')[0] as HTMLInputElement`で要素取得） | ○ |
| C-12 | イベントリスナー登録確認 | E-01（55-56行目: `hidePassword.addEventListener('click', togglePasswordVisibility)`, `showPassword.addEventListener('click', togglePasswordVisibility)`) | ○ |
| C-13 | consent.ts セッションID取得（正常系） | E-02（5行目: `const sessionId = new URLSearchParams(window.location.search).get('state')`) | ○ |
| C-14 | consent.ts セッションID取得（異常系） | E-02（5行目: URLSearchParams.getはパラメータ未存在時にnullを返す） | ○ |
| C-15 | consent.ts フォームaction設定（正常系） | E-02（7行目: `form.action = '/interaction/' + sessionId`) | ○ |
| C-16 | consent.ts stateがnullの場合 | E-02（7行目: 文字列連結時にnullは'null'に変換される） | ○ |
| C-17 | consent.ts stateが空文字の場合 | E-02（7行目: 空文字との連結は'/interaction/'となる） | ○ |
| C-18 | Content-Typeヘッダー設定 | E-01（22-23行目: `headers: { 'Content-Type': 'application/json' }`) | ○ |
| C-19 | リダイレクトオプション設定 | E-01（24行目: `redirect: 'follow'`) | ○ |
| C-20 | 複数URLパラメータのパース | E-01（4行目: `new URLSearchParams(window.location.search)` - 標準APIの仕様） | ○ |

## 4) 不足情報（Unknown / Missing）
- **なし**: すべてのテストケースはソースコードの実装に基づいて生成されている

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - ui-srcモジュールは小規模なUIコンポーネント（2ファイル、約90行）であり、すべてのテストケースがソースコードから直接導出されている
- 注意点:
  - main.tsではnon-null assertion（!）を多用しているため、DOM要素が存在しない場合のランタイムエラーに注意
  - consent.tsのコメントアウトされたコード（9-35行目）は将来的な実装変更の可能性を示唆

## 6) レビュアーチェックリスト（最小）
- [ ] テストケースがソースコードの各機能を網羅しているか確認
- [ ] DOM操作のnull安全性に関するテストケースが適切か確認
- [ ] fetch APIのエラーハンドリングテストケースが十分か確認
- [ ] パスワード表示/非表示トグルの両方向のテストが含まれているか確認
- [ ] URLパラメータ解析の境界値テストが適切か確認
