---
generated_at: 2026-02-10 12:55:00
metrics:
  claims_total: 55
  claims_with_evidence: 54
  claims_without_evidence: 1
confidence_derived: 0.98
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：54 / 55、根拠なし：1
- 優先レビュー（高）
  1. **UAT-001 テキスト入力と表示確認**：既存テストファイルに直接対応するものがない（基本機能として推測）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/tests/frontend-new/specs/bold.spec.ts`
- E-02: `src/tests/frontend-new/specs/italic.spec.ts`
- E-03: `src/tests/frontend-new/specs/strikethrough.spec.ts`
- E-04: `src/tests/frontend-new/specs/ordered_list.spec.ts`
- E-05: `src/tests/frontend-new/specs/unordered_list.spec.ts`
- E-06: `src/tests/frontend-new/specs/indentation.spec.ts`
- E-07: `src/tests/frontend-new/specs/undo.spec.ts`
- E-08: `src/tests/frontend-new/specs/redo.spec.ts`
- E-09: `src/tests/frontend-new/specs/delete.spec.ts`
- E-10: `src/tests/frontend-new/specs/chat.spec.ts`
- E-11: `src/tests/frontend-new/specs/change_user_name.spec.ts`
- E-12: `src/tests/frontend-new/specs/change_user_color.spec.ts`
- E-13: `src/tests/frontend-new/specs/clear_authorship_color.spec.ts`
- E-14: `src/tests/frontend-new/specs/language.spec.ts`
- E-15: `src/tests/frontend-new/specs/embed_value.spec.ts`
- E-16: `src/tests/frontend-new/specs/timeslider.spec.ts`
- E-17: `src/tests/frontend-new/specs/collab_client.spec.ts`
- E-18: `src/tests/frontend-new/specs/urls_become_clickable.spec.ts`
- E-19: `src/tests/frontend-new/specs/editbar.spec.ts`
- E-20: `src/tests/frontend-new/admin-spec/adminsettings.spec.ts`
- E-21: `src/tests/frontend-new/admin-spec/adminupdateplugins.spec.ts`
- E-22: `src/tests/frontend-new/admin-spec/admintroubleshooting.spec.ts`
- E-23: `README.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001 テキスト入力と表示確認 | **根拠なし** | △ |
| C-02 | UAT-002 太字（Bold）設定 | E-01 | ○ |
| C-03 | UAT-003 太字（Bold）キーボードショートカット | E-01 | ○ |
| C-04 | UAT-004 イタリック設定（ボタン） | E-02 | ○ |
| C-05 | UAT-005 イタリック設定（キーボード） | E-02 | ○ |
| C-06 | UAT-006 取り消し線設定 | E-03 | ○ |
| C-07 | UAT-007 番号付きリスト作成 | E-04 | ○ |
| C-08 | UAT-008 番号付きリストの連番維持 | E-04 | ○ |
| C-09 | UAT-009 箇条書きリスト作成 | E-05 | ○ |
| C-10 | UAT-010 箇条書きリストの削除（outdent） | E-05 | ○ |
| C-11 | UAT-011 テキストのインデント（Tabキー） | E-06 | ○ |
| C-12 | UAT-012 テキストのインデント（ボタン） | E-06 | ○ |
| C-13 | UAT-013 インデントの維持（改行時） | E-06 | ○ |
| C-14 | UAT-014 自動インデント（特殊文字終端） | E-06 | ○ |
| C-15 | UAT-015 インデント解除（outdent） | E-06 | ○ |
| C-16 | UAT-016 Undoボタンによる取り消し | E-07 | ○ |
| C-17 | UAT-017 Undoキーボードショートカット | E-07 | ○ |
| C-18 | UAT-018 Redoボタンによるやり直し | E-08 | ○ |
| C-19 | UAT-019 Redoキーボードショートカット | E-08 | ○ |
| C-20 | UAT-020 Backspaceキーによる削除 | E-09 | ○ |
| C-21 | UAT-021 チャットの表示と送信 | E-10 | ○ |
| C-22 | UAT-022 空メッセージの送信防止 | E-10 | ○ |
| C-23 | UAT-023 チャットのスティッキー設定（設定画面） | E-10 | ○ |
| C-24 | UAT-024 チャットのスティッキー設定（アイコン） | E-10 | ○ |
| C-25 | UAT-025 URLパラメータでのチャット非表示 | E-10 | ○ |
| C-26 | UAT-026 ユーザー名の設定と保持 | E-11 | ○ |
| C-27 | UAT-027 ユーザー名のチャット表示 | E-11 | ○ |
| C-28 | UAT-028 ユーザーカラーの設定と保持 | E-12 | ○ |
| C-29 | UAT-029 ユーザーカラーのチャット表示 | E-12 | ○ |
| C-30 | UAT-030 著者色のクリア | E-13 | ○ |
| C-31 | UAT-031 著者色クリアのUndo不可 | E-13 | ○ |
| C-32 | UAT-032 言語をドイツ語に変更 | E-14 | ○ |
| C-33 | UAT-033 言語を英語に変更 | E-14 | ○ |
| C-34 | UAT-034 RTL言語への切り替え | E-14 | ○ |
| C-35 | UAT-035 LTR言語への切り替え | E-14 | ○ |
| C-36 | UAT-036 共有リンクの取得 | E-15 | ○ |
| C-37 | UAT-037 埋め込みコードの取得（読み書き可） | E-15 | ○ |
| C-38 | UAT-038 読み取り専用リンクの取得 | E-15 | ○ |
| C-39 | UAT-039 読み取り専用埋め込みコード | E-15 | ○ |
| C-40 | UAT-040 タイムスライダーへの遷移 | E-16 | ○ |
| C-41 | UAT-041 複数ユーザーの同時編集 | E-17 | ○ |
| C-42 | UAT-042 URL入力時の自動リンク化 | E-18 | ○ |
| C-43 | UAT-043 www形式URLの自動リンク化 | E-18 | ○ |
| C-44 | UAT-044 特殊文字を含むURLのリンク化 | E-18 | ○ |
| C-45 | UAT-045 ホームボタンによるホーム画面遷移 | E-19 | ○ |
| C-46 | UAT-046 管理画面へのログイン | E-20 | ○ |
| C-47 | UAT-047 設定の表示と編集 | E-20 | ○ |
| C-48 | UAT-048 Etherpadの再起動 | E-20 | ○ |
| C-49 | UAT-049 プラグイン一覧の表示 | E-21 | ○ |
| C-50 | UAT-050 プラグインの検索 | E-21 | ○ |
| C-51 | UAT-051 プラグインのインストールとアンインストール | E-21 | ○ |
| C-52 | UAT-052 トラブルシューティング画面の表示 | E-22 | ○ |
| C-53 | UAT-053 バージョン番号の表示 | E-22 | ○ |
| C-54 | UAT-054 インストール済みパーツの表示 | E-22 | ○ |
| C-55 | UAT-055 インストール済みフックの表示 | E-22 | ○ |

## 4) 不足情報（Unknown / Missing）
- **UAT-001 テキスト入力と表示確認**：基本的なテキスト入力機能のテストケース
  - 理由：既存のE2Eテストファイルに直接対応するテストがないが、これは全てのテストの前提条件として暗黙的にテストされている基本機能
  - 候補：`src/tests/frontend-new/helper/padHelper.ts` の `writeToPad` / `goToNewPad` 関数

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全体の信頼度が0.98と高く、ほぼ全てのテストケースがソースコードに基づいている
- UAT-001の根拠不足については、基本機能として他のテストケースの前提条件に含まれているため、実質的なリスクは低い
- 管理者機能（UAT-046〜UAT-055）はadmin-specディレクトリのテストファイルを根拠としている

## 6) レビュアーチェックリスト（最小）
- [ ] UAT-001のテストケースが妥当かどうか確認（基本機能として明示的なテストが必要か判断）
- [ ] 各テストケースのテスト手順が実際の操作と一致しているか確認
- [ ] 期待結果が適切かどうか確認
- [ ] 優先度の設定が適切かどうか確認（高/中/低）
- [ ] 管理者ロールのテストケース（UAT-046〜UAT-055）が管理者権限のみでアクセス可能な機能を正しくカバーしているか確認
