# 帳票設計書 5-Microsoft Wordエクスポート

## 概要

本ドキュメントは、Etherpadのパッド（共同編集ドキュメント）をMicrosoft Word形式（.doc）でエクスポートする機能に関する設計書である。ワープロソフトで編集可能な文書として取得するための仕様を定義する。

### 本帳票の処理概要

Microsoft Wordエクスポート機能は、Etherpadのパッドコンテンツを一度HTML形式に変換し、外部ツール（LibreOffice）を使用してODT形式を経由してDOC形式に変換する2段階の処理を行う。Microsoft Wordで編集可能な文書として提供される。

**業務上の目的・背景**：Microsoft Wordは企業や組織で最も広く使用されている文書作成ソフトウェアである。Etherpadで共同編集した内容をWordで再編集したい場合、社内文書テンプレートに統合したい場合、Wordを標準フォーマットとする組織に提出する場合などにDOC形式でのエクスポートが必要となる。互換性と編集可能性を両立するために重要な機能である。

**帳票の利用シーン**：ユーザーがパッドの内容をMicrosoft Wordで開いて追加編集したい場合、社内の文書管理システムにWord形式で登録したい場合、Word形式での提出が求められる場合、オフラインでWord環境で編集したい場合に利用される。報告書、提案書、マニュアルなど多様なビジネス文書の作成に使用される。

**主要な出力内容**：
1. パッドのテキストコンテンツ（全文）
2. 書式情報（太字、斜体、下線、取り消し線）
3. 見出し構造
4. リスト構造
5. ハイパーリンク

**帳票の出力タイミング**：ユーザーがパッドページにアクセスし、エクスポートメニューからMicrosoft Word形式を選択した時点で生成・ダウンロードされる。HTML→ODT→DOCの2段階変換が必要なため、他の形式より処理時間がかかる。

**帳票の利用者**：パッドにアクセス権限を持つ全てのユーザー（編集者、閲覧者）が利用可能。ただし、サーバー側にLibreOffice（soffice）がインストールされている必要がある。

## 帳票種別

ドキュメントエクスポート（Microsoft Word形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | パッド編集画面 | `/p/:pad/export/doc` | エクスポートメニューから「Microsoft Word」を選択 |
| - | パッド編集画面（リビジョン指定） | `/p/:pad/:rev/export/doc` | エクスポートメニューから「Microsoft Word」を選択（リビジョン指定） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | DOC（Microsoft Word 97-2003形式） |
| 用紙サイズ | LibreOfficeのデフォルト設定に依存（通常A4） |
| 向き | LibreOfficeのデフォルト設定に依存（通常縦） |
| ファイル名 | `{padId}.doc` または `{readOnlyId}.doc` |
| 出力方法 | ダウンロード（`Content-Disposition: attachment`） |
| 文字コード | UTF-8（内部HTML）→ DOC埋め込みエンコーディング |

### Word固有設定

| 項目 | 内容 |
|-----|------|
| 形式 | DOC（Word 97-2003互換） |
| 中間形式 | ODT（OpenDocument Text） |
| 変換ツール | LibreOffice（soffice）必須 |
| パスワード保護 | 無（デフォルト） |

### 変換プロセス

| ステップ | 入力形式 | 出力形式 | 説明 |
|---------|---------|---------|------|
| 1 | HTML | ODT | LibreOfficeでHTMLをODTに変換 |
| 2 | ODT | DOC | LibreOfficeでODTをDOCに変換 |

## 帳票レイアウト

### レイアウト概要

Word文書のレイアウトは、HTML→ODT→DOCの変換過程でLibreOfficeによってレンダリングされる。

```
┌─────────────────────────────────────┐
│            Word文書ページ            │
│                                     │
│  [変換元HTMLの内容がレンダリング]      │
│                                     │
│  - 段落テキスト                      │
│  - 見出し（スタイル適用）             │
│  - リスト                           │
│  - インライン書式                    │
│                                     │
└─────────────────────────────────────┘
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 段落 | 通常テキスト | HTML本文 | Wordの標準段落 |
| 2 | 見出し | h1/h2見出し | heading属性 | 見出しスタイル |
| 3 | 太字 | 強調テキスト | bold属性 | ボールド体 |
| 4 | 斜体 | 斜体テキスト | italic属性 | イタリック体 |
| 5 | 下線 | 下線テキスト | underline属性 | 下線付き |
| 6 | 取り消し線 | 取り消しテキスト | strikethrough属性 | 取り消し線付き |
| 7 | 番号リスト | 番号付きリスト | list属性 | Wordの番号付きリスト |
| 8 | 箇条書き | 箇条書きリスト | list属性 | Wordの箇条書き |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パッドID | エクスポート対象のパッド識別子 | Yes |
| リビジョン番号 | 特定バージョンを指定（省略時は最新） | No |
| アクセス権限 | パッドへの読み取り権限 | Yes |
| 変換ツール | sofficeが利用可能 | Yes |

### 前提条件

| 条件名 | 説明 |
|-------|------|
| exportAvailable | `settings.soffice` または `settings.abiword` が設定されていること |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 行番号 | 昇順（テキスト出現順） |

### 改ページ条件

LibreOfficeの自動改ページに依存

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| pad:{padId} | パッドメタ情報 | キー直接参照 |
| pad:{padId}:revs:{revNum} | リビジョン履歴 | リビジョン番号指定時 |

### テーブル別参照項目詳細

#### pad:{padId}

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| atext.text | 本文テキスト | 常時 | 最新テキスト |
| atext.attribs | 属性情報 | 常時 | 書式・リスト情報 |
| pool | 属性プール | 常時 | 属性ID→属性値マッピング |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 一時HTMLファイル名 | `etherpad_export_${randNum}.html` | - | randNum: 0〜0xFFFFFFFF |
| 中間ODTファイル名 | `etherpad_export_${randNum}.odt` | - | destFile.replace(/\.doc$/, '.odt') |
| 出力DOCファイル名 | `etherpad_export_${randNum}.doc` | - | 最終出力 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートリクエスト<br>/p/:pad/export/doc] --> B{ファイル形式チェック}
    B -->|doc| C{exportAvailable?}
    B -->|サポート外| Z[404エラー]
    C -->|no| W[エラーメッセージ<br>変換ツールなし]
    C -->|yes/withoutPDF| D[アクセス権限確認]
    D -->|権限なし| Y[アクセス拒否]
    D -->|権限あり| E{readOnlyId?}
    E -->|Yes| F[readOnlyIdからpadId取得]
    E -->|No| G[padIdを使用]
    F --> H[パッド存在確認]
    G --> H
    H -->|存在しない| X[404エラー]
    H -->|存在する| I[HTML生成<br>getPadHTMLDocument]
    I --> J[一時HTMLファイル作成]
    J --> K{exportConvertフック?}
    K -->|プラグイン処理| L[プラグインで変換]
    K -->|デフォルト| M[LibreOffice変換<br>type=doc特殊処理]
    M --> N[中間ODTファイル生成<br>HTML→ODT]
    N --> O[最終DOCファイル生成<br>ODT→DOC]
    L --> P[res.sendFile<br>DOCファイル送信]
    O --> P
    P --> Q[一時ファイル削除]
    Q --> END[完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 変換ツールなし | soffice/abiwordが未設定 | This export is not enabled at this Etherpad instance. Set the path to Abiword or soffice (LibreOffice) in settings.json to enable this feature | 管理者にツール設定を依頼 |
| パッド不存在 | 指定されたpadIdが存在しない | 404 Not Found | ログ出力後、404レスポンス |
| アクセス拒否 | パッドへの読み取り権限がない | アクセス権に応じた処理 | hasPadAccess関数で判定 |
| 変換タイムアウト | LibreOfficeが120秒以内に完了しない | エラーログ出力 | プロセスをkill |
| 変換失敗 | LibreOfficeがエラー終了 | エラーログ出力 | スタックトレース出力 |
| 直接変換不可 | HTMLからDOCへの直接変換エラー | no export filter for *.doc | ODT経由の2段階変換で回避（コード実装済み） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1パッド |
| 目標出力時間 | 数秒〜数分（2段階変換のため長め） |
| タイムアウト | 120秒 x 2（各変換ステップ） |
| 同時出力数上限 | 1（変換キューで直列処理） |
| 一時ファイル領域 | os.tmpdir() |

## セキュリティ考慮事項

- **アクセス制御**: hasPadAccess()によるパッド単位のアクセス権限チェック
- **レートリミッター**: DoS攻撃防止のためエクスポートリクエスト数を制限
- **一時ファイル管理**: 処理完了後に一時ファイルを削除（HTML、ODT中間ファイルも含む）
- **外部プロセス実行**: LibreOfficeを子プロセスとして実行、タイムアウト制御あり
- **XSS対策**: HTML生成時にSecurity.escapeHTML()でエスケープ

## 備考

- HTMLからDOCへの直接変換はLibreOffice 5/6で非サポート
- そのため、HTML→ODT→DOCの2段階変換を実装
- コード内コメント: `soffice can't convert from html to doc directly`
- `Error: no export filter for /tmp/xxxx.doc`エラーを回避するための設計
- 中間ODTファイルは変換完了後に自動削除される
- プラグインフック`exportConvert`により変換処理のカスタマイズが可能
- Abiwordでも同様の2段階変換が必要

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定と可用性判定を理解する

DOCエクスポートは外部ツールに依存するため、まず設定と可用性判定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | soffice/abiword設定、exportAvailable関数 |
| 1-2 | importexport.ts | `src/node/hooks/express/importexport.ts` | exportAvailable()による形式制限 |

**読解のコツ**: doc形式は'odt', 'pdf'と同様にexportAvailable='no'の場合は無効。

#### Step 2: エントリーポイントと変換フローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | importexport.ts | `src/node/hooks/express/importexport.ts` | ルーティング、形式チェック |
| 2-2 | ExportHandler.ts | `src/node/handler/ExportHandler.ts` | HTML生成→変換の流れ |

**主要処理フロー**:
1. **38-47行目**: exportAvailable='no'の場合はエラー
2. **77行目**: HTML生成
3. **106-110行目**: コンバーターの選択

#### Step 3: 2段階変換ロジックを理解する

DOC形式特有の2段階変換がLibreOffice.tsに実装されている。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LibreOffice.ts | `src/node/utils/LibreOffice.ts` | convertFile関数のtype='doc'特殊処理 |

**主要処理フロー**:
- **92-117行目**: convertFile関数
- **107-113行目**: `if (type === 'doc')` の特殊処理
- **111行目**: 中間ODTファイルパス生成 `destFile.replace(/\.doc$/, '.odt')`
- **112行目**: 第1段階変換 HTML→ODT
- **113行目**: 第2段階変換 ODT→DOC

#### Step 4: コメントで設計意図を確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LibreOffice.ts | `src/node/utils/LibreOffice.ts` | コメントによる設計説明 |

**主要コメント**:
- **107-109行目**: `// soffice can't convert from html to doc directly`
- **109行目**: `// to avoid 'Error: no export filter for /tmp/xxxx.doc' error`

### プログラム呼び出し階層図

```
HTTPリクエスト /p/:pad/export/doc
    │
    ├─ importexport.ts (expressCreateServer)
    │      └─ args.app.get('/p/:pad{/:rev}/export/:type')
    │             │
    │             ├─ exportAvailable() チェック
    │             ├─ hasPadAccess() - アクセス権確認
    │             ├─ readOnlyManager.getPadId() - ID解決
    │             ├─ padManager.doesPadExists() - 存在確認
    │             └─ exportHandler.doExport()
    │
    └─ ExportHandler.ts (doExport)
           │
           ├─ hooks.aCallFirst('exportFileName') - ファイル名フック
           ├─ res.attachment() - ダウンロード設定
           │
           └─ (type === 'doc') の場合:
                  │
                  ├─ ExportHtml.ts
                  │      └─ getPadHTMLDocument() - HTML生成
                  │
                  ├─ fs.writeFile() - 一時HTMLファイル作成
                  │
                  └─ LibreOffice.ts
                         │
                         └─ convertFile(srcFile, destFile, 'doc')
                                │
                                ├─ (type === 'doc' の特殊処理)
                                │
                                ├─ [第1段階] queue.pushAsync
                                │      └─ doConvertTask(HTML→ODT)
                                │             └─ soffice --convert-to odt
                                │
                                └─ [第2段階] queue.pushAsync
                                       └─ doConvertTask(ODT→DOC)
                                              └─ soffice --convert-to doc
```

### データフロー図

```
[入力]                    [処理]                              [出力]

pad:{padId}          ┌────────────────┐
  │                  │                │
  ├─ atext ─────────▶│ ExportHtml.ts  │
  │                  │                │
  └─ pool ──────────▶│ HTML生成       │
                     └────────────────┘
                            │
                            ▼ /tmp/etherpad_export_*.html
                     ┌────────────────┐
                     │                │
settings.soffice ───▶│ LibreOffice.ts │
                     │                │
                     │ [第1段階]       │
                     │ HTML → ODT     │
                     │                │
                     └────────────────┘
                            │
                            ▼ /tmp/etherpad_export_*.odt (中間ファイル)
                     ┌────────────────┐
                     │                │
                     │ LibreOffice.ts │
                     │                │
                     │ [第2段階]       │
                     │ ODT → DOC      │
                     │                │
                     └────────────────┘
                            │
                            ▼ /tmp/etherpad_export_*.doc
                     ┌────────────────┐
                     │                │
                     │ res.sendFile() │──▶ .doc ダウンロード
                     │                │
                     └────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| importexport.ts | `src/node/hooks/express/importexport.ts` | ソース | Expressルーティング、exportAvailableチェック |
| ExportHandler.ts | `src/node/handler/ExportHandler.ts` | ソース | HTML生成→変換→送信の統括 |
| ExportHtml.ts | `src/node/utils/ExportHtml.ts` | ソース | HTML生成ロジック |
| LibreOffice.ts | `src/node/utils/LibreOffice.ts` | ソース | LibreOffice変換処理、2段階変換ロジック |
| Abiword.ts | `src/node/utils/Abiword.ts` | ソース | Abiword変換処理（フォールバック） |
| Settings.ts | `src/node/utils/Settings.ts` | 設定 | soffice/abiwordパス設定、exportAvailable |
| run_cmd.ts | `src/node/utils/run_cmd.ts` | ソース | 外部コマンド実行ユーティリティ |
| PadType.ts | `src/node/types/PadType.ts` | 型定義 | パッドデータ型 |
| PadManager.ts | `src/node/db/PadManager.ts` | ソース | パッドデータ取得 |
