# 帳票設計書 6-OpenDocumentエクスポート

## 概要

本ドキュメントは、Etherpadのパッド（共同編集ドキュメント）をOpenDocument Text形式（.odt）でエクスポートする機能に関する設計書である。オープンスタンダードな文書フォーマットとして取得するための仕様を定義する。

### 本帳票の処理概要

OpenDocumentエクスポート機能は、Etherpadのパッドコンテンツを一度HTML形式に変換し、外部ツール（LibreOfficeまたはAbiword）を使用してODT形式に変換する処理を行う。LibreOffice、OpenOffice、Google Docsなど多くのオフィスソフトで編集可能な文書として提供される。

**業務上の目的・背景**：OpenDocument Format（ODF）はISO/IEC 26300として標準化されたオープンな文書フォーマットである。ベンダーロックインを避けたい組織、オープンソースソフトウェアを使用する組織、長期保存・アーカイブを重視する組織において、ODT形式でのエクスポートが求められる。また、LibreOfficeやGoogle Docsでの編集互換性が高いことも利点である。

**帳票の利用シーン**：ユーザーがパッドの内容をLibreOfficeやOpenOfficeで開いて編集したい場合、Microsoft Wordを持たない環境で文書を共有したい場合、オープンフォーマットでのアーカイブが必要な場合、Google Docsにインポートしたい場合に利用される。政府機関や公的機関ではODFが推奨・義務付けられていることもある。

**主要な出力内容**：
1. パッドのテキストコンテンツ（全文）
2. 書式情報（太字、斜体、下線、取り消し線）
3. 見出し構造
4. リスト構造
5. ハイパーリンク

**帳票の出力タイミング**：ユーザーがパッドページにアクセスし、エクスポートメニューからOpenDocument形式を選択した時点で生成・ダウンロードされる。外部ツールによる変換が必要なため、HTML/TXT形式より処理時間がかかる場合がある。

**帳票の利用者**：パッドにアクセス権限を持つ全てのユーザー（編集者、閲覧者）が利用可能。ただし、サーバー側にLibreOfficeまたはAbiwordがインストールされている必要がある。

## 帳票種別

ドキュメントエクスポート（OpenDocument Text形式）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | パッド編集画面 | `/p/:pad/export/odt` | エクスポートメニューから「OpenDocument」を選択 |
| - | パッド編集画面（リビジョン指定） | `/p/:pad/:rev/export/odt` | エクスポートメニューから「OpenDocument」を選択（リビジョン指定） |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | ODT（OpenDocument Text、ISO/IEC 26300） |
| 用紙サイズ | LibreOffice/Abiwordのデフォルト設定に依存（通常A4） |
| 向き | LibreOffice/Abiwordのデフォルト設定に依存（通常縦） |
| ファイル名 | `{padId}.odt` または `{readOnlyId}.odt` |
| 出力方法 | ダウンロード（`Content-Disposition: attachment`） |
| 文字コード | UTF-8 |
| MIMEタイプ | application/vnd.oasis.opendocument.text |

### ODT固有設定

| 項目 | 内容 |
|-----|------|
| 変換ツール | LibreOffice（soffice）またはAbiword |
| 変換方式 | HTML→ODT（1段階変換） |
| 変換タイムアウト | 120秒 |
| パスワード保護 | 無（デフォルト） |

### 対応アプリケーション

| アプリケーション | 対応状況 |
|----------------|---------|
| LibreOffice Writer | 完全対応 |
| OpenOffice Writer | 完全対応 |
| Microsoft Word 2007以降 | 読み込み対応 |
| Google Docs | インポート対応 |
| Apple Pages | インポート対応 |

## 帳票レイアウト

### レイアウト概要

ODT文書のレイアウトは、HTMLからLibreOffice/Abiwordによって変換・レンダリングされる。

```
┌─────────────────────────────────────┐
│           ODT文書ページ              │
│                                     │
│  [変換元HTMLの内容がレンダリング]      │
│                                     │
│  - 段落テキスト                      │
│  - 見出し（ODTスタイル適用）          │
│  - リスト                           │
│  - インライン書式                    │
│                                     │
└─────────────────────────────────────┘
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 段落 | 通常テキスト | HTML本文 | ODTの標準段落 |
| 2 | 見出し | h1/h2見出し | heading属性 | 見出しスタイル |
| 3 | 太字 | 強調テキスト | bold属性 | ボールド体 |
| 4 | 斜体 | 斜体テキスト | italic属性 | イタリック体 |
| 5 | 下線 | 下線テキスト | underline属性 | 下線付き |
| 6 | 取り消し線 | 取り消しテキスト | strikethrough属性 | 取り消し線付き |
| 7 | 番号リスト | 番号付きリスト | list属性 | ODTの番号付きリスト |
| 8 | 箇条書き | 箇条書きリスト | list属性 | ODTの箇条書き |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| パッドID | エクスポート対象のパッド識別子 | Yes |
| リビジョン番号 | 特定バージョンを指定（省略時は最新） | No |
| アクセス権限 | パッドへの読み取り権限 | Yes |
| 変換ツール | sofficeまたはabiwordが利用可能 | Yes |

### 前提条件

| 条件名 | 説明 |
|-------|------|
| exportAvailable | `settings.soffice` または `settings.abiword` が設定されていること |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 行番号 | 昇順（テキスト出現順） |

### 改ページ条件

LibreOffice/Abiwordの自動改ページに依存

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| pad:{padId} | パッドメタ情報 | キー直接参照 |
| pad:{padId}:revs:{revNum} | リビジョン履歴 | リビジョン番号指定時 |

### テーブル別参照項目詳細

#### pad:{padId}

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| atext.text | 本文テキスト | 常時 | 最新テキスト |
| atext.attribs | 属性情報 | 常時 | 書式・リスト情報 |
| pool | 属性プール | 常時 | 属性ID→属性値マッピング |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 一時HTMLファイル名 | `etherpad_export_${randNum}.html` | - | randNum: 0〜0xFFFFFFFF |
| 出力ODTファイル名 | `etherpad_export_${randNum}.odt` | - | 最終出力 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[エクスポートリクエスト<br>/p/:pad/export/odt] --> B{ファイル形式チェック}
    B -->|odt| C{exportAvailable?}
    B -->|サポート外| Z[404エラー]
    C -->|no| W[エラーメッセージ<br>変換ツールなし]
    C -->|yes/withoutPDF| D[アクセス権限確認]
    D -->|権限なし| Y[アクセス拒否]
    D -->|権限あり| E{readOnlyId?}
    E -->|Yes| F[readOnlyIdからpadId取得]
    E -->|No| G[padIdを使用]
    F --> H[パッド存在確認]
    G --> H
    H -->|存在しない| X[404エラー]
    H -->|存在する| I[HTML生成<br>getPadHTMLDocument]
    I --> J[一時HTMLファイル作成]
    J --> K{exportConvertフック?}
    K -->|プラグイン処理| L[プラグインで変換]
    K -->|デフォルト| M{soffice設定?}
    M -->|Yes| N[LibreOffice変換]
    M -->|No| O[Abiword変換]
    N --> P[ODT生成<br>HTML→ODT]
    O --> P
    L --> P
    P --> Q[res.sendFile<br>ODTファイル送信]
    Q --> R[一時ファイル削除]
    R --> END[完了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 変換ツールなし | soffice/abiwordが未設定 | This export is not enabled at this Etherpad instance. Set the path to Abiword or soffice (LibreOffice) in settings.json to enable this feature | 管理者にツール設定を依頼 |
| パッド不存在 | 指定されたpadIdが存在しない | 404 Not Found | ログ出力後、404レスポンス |
| アクセス拒否 | パッドへの読み取り権限がない | アクセス権に応じた処理 | hasPadAccess関数で判定 |
| 変換タイムアウト | LibreOfficeが120秒以内に完了しない | エラーログ出力 | プロセスをkill |
| 変換失敗 | LibreOffice/Abiwordがエラー終了 | エラーログ出力 | スタックトレース出力 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1パッド |
| 目標出力時間 | 数秒〜2分（変換処理に依存） |
| タイムアウト | 120秒（LibreOffice変換） |
| 同時出力数上限 | 1（変換キューで直列処理） |
| 一時ファイル領域 | os.tmpdir() |

## セキュリティ考慮事項

- **アクセス制御**: hasPadAccess()によるパッド単位のアクセス権限チェック
- **レートリミッター**: DoS攻撃防止のためエクスポートリクエスト数を制限
- **一時ファイル管理**: 処理完了後に一時ファイルを削除
- **外部プロセス実行**: LibreOffice/Abiwordを子プロセスとして実行、タイムアウト制御あり
- **XSS対策**: HTML生成時にSecurity.escapeHTML()でエスケープ

## 備考

- ODT形式はHTML→ODTの1段階変換で生成される（DOC形式のような2段階変換は不要）
- LibreOfficeが優先、Abiwordはフォールバック
- LibreOfficeは`--headless`モードで実行（GUI不要）
- 変換キューは1つずつ処理（async.queue(doConvertTask, 1)）
- Windowsではファイル削除前に100msの遅延を入れる
- プラグインフック`exportConvert`により変換処理のカスタマイズが可能
- ODT形式はDOC形式への中間形式としても使用される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: 設定と可用性判定を理解する

ODTエクスポートは外部ツールに依存するため、まず設定と可用性判定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | soffice/abiword設定、exportAvailable関数 |
| 1-2 | importexport.ts | `src/node/hooks/express/importexport.ts` | exportAvailable()による形式制限 |

**読解のコツ**: odt形式は'doc', 'pdf'と同様にexportAvailable='no'の場合は無効。

#### Step 2: エントリーポイントと変換フローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | importexport.ts | `src/node/hooks/express/importexport.ts` | ルーティング、形式チェック |
| 2-2 | ExportHandler.ts | `src/node/handler/ExportHandler.ts` | HTML生成→変換の流れ |

**主要処理フロー**:
1. **38-47行目**: exportAvailable='no'の場合はエラー
2. **77行目**: HTML生成 `getPadHTMLDocument`
3. **91-93行目**: 一時HTMLファイル作成
4. **106-110行目**: コンバーターの選択（LibreOffice優先）

#### Step 3: LibreOffice変換処理を理解する

ODT形式は通常の1段階変換で処理される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | LibreOffice.ts | `src/node/utils/LibreOffice.ts` | convertFile関数 |

**主要処理フロー**:
- **92-117行目**: convertFile関数
- **110行目**: type='doc'でなければ通常の1段階変換
- **115行目**: `queue.pushAsync({srcFile, destFile, type, fileExtension})`
- **30-79行目**: doConvertTask - sofficeコマンド実行

#### Step 4: ODT変換オプションを確認

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | LibreOffice.ts | `src/node/utils/LibreOffice.ts` | sofficeコマンドライン引数 |

**主要処理フロー**:
- **38-49行目**: sofficeコマンドライン引数
- **45-46行目**: `--convert-to` + type
- **47行目**: srcFile指定
- **48-49行目**: `--outdir` + tmpDir

### プログラム呼び出し階層図

```
HTTPリクエスト /p/:pad/export/odt
    │
    ├─ importexport.ts (expressCreateServer)
    │      └─ args.app.get('/p/:pad{/:rev}/export/:type')
    │             │
    │             ├─ exportAvailable() チェック
    │             │      └─ Settings.ts: soffice/abiword設定確認
    │             ├─ hasPadAccess() - アクセス権確認
    │             ├─ readOnlyManager.getPadId() - ID解決
    │             ├─ padManager.doesPadExists() - 存在確認
    │             └─ exportHandler.doExport()
    │
    └─ ExportHandler.ts (doExport)
           │
           ├─ hooks.aCallFirst('exportFileName') - ファイル名フック
           ├─ res.attachment() - ダウンロード設定
           │
           └─ (type === 'odt') の場合:
                  │
                  ├─ ExportHtml.ts
                  │      └─ getPadHTMLDocument() - HTML生成
                  │
                  ├─ fs.writeFile() - 一時HTMLファイル作成
                  │
                  ├─ hooks.aCallAll('exportConvert') - プラグインフック
                  │
                  └─ (プラグインなしの場合)
                         │
                         └─ LibreOffice.ts または Abiword.ts
                                │
                                └─ convertFile(srcFile, destFile, 'odt')
                                       │
                                       └─ [1段階変換]
                                              └─ queue.pushAsync
                                                     └─ doConvertTask(HTML→ODT)
                                                            └─ soffice --convert-to odt
```

### データフロー図

```
[入力]                    [処理]                              [出力]

pad:{padId}          ┌────────────────┐
  │                  │                │
  ├─ atext ─────────▶│ ExportHtml.ts  │
  │                  │                │
  └─ pool ──────────▶│ HTML生成       │
                     └────────────────┘
                            │
                            ▼ /tmp/etherpad_export_*.html
                     ┌────────────────┐
                     │                │
settings.soffice ───▶│ LibreOffice.ts │
                     │                │
                     │ [1段階変換]     │
                     │ HTML → ODT     │
                     │                │
                     └────────────────┘
                            │
                            ▼ /tmp/etherpad_export_*.odt
                     ┌────────────────┐
                     │                │
                     │ res.sendFile() │──▶ .odt ダウンロード
                     │                │
                     └────────────────┘
                            │
                            ▼
                     ┌────────────────┐
                     │ クリーンアップ  │
                     │ 一時ファイル削除│
                     └────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| importexport.ts | `src/node/hooks/express/importexport.ts` | ソース | Expressルーティング、exportAvailableチェック |
| ExportHandler.ts | `src/node/handler/ExportHandler.ts` | ソース | HTML生成→変換→送信の統括 |
| ExportHtml.ts | `src/node/utils/ExportHtml.ts` | ソース | HTML生成ロジック |
| LibreOffice.ts | `src/node/utils/LibreOffice.ts` | ソース | LibreOffice変換処理 |
| Abiword.ts | `src/node/utils/Abiword.ts` | ソース | Abiword変換処理（フォールバック） |
| Settings.ts | `src/node/utils/Settings.ts` | 設定 | soffice/abiwordパス設定、exportAvailable |
| run_cmd.ts | `src/node/utils/run_cmd.ts` | ソース | 外部コマンド実行ユーティリティ |
| PadType.ts | `src/node/types/PadType.ts` | 型定義 | パッドデータ型 |
| PadManager.ts | `src/node/db/PadManager.ts` | ソース | パッドデータ取得 |
