---
generated_at: 2026-02-10 14:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：1-HTMLエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **目標出力時間**：具体的な数値根拠なし（経験則による記載）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express/importexport.ts` - ルーティング定義（29-71行目）
- E-02: `src/node/handler/ExportHandler.ts` - doExport関数（46-126行目）
- E-03: `src/node/utils/ExportHtml.ts` - HTML変換ロジック（34-553行目）
- E-04: `src/node/utils/ExportHelper.ts` - 行解析ヘルパー（55-92行目）
- E-05: `src/templates/export_html.html` - HTMLテンプレート（1-47行目）
- E-06: `src/node/types/PadType.ts` - データ型定義（4-56行目）
- E-07: `src/node/utils/Settings.ts` - 設定定義（685-695行目）
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（2行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは `/p/:pad/export/html` | E-01 (29行目) | ○ |
| C-02 | サポート形式は pdf, doc, txt, html, odt, etherpad | E-01 (31行目) | ○ |
| C-03 | ファイル名は `{padId}.html` 形式 | E-02 (48-59行目) | ○ |
| C-04 | 書式タグは h1, h2, strong, em, u, s | E-03 (51行目) | ○ |
| C-05 | 属性は heading1, heading2, bold, italic, underline, strikethrough | E-03 (52行目) | ○ |
| C-06 | リンクには rel="noreferrer noopener" が付与される | E-03 (286行目) | ○ |
| C-07 | レートリミッターが適用される | E-01 (16-25行目) | ○ |
| C-08 | readOnlyIdの場合はpadIdに変換される | E-01 (56-58行目) | ○ |
| C-09 | exportFileName フックでファイル名変更可能 | E-02 (51-56行目) | ○ |
| C-10 | stylesForExport フックでCSS追加可能 | E-03 (484-487行目) | ○ |
| C-11 | exportHtmlAdditionalTags フックでタグ追加可能 | E-03 (56-60行目) | ○ |
| C-12 | exportHtmlAdditionalTagsWithData フックでdata属性追加可能 | E-03 (64-68行目) | ○ |
| C-13 | exportHTMLAdditionalContent フックで追加コンテンツ挿入可能 | E-03 (491-493行目) | ○ |
| C-14 | exportHTMLSend フックで最終HTML変更可能 | E-02 (84-85行目) | ○ |
| C-15 | テンプレートは export_html.html | E-03 (495-499行目), E-05 | ○ |
| C-16 | DOCTYPE は HTML5 | E-05 (1行目) | ○ |
| C-17 | charset は utf-8 | E-05 (9行目) | ○ |
| C-18 | リスト用CSSカウンタが定義されている | E-05 (11-35行目) | ○ |
| C-19 | _analyzeLine で行属性を解析 | E-04 (55-88行目) | ○ |
| C-20 | list属性は正規表現 `([a-z]+)([0-9]+)` で解析 | E-04 (68行目) | ○ |
| C-21 | Security.escapeHTML でエスケープ処理 | E-03 (261行目) | ○ |
| C-22 | Security.escapeHTMLAttribute でURL属性エスケープ | E-03 (286行目) | ○ |
| C-23 | リビジョン指定時は getInternalRevisionAText を使用 | E-03 (38-40行目) | ○ |
| C-24 | パッド存在確認は padManager.doesPadExists | E-01 (61-64行目) | ○ |
| C-25 | 目標出力時間は1秒以内 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25 目標出力時間について
  - コード上にパフォーマンス要件の記載なし
  - 経験則による推定値として記載
  - 候補：負荷テスト結果 / 運用ログ / 要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 全体的に低リスク。コードと設計書の整合性が高い
- 1: パフォーマンス要件は要確認（実測値がないため）

## 6) レビュアーチェックリスト（最小）
- [ ] タグマッピング（h1, h2, strong, em, u, s）がコードと一致しているか確認
- [ ] フック名（exportFileName, stylesForExport等）が正確か確認
- [ ] セキュリティ対策（escapeHTML, rel属性）の記載が適切か確認
- [ ] パフォーマンス要件について実際の運用データと照合
