---
generated_at: 2026-02-10 14:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-テキストエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express/importexport.ts` - ルーティング定義（29-71行目）
- E-02: `src/node/handler/ExportHandler.ts` - doExport関数（72-74行目）
- E-03: `src/node/utils/ExportTxt.ts` - テキスト変換ロジック（1-272行目）
- E-04: `src/node/utils/ExportHelper.ts` - 行解析ヘルパー（55-88行目）
- E-05: `src/node/types/PadType.ts` - データ型定義（4-56行目）
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（3行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは `/p/:pad/export/txt` | E-01 (29行目) | ○ |
| C-02 | サポート形式リストに txt が含まれる | E-01 (31行目) | ○ |
| C-03 | ファイル名は `{padId}.txt` 形式 | E-02 (48-59行目) | ○ |
| C-04 | txt形式の場合 getPadTXTDocument を呼び出す | E-02 (72-74行目) | ○ |
| C-05 | 箇条書きは `* ` プレフィックスで表現 | E-03 (205-207行目) | ○ |
| C-06 | 番号付きリストは `N. ` 形式で表現 | E-03 (253行目) | ○ |
| C-07 | インデントはタブ文字で表現 | E-03 (218行目) | ○ |
| C-08 | ネストレベルが下がるとカウンタがリセット | E-03 (238-239行目) | ○ |
| C-09 | 階層番号は `1.2.3.` 形式で生成 | E-03 (244-252行目) | ○ |
| C-10 | bulletリスト以外ではカウンタがリセット | E-03 (209-214行目) | ○ |
| C-11 | 属性 heading1〜strikethrough は参照のみ | E-03 (52行目) | ○ |
| C-12 | リビジョン指定時は getInternalRevisionAText を使用 | E-03 (36-39行目) | ○ |
| C-13 | list属性は正規表現 `([a-z]+)([0-9]+)` で解析 | E-04 (68行目) | ○ |
| C-14 | StringIterator と StringAssembler を使用 | E-03 (26-27行目 import) | ○ |
| C-15 | pieces配列に文字列を蓄積し最後にjoin | E-03 (188行目, 263行目) | ○ |
| C-16 | 改行コードは LF (`\n`) | E-03 (257行目, 259行目) | ○ |
| C-17 | レートリミッターが適用される | E-01 (16-25行目) | ○ |
| C-18 | readOnlyIdの場合はpadIdに変換される | E-01 (56-58行目) | ○ |
| C-19 | 特殊文字除去処理はコメントアウトされている | E-03 (163-168行目) | ○ |
| C-20 | getPadTXTDocument は padManager.getPad を呼び出す | E-03 (269行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してソースコードによる根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。コードと設計書の整合性が高い。
- 0: テキストエクスポートは単純な処理のため、リスクが低い。

## 6) レビュアーチェックリスト（最小）
- [ ] リスト番号生成ロジック（階層番号）がコードと一致しているか確認
- [ ] インデント処理（タブ文字使用）がコードと一致しているか確認
- [ ] 箇条書き記号（`* `）の仕様がコードと一致しているか確認
- [ ] コメントアウトされた特殊文字除去処理の意図を確認
