---
generated_at: 2026-02-10 14:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-Etherpadエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express/importexport.ts` - ルーティング定義（29-71行目）
- E-02: `src/node/handler/ExportHandler.ts` - doExport関数（69-71行目）
- E-03: `src/node/utils/ExportEtherpad.ts` - getPadRaw関数（24-64行目）
- E-04: `src/node/db/AuthorManager.ts` - getAuthor関数
- E-05: `src/node/types/PadType.ts` - データ型定義
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（4行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは `/p/:pad/export/etherpad` | E-01 (29行目) | ○ |
| C-02 | サポート形式リストに etherpad が含まれる | E-01 (31行目) | ○ |
| C-03 | ファイル名は `{padId}.etherpad` 形式 | E-02 (48-59行目) | ○ |
| C-04 | etherpad形式の場合 getPadRaw を呼び出す | E-02 (69-71行目) | ○ |
| C-05 | 出力キーは readOnlyId 優先 | E-03 (25行目) | ○ |
| C-06 | exportEtherpadAdditionalContent フックあり | E-03 (28行目) | ○ |
| C-07 | リビジョンは 0〜head まで全て取得 | E-03 (52行目) | ○ |
| C-08 | チャットは 0〜chatHead まで全て取得 | E-03 (53行目) | ○ |
| C-09 | バッチサイズは 100 | E-03 (57行目) | ○ |
| C-10 | バッファは 99 | E-03 (57行目) | ○ |
| C-11 | exportEtherpad フックで最終データ加工可能 | E-03 (58-62行目) | ○ |
| C-12 | 著者情報は authorManager.getAuthor で取得 | E-03 (46行目), E-04 | ○ |
| C-13 | 著者のpadIDsは readOnlyId または padId に置換 | E-03 (48行目) | ○ |
| C-14 | 著者が存在しない場合は undefined を返す | E-03 (47行目) | ○ |
| C-15 | プラグインプレフィックスに * は禁止 | E-03 (33行目) | ○ |
| C-16 | ジェネレータ関数でデータを列挙 | E-03 (43-55行目) | ○ |
| C-17 | pad.getRevision で各リビジョン取得 | E-03 (52行目) | ○ |
| C-18 | pad.getChatMessage で各チャット取得 | E-03 (53行目) | ○ |
| C-19 | pad.getAllAuthors で著者リスト取得 | E-03 (44行目) | ○ |
| C-20 | レートリミッターが適用される | E-01 (16-25行目) | ○ |
| C-21 | readOnlyIdの場合はpadIdに変換される | E-01 (56-58行目) | ○ |
| C-22 | dstPadIdはexportEtherpadフックに渡される | E-03 (61行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してソースコードによる根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。コードと設計書の整合性が高い。
- 1: セキュリティ観点（中リスク）: 著者情報・履歴情報の露出について運用ポリシーとの整合確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] リビジョン取得範囲（0〜head）がコードと一致しているか確認
- [ ] チャット取得範囲（0〜chatHead）がコードと一致しているか確認
- [ ] バッチ処理パラメータ（batch:100, buffer:99）がコードと一致しているか確認
- [ ] プラグインフック名（exportEtherpadAdditionalContent, exportEtherpad）が正確か確認
- [ ] 著者情報の露出についてプライバシーポリシーとの整合性を確認
