---
generated_at: 2026-02-10 14:20:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Microsoft Wordエクスポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。特に優先レビューが必要な項目はなし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/hooks/express/importexport.ts` - ルーティング定義（29-71行目）
- E-02: `src/node/handler/ExportHandler.ts` - doExport関数（46-126行目）
- E-03: `src/node/utils/LibreOffice.ts` - 変換処理、2段階変換（92-117行目）
- E-04: `src/node/utils/Settings.ts` - soffice/abiword設定
- E-05: `src/node/utils/ExportHtml.ts` - HTML生成ロジック
- E-06: `docs/code-to-docs/帳票一覧/帳票一覧.csv` - 帳票一覧（6行目）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは `/p/:pad/export/doc` | E-01 (29行目) | ○ |
| C-02 | サポート形式リストに doc が含まれる | E-01 (31行目) | ○ |
| C-03 | exportAvailable='no'の場合はエラーメッセージ | E-01 (38-47行目) | ○ |
| C-04 | HTMLからDOCへの直接変換は不可 | E-03 (107-109行目 コメント) | ○ |
| C-05 | HTML→ODT→DOCの2段階変換 | E-03 (110-113行目) | ○ |
| C-06 | 中間ODTファイルパス: destFile.replace(/\.doc$/, '.odt') | E-03 (111行目) | ○ |
| C-07 | 第1段階: queue.pushAsync({type: 'odt'}) | E-03 (112行目) | ○ |
| C-08 | 第2段階: queue.pushAsync({type}) where type='doc' | E-03 (113行目) | ○ |
| C-09 | if (type === 'doc') で特殊処理分岐 | E-03 (110行目) | ○ |
| C-10 | エラーメッセージ回避: no export filter for /tmp/xxxx.doc | E-03 (109行目 コメント) | ○ |
| C-11 | 変換タイムアウトは120秒 | E-03 (64行目) | ○ |
| C-12 | 変換キューは1つずつ処理 | E-03 (82行目) | ○ |
| C-13 | sofficeは--headlessモードで実行 | E-03 (40行目) | ○ |
| C-14 | res.sendFile()でDOC送信 | E-02 (114行目) | ○ |
| C-15 | srcFile（HTML）を削除 | E-02 (117行目) | ○ |
| C-16 | destFile（DOC）を削除 | E-02 (124行目) | ○ |
| C-17 | Windowsでは100ms遅延後に削除 | E-02 (120-122行目) | ○ |
| C-18 | settings.soffice設定項目あり | E-04 (241, 483行目) | ○ |
| C-19 | exportAvailable関数でツール可用性判定 | E-04 (685-695行目) | ○ |
| C-20 | LibreOffice優先で選択 | E-02 (106-109行目) | ○ |
| C-21 | レートリミッターが適用される | E-01 (16-25行目) | ○ |
| C-22 | readOnlyIdの場合はpadIdに変換される | E-01 (56-58行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全ての主張に対してソースコードによる根拠が確認された。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク。コードと設計書の整合性が高い。
- 1: 運用観点（中リスク）: 2段階変換によるパフォーマンス影響について確認推奨

## 6) レビュアーチェックリスト（最小）
- [ ] 2段階変換ロジック（HTML→ODT→DOC）がコードと一致しているか確認
- [ ] 中間ODTファイルパス生成ロジックがコードと一致しているか確認
- [ ] type='doc'の特殊処理分岐がコードと一致しているか確認
- [ ] コメントに記載されたLibreOfficeの制限事項が現行バージョンでも有効か確認
- [ ] 中間ファイル（ODT）の削除タイミングを確認（設計書では言及なし、要確認）
