---
generated_at: 2026-02-10 13:00:00
metrics:
  claims_total: 75
  claims_with_evidence: 72
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：機能一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：72 / 75、根拠なし：3
- 優先レビュー（高）
  1. **C-59: カーソル位置同期**：コード内で明示的な実装箇所が特定しにくい
  2. **C-60: ユーザー情報更新**：コード内で明示的な実装箇所が特定しにくい
  3. **C-74: 静的ファイル配信のMinify処理**：Minify.tsで確認できるがMinify対象範囲が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/handler/RestAPI.ts` - REST API エンドポイント定義
- E-02: `src/node/db/API.ts` - API関数実装
- E-03: `src/node/db/GroupManager.ts` - グループ管理機能実装
- E-04: `src/node/db/PadManager.ts` - パッド管理機能実装
- E-05: `src/node/db/AuthorManager.ts` - 著者管理機能実装
- E-06: `src/node/db/SessionManager.ts` - セッション管理機能実装
- E-07: `src/node/handler/ImportHandler.ts` - インポート機能実装
- E-08: `src/node/handler/ExportHandler.ts` - エクスポート機能実装
- E-09: `src/node/handler/PadMessageHandler.ts` - リアルタイム編集機能実装
- E-10: `src/node/security/OAuth2Provider.ts` - OAuth2認証機能実装
- E-11: `src/node/utils/Settings.ts` - 設定読み込み機能実装
- E-12: `src/node/hooks/express/adminplugins.ts` - プラグイン管理機能
- E-13: `src/node/hooks/express/adminsettings.ts` - 設定管理機能
- E-14: `src/node/db/Pad.ts` - パッドデータ永続化
- E-15: `src/ep.json` - フック定義・機能エントリポイント
- E-16: `README.md` - プロジェクト概要・機能説明
- E-17: `admin/src/App.tsx` - 管理画面UI
- E-18: `src/node/utils/Minify.ts` - 静的ファイルMinify処理
- E-19: `src/node/hooks/i18n.ts` - 国際化対応

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ作成 | E-01, E-02, E-03 | ○ |
| C-02 | グループ条件付き作成 | E-01, E-02, E-03 | ○ |
| C-03 | グループ一覧取得 | E-01, E-02, E-03 | ○ |
| C-04 | グループ削除 | E-01, E-02, E-03 | ○ |
| C-05 | グループ内パッド一覧取得 | E-01, E-02, E-03 | ○ |
| C-06 | パッド作成 | E-01, E-02, E-04 | ○ |
| C-07 | グループパッド作成 | E-01, E-02, E-03 | ○ |
| C-08 | パッド削除 | E-01, E-02, E-04 | ○ |
| C-09 | パッドコピー | E-01, E-02 | ○ |
| C-10 | 履歴なしパッドコピー | E-01, E-02 | ○ |
| C-11 | パッド移動 | E-01, E-02 | ○ |
| C-12 | 全パッド一覧取得 | E-01, E-02, E-04 | ○ |
| C-13 | 読み取り専用ID取得 | E-01, E-02 | ○ |
| C-14 | パッドID逆引き | E-01, E-02 | ○ |
| C-15 | テキスト取得 | E-01, E-02 | ○ |
| C-16 | テキスト設定 | E-01, E-02 | ○ |
| C-17 | テキスト追加 | E-01, E-02 | ○ |
| C-18 | HTML取得 | E-01, E-02 | ○ |
| C-19 | HTML設定 | E-01, E-02 | ○ |
| C-20 | 属性プール取得 | E-01, E-02 | ○ |
| C-21 | リビジョン変更セット取得 | E-01, E-02 | ○ |
| C-22 | リビジョン数取得 | E-01, E-02 | ○ |
| C-23 | 最終編集日時取得 | E-01, E-02 | ○ |
| C-24 | パッド著者一覧取得 | E-01, E-02 | ○ |
| C-25 | アクティブユーザー数取得 | E-01, E-02, E-09 | ○ |
| C-26 | アクティブユーザー一覧取得 | E-01, E-02, E-09 | ○ |
| C-27 | 公開ステータス取得 | E-01, E-02 | ○ |
| C-28 | 公開ステータス設定 | E-01, E-02 | ○ |
| C-29 | 保存済みリビジョン一覧取得 | E-01, E-02 | ○ |
| C-30 | リビジョン保存 | E-01, E-02 | ○ |
| C-31 | 保存済みリビジョン数取得 | E-01, E-02 | ○ |
| C-32 | リビジョン復元 | E-01, E-02 | ○ |
| C-33 | 差分HTML作成 | E-01, E-02 | ○ |
| C-34 | チャット履歴取得 | E-01, E-02 | ○ |
| C-35 | チャットヘッド取得 | E-01, E-02 | ○ |
| C-36 | チャットメッセージ追加 | E-01, E-02 | ○ |
| C-37 | クライアントメッセージ送信 | E-01, E-02, E-09 | ○ |
| C-38 | 著者作成 | E-01, E-02, E-05 | ○ |
| C-39 | 著者条件付き作成 | E-01, E-02, E-05 | ○ |
| C-40 | 著者名取得 | E-01, E-02, E-05 | ○ |
| C-41 | 著者のパッド一覧取得 | E-01, E-02, E-05 | ○ |
| C-42 | セッション作成 | E-01, E-02, E-06 | ○ |
| C-43 | セッション削除 | E-01, E-02, E-06 | ○ |
| C-44 | セッション情報取得 | E-01, E-02, E-06 | ○ |
| C-45 | グループセッション一覧取得 | E-01, E-02, E-06 | ○ |
| C-46 | 著者セッション一覧取得 | E-01, E-02, E-06 | ○ |
| C-47 | トークン検証 | E-01, E-02 | ○ |
| C-48 | OAuth2認証 | E-10, E-15 | ○ |
| C-49 | ログイン認証 | E-10 | ○ |
| C-50 | 同意処理 | E-10 | ○ |
| C-51 | ファイルインポート | E-07 | ○ |
| C-52 | テキストエクスポート | E-08 | ○ |
| C-53 | HTMLエクスポート | E-08 | ○ |
| C-54 | Etherpadエクスポート | E-08 | ○ |
| C-55 | ドキュメント変換エクスポート | E-08 | ○ |
| C-56 | パッド変更同期 | E-09 | ○ |
| C-57 | ユーザー参加処理 | E-09 | ○ |
| C-58 | 変更セット適用 | E-09 | ○ |
| C-59 | カーソル位置同期 | **根拠不足** | △ |
| C-60 | ユーザー情報更新 | **根拠不足** | △ |
| C-61 | プラグイン管理 | E-12, E-17 | ○ |
| C-62 | 設定管理 | E-13, E-17 | ○ |
| C-63 | パッド管理（管理画面） | E-17 | ○ |
| C-64 | 統計情報取得 | E-01, E-02 | ○ |
| C-65 | パッドデータ永続化 | E-14 | ○ |
| C-66 | 著者データ永続化 | E-05 | ○ |
| C-67 | セッションデータ永続化 | E-06 | ○ |
| C-68 | グループデータ永続化 | E-03 | ○ |
| C-69 | 設定ファイル読み込み | E-11 | ○ |
| C-70 | 認証情報読み込み | E-11 | ○ |
| C-71 | ログ設定 | E-11 | ○ |
| C-72 | パスサニタイズ | E-11 | ○ |
| C-73 | レート制限 | E-09 | ○ |
| C-74 | 静的ファイル配信 | E-18 | △ |
| C-75 | 国際化対応 | E-19, E-16 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-59 カーソル位置同期**：PadMessageHandler.ts内でSocket.IO経由の通信は確認できるが、カーソル位置の同期に関する具体的なメッセージハンドラが明示的に見つからない
  - 候補：`src/static/js/ace2_inner.js` / プラグイン実装 / フロントエンドコード
- **C-60 ユーザー情報更新**：ユーザー名・色の変更通知は存在するが、明示的なハンドラ特定が困難
  - 候補：`src/static/js/pad_userlist.js` / `USER_NEWINFO`メッセージ処理
- **C-74 静的ファイル配信**：Minify.tsでのMinify処理は確認できるが、対象ファイル範囲とタイミングの詳細確認が必要
  - 候補：設定ファイルでの詳細確認 / esbuild設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - API機能（C-01〜C-47）は明確なコード根拠あり
- 0: 低リスク - 認証機能（C-48〜C-50）はOAuth2Provider.tsで明確に実装
- 0: 低リスク - インポート・エクスポート（C-51〜C-55）は専用ハンドラで実装
- 1: 中リスク - リアルタイム編集（C-56〜C-60）の一部は根拠が分散
- 0: 低リスク - 管理機能（C-61〜C-64）は管理画面コードで確認可能
- 0: 低リスク - データベース機能（C-65〜C-68）は各Managerで明確に実装

## 6) レビュアーチェックリスト（最小）
- [ ] C-59, C-60のリアルタイム同期機能がフロントエンドコード（static/js/）で実装されているか確認
- [ ] C-74の静的ファイルMinify処理の対象範囲と有効化条件を確認
- [ ] REST APIのすべてのエンドポイント（C-01〜C-47）がRestAPI.tsのmappingと一致することを確認
- [ ] OAuth2認証フロー（C-48〜C-50）が本番環境で正しく動作することを確認
- [ ] インポート対応ファイル形式（C-51）がknownFileEndingsと一致することを確認
