# 機能設計書 1-グループ作成

## 概要

本ドキュメントは、Etherpad APIにおける「グループ作成」機能の設計仕様を記載する。

### 本機能の処理概要

新しいグループを作成し、一意のグループIDを発行する機能である。グループは複数のパッドをまとめて管理するための論理的なコンテナとして機能し、パッドのアクセス制御やセッション管理の基盤となる。

**業務上の目的・背景**：
Etherpadでは複数のユーザーがリアルタイムで共同編集を行うが、企業やプロジェクト単位でパッドを管理したいケースがある。グループ機能を利用することで、関連するパッドを一元管理し、セッションベースのアクセス制御を実現できる。これにより、組織単位での文書管理や、プライベートなパッドの作成が可能になる。

**機能の利用シーン**：
- 企業やチームが専用のパッド群を管理したい場合
- プライベートパッドを作成してアクセスを制限したい場合
- 複数のパッドを論理的にグルーピングして管理したい場合
- セッションベースの認証を実装したい場合

**主要な処理内容**：
1. 16文字のランダム文字列を生成し、`g.` プレフィックスを付与してグループIDを作成
2. グループの初期データ（空のパッドリストとマッピング）をデータベースに保存
3. グローバルなグループ一覧レコードにグループIDを追加
4. 生成されたグループIDをクライアントに返却

**関連システム・外部連携**：
- ueberDB2データベースによるデータ永続化
- セッション管理機能との連携（グループセッションの作成時に必要）

**権限による制御**：
APIキーまたはOAuth2トークンによる認証が必要。グループ作成自体には特別な権限は不要だが、API呼び出しには認証が必須である。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面からの直接操作はなく、API経由でのみ利用される |

## 機能種別

CRUD操作（Create）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| apikey | string | Yes（APIキー認証時） | API認証キー | 設定ファイルのAPIキーと一致すること |
| authorization | string | Yes（OAuth2認証時） | Bearerトークン | 有効なJWTトークンであること |

### 入力データソース

HTTP POSTリクエスト（`/api/2/groups`）のヘッダーまたはボディから認証情報を取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | number | 処理結果コード（0: 成功） |
| message | string | 処理結果メッセージ（"ok"） |
| data.groupID | string | 作成されたグループID（例: "g.s8oes9dhwrvt0zif"） |

### 出力先

HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. API認証
   └─ APIキーまたはOAuth2トークンを検証
2. グループID生成
   └─ randomString(16)で16文字のランダム文字列を生成
   └─ "g." プレフィックスを付与
3. グループデータ初期化
   └─ {pads: {}, mappings: {}} の初期構造を作成
4. データベース保存（個別レコード）
   └─ db.set(`group:${groupID}`, {pads: {}, mappings: {}})
5. データベース保存（一覧レコード）
   └─ db.setSub('groups', [groupID], 1)
6. レスポンス返却
   └─ {groupID: "g.xxxxxxxxxxxxxxxx"} を返却
```

### フローチャート

```mermaid
flowchart TD
    A[POST /api/2/groups] --> B{認証検証}
    B -->|失敗| C[401 Unauthorized]
    B -->|成功| D[randomString 16 で<br/>ランダム文字列生成]
    D --> E["groupID = g. + randomString"]
    E --> F["db.set group:groupID<br/>{pads:{}, mappings:{}}"]
    F --> G["db.setSub groups<br/>[groupID], 1"]
    G --> H["返却 {groupID}"]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | グループID形式 | グループIDは "g." + 16文字の英数字で構成される | 全グループ作成時 |
| BR-002 | グループ一意性 | randomStringにより事実上一意なIDが生成される | 全グループ作成時 |

### 計算ロジック

- グループIDの生成: `g.${randomString(16)}`
- randomString関数は0-9, A-Z, a-zの62文字から16文字をランダムに選択

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループレコード作成 | group:{groupID} | INSERT | グループの個別データを作成 |
| グループ一覧更新 | groups | UPDATE | グローバルなグループ一覧にIDを追加 |

### テーブル別操作詳細

#### group:{groupID}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | pads | {} | 空のオブジェクト（パッド未登録） |
| INSERT | mappings | {} | 空のオブジェクト（マッピング未設定） |

#### groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | [groupID] | 1 | グループ存在フラグ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 4 | 認証エラー | APIキーが無効または未指定 | 正しいAPIキーを指定 |
| 4 | 認証エラー | OAuth2トークンが無効 | 有効なトークンを取得して再試行 |
| 2 | 内部エラー | データベース操作失敗 | サーバーログを確認 |

### リトライ仕様

データベース操作失敗時のリトライはueberDB2層で処理される。API層でのリトライ機構はない。

## トランザクション仕様

グループレコードの作成とグループ一覧への追加は、以下の順序で実行される：
1. まず `group:{groupID}` レコードを作成
2. 次に `groups` レコードを更新

この順序により、グループ一覧に存在するグループは必ず個別レコードが存在することが保証される。ロールバック機構はなく、途中で失敗した場合は不整合が発生する可能性があるが、`doesGroupExist` 関数は個別レコードの存在をチェックするため、一覧のみに残った孤立エントリは実質的に無視される。

## パフォーマンス要件

- レスポンス時間: 通常100ms以下
- スループット: データベースバックエンドに依存

## セキュリティ考慮事項

- APIキーまたはOAuth2トークンによる認証が必須
- グループIDは推測困難な16文字のランダム文字列を使用
- グループ作成後のアクセス制御はセッション機能で実現

## 備考

- グループIDの形式: `g.{16文字の英数字}`
- 例: `g.s8oes9dhwrvt0zif`

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループデータの構造を理解することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GroupManager.ts | `src/node/db/GroupManager.ts` | グループデータの構造（pads, mappings）を確認 |

**読解のコツ**: グループは `{pads: {}, mappings: {}}` という構造で保存される。`pads` にはグループ内のパッドIDがキーとして格納され、`mappings` には外部システムとの連携用マッパー情報が格納される。

#### Step 2: エントリーポイントを理解する

APIリクエストの入口となるファイルを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | POST /api/2/groups のルーティング定義 |
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | API認証とパラメータマッピング |

**主要処理フロー**:
1. **323-327行目（RestAPI.ts）**: POST /groups のルーティング定義とcreateGroup関数へのマッピング
2. **161-218行目（APIHandler.ts）**: 認証検証とAPI関数呼び出し

#### Step 3: コアロジックを理解する

グループ作成の中核処理を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | createGroup関数のエクスポート |
| 3-2 | GroupManager.ts | `src/node/db/GroupManager.ts` | createGroup関数の実装 |

**主要処理フロー**:
- **45行目（API.ts）**: `exports.createGroup = groupManager.createGroup;`
- **96-104行目（GroupManager.ts）**: createGroup関数の実装
  - **97行目**: `randomString(16)` でグループID生成
  - **98行目**: グループ個別レコードを作成
  - **102行目**: グループ一覧に追加

#### Step 4: ユーティリティを理解する

ID生成に使用されるユーティリティを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | pad_utils.ts | `src/static/js/pad_utils.ts` | randomString関数の実装 |

**主要処理フロー**:
- **34-43行目**: 62種類の文字（0-9, A-Z, a-z）から指定長のランダム文字列を生成

### プログラム呼び出し階層図

```
POST /api/2/groups (RestAPI.ts)
    │
    ├─ APIHandler.handle() (APIHandler.ts:161)
    │      │
    │      ├─ 認証検証 (APIHandler.ts:175-200)
    │      │
    │      └─ api.createGroup() (API.ts:45)
    │              │
    │              └─ groupManager.createGroup() (GroupManager.ts:96)
    │                      │
    │                      ├─ randomString(16) (pad_utils.ts:34)
    │                      │
    │                      ├─ db.set() (DB.ts経由)
    │                      │
    │                      └─ db.setSub() (DB.ts経由)
    │
    └─ Response: {code: 0, message: "ok", data: {groupID}}
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP POST       ─────▶ RestAPI.ts
/api/2/groups          ルーティング
                           │
apikey/token   ─────▶ APIHandler.ts
                       認証検証
                           │
                       API.ts
                       関数委譲
                           │
                       GroupManager.ts
                       │ randomString(16)
                       │ db.set(group:xxx)
                       │ db.setSub(groups)
                           │
                           ▼
                       {groupID: "g.xxx"} ─────▶ JSON Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | APIルーティング定義 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | API認証・パラメータ処理 |
| API.ts | `src/node/db/API.ts` | ソース | API関数エクスポート |
| GroupManager.ts | `src/node/db/GroupManager.ts` | ソース | グループ管理コアロジック |
| pad_utils.ts | `src/static/js/pad_utils.ts` | ソース | ランダム文字列生成 |
| DB.ts | `src/node/db/DB.ts` | ソース | データベースアクセス層 |
