# 機能設計書 22-リビジョン数取得

## 概要

本ドキュメントは、Etherpadにおけるリビジョン数取得機能の設計を定義するものである。

### 本機能の処理概要

この機能は、指定されたパッドの総リビジョン数（ヘッドリビジョン番号）を取得する機能である。リビジョン数はパッドに対して行われた編集回数を表し、パッドの編集履歴の規模を把握するために使用される。

**業務上の目的・背景**：パッドの編集履歴を管理・分析する際に、総編集回数（リビジョン数）を把握することは重要である。タイムスライダー機能ではリビジョン数に基づいてスライダーの範囲を設定し、管理画面ではパッドの活動状況を示す指標として使用される。また、API連携において履歴の規模を事前に確認する用途にも使われる。

**機能の利用シーン**：
- タイムスライダー画面でのスライダー範囲の設定
- パッド編集画面でのパッド情報表示
- パッド管理画面でのリビジョン数表示
- 外部システムからのパッド活動状況の確認
- 履歴エクスポート前のデータ量見積もり

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID）
2. パッドの存在確認と取得
3. パッドオブジェクトからヘッドリビジョン番号を取得
4. リビジョン数をJSON形式で返却

**関連システム・外部連携**：
- ueberDB2データベース層を経由してパッドデータを取得
- REST API（`GET /api/2/pads/revisions`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | パッド編集画面 | API連携 | パッド情報の取得時にリビジョン数を取得 |
| 3 | タイムスライダー画面 | 主機能 | タイムスライダーの範囲設定のためリビジョン数を取得 |
| 10 | パッド管理画面 | 主機能 | パッド一覧にリビジョン数を表示 |

## 機能種別

データ取得（SELECT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | パッドの識別子 | 文字列型であること、有効なパッドIDであること |

### 入力データソース

- HTTPリクエストのクエリパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data.revisions | integer | パッドの総リビジョン数（0から開始） |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ GET /api/2/pads/revisions?padID=xxx

2. 入力パラメータのバリデーション
   └─ padIDの文字列型チェック

3. パッドの取得
   └─ getPadSafe()でパッドIDの妥当性確認とパッド取得

4. リビジョン数の取得
   └─ pad.getHeadRevisionNumber()でヘッドリビジョン番号を取得

5. レスポンスの返却
   └─ {revisions: number}形式でJSON返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[padIDバリデーション]
    C --> D{padIDは有効?}
    D -->|No| E[エラー: padID is not a string]
    D -->|Yes| F[パッド取得 getPadSafe]
    F --> G{パッド存在?}
    G -->|No| H[エラー: padID does not exist]
    G -->|Yes| I[getHeadRevisionNumber実行]
    I --> J[リビジョン数を返却]
    J --> K[終了]
    E --> K
    H --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-22-01 | リビジョン番号形式 | リビジョン番号は0から始まる整数 | 常に適用 |
| BR-22-02 | 新規パッドのリビジョン | 新規作成されたパッドのリビジョン数は0 | パッド作成直後 |
| BR-22-03 | パッド存在確認 | 存在しないパッドIDの場合はエラーを返却 | 常に適用 |

### 計算ロジック

リビジョン数はPadクラスの`head`プロパティから取得される。このプロパティは編集操作のたびにインクリメントされる。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padID} | SELECT | パッドオブジェクト（headプロパティ含む）を取得 |

### テーブル別操作詳細

#### pad:{padID}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | head | キー: pad:{padID} | Padオブジェクト内のheadプロパティ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| apierror | パラメータ型エラー | padIDが文字列でない | 文字列型のpadIDを指定する |
| apierror | パッド不存在 | 指定されたpadIDが存在しない | 正しいpadIDを指定する |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のためトランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常50ms以内
- パッドオブジェクトはメモリキャッシュされているため、高速にアクセス可能

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- パッドIDはサニタイズされる

## 備考

- リビジョン数は編集操作のたびに増加するが、減少することはない
- 同じテキストを再設定しても、変更がない場合はリビジョン数は増加しない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pad.ts | `src/node/db/Pad.ts` | Padクラスのheadプロパティ定義（45行目） |

**読解のコツ**: `head`プロパティはプライベートで、`getHeadRevisionNumber()`メソッドでアクセスする。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/revisions`エンドポイント定義（627-641行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | getRevisionsCount関数のパラメータ定義（54行目）|

**主要処理フロー**:
1. **627-641行目** (RestAPI.ts): エンドポイント定義とレスポンス形式
2. **54行目** (APIHandler.ts): `getRevisionsCount: ['padID']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | getRevisionsCount関数の実装（409-413行目）|

**主要処理フロー**:
- **409-413行目**: パッド取得とヘッドリビジョン番号の返却

#### Step 4: Padクラスのメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pad.ts | `src/node/db/Pad.ts` | getHeadRevisionNumber メソッド（73-75行目）|

**主要処理フロー**:
- **73-75行目**: `this.head`を返却するシンプルなゲッター

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: GET /api/2/pads/revisions
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.getRevisionsCount (API.ts:409-413)
    │                    │
    │                    ├─ getPadSafe (API.ts:894-920)
    │                    │      │
    │                    │      └─ padManager.getPad (PadManager.ts)
    │                    │
    │                    └─ Pad.getHeadRevisionNumber (Pad.ts:73-75)
    │                           │
    │                           └─ return this.head
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> getPadSafe ─────────────────> Pad Object
                              │
                              v
                    getHeadRevisionNumber
                              │
                              v
                    ───────────────────────────────> {revisions: number}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | getRevisionsCount関数の実装 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| Pad.ts | `src/node/db/Pad.ts` | ソース | Padクラスとリビジョン番号取得メソッド |
| PadManager.ts | `src/node/db/PadManager.ts` | ソース | パッド管理とキャッシュ |
| pad.ts | `src/tests/backend/specs/api/pad.ts` | テスト | APIテストケース（129-136行目、232-237行目） |
