# 機能設計書 23-最終編集日時取得

## 概要

本ドキュメントは、Etherpadにおける最終編集日時取得機能の設計を定義するものである。

### 本機能の処理概要

この機能は、指定されたパッドの最終編集日時（タイムスタンプ）を取得する機能である。最終編集日時は、パッドに対して最後にリビジョンが作成された時刻をエポックミリ秒で表現したものである。

**業務上の目的・背景**：パッドの活動状況を把握するために、最後に編集が行われた日時を確認することは重要である。管理画面ではパッドの最終更新日時を表示してアクティブなパッドを識別し、外部システムとの連携では同期の判断材料として使用される。また、長期間未編集のパッドの自動アーカイブや削除判定にも活用できる。

**機能の利用シーン**：
- パッド管理画面でのパッド一覧表示（最終編集日時でソート）
- 外部システムからのパッド活動状況の確認
- 長期間未使用パッドの検出と管理
- パッドの同期状態確認
- 監査ログとしての編集履歴追跡

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID）
2. パッドの存在確認と取得
3. 最新リビジョンのタイムスタンプをデータベースから取得
4. タイムスタンプをJSON形式で返却

**関連システム・外部連携**：
- ueberDB2データベース層を経由してリビジョンメタデータを取得
- REST API（`GET /api/2/pads/lastEdited`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 10 | パッド管理画面 | 主機能 | パッド一覧に最終編集日時を表示 |

## 機能種別

データ取得（SELECT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | パッドの識別子 | 文字列型であること、有効なパッドIDであること |

### 入力データソース

- HTTPリクエストのクエリパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data.lastEdited | number | 最終編集日時（エポックミリ秒） |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ GET /api/2/pads/lastEdited?padID=xxx

2. 入力パラメータのバリデーション
   └─ padIDの文字列型チェック

3. パッドの取得
   └─ getPadSafe()でパッドIDの妥当性確認とパッド取得

4. 最終編集日時の取得
   └─ pad.getLastEdit()で最新リビジョンのタイムスタンプを取得

5. レスポンスの返却
   └─ {lastEdited: number}形式でJSON返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[padIDバリデーション]
    C --> D{padIDは有効?}
    D -->|No| E[エラー: padID is not a string]
    D -->|Yes| F[パッド取得 getPadSafe]
    F --> G{パッド存在?}
    G -->|No| H[エラー: padID does not exist]
    G -->|Yes| I[getLastEdit実行]
    I --> J[タイムスタンプを返却]
    J --> K[終了]
    E --> K
    H --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-23-01 | タイムスタンプ形式 | タイムスタンプはエポックミリ秒（1970年1月1日からの経過ミリ秒） | 常に適用 |
| BR-23-02 | 最新リビジョン基準 | ヘッドリビジョンのタイムスタンプを返却 | 常に適用 |
| BR-23-03 | パッド存在確認 | 存在しないパッドIDの場合はエラーを返却 | 常に適用 |

### 計算ロジック

`getLastEdit()`メソッドは、ヘッドリビジョン番号を取得し、そのリビジョンの`meta.timestamp`を返却する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padID} | SELECT | パッドオブジェクト取得 |
| タイムスタンプ取得 | pad:{padID}:revs:{revNum} | SELECT | 最新リビジョンのメタ情報取得 |

### テーブル別操作詳細

#### pad:{padID}:revs:{revNum}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | meta.timestamp | キー: pad:{padID}:revs:{head}, サブキー: ['meta', 'timestamp'] | ueberDB2のgetSub使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| apierror | パラメータ型エラー | padIDが文字列でない | 文字列型のpadIDを指定する |
| apierror | パッド不存在 | 指定されたpadIDが存在しない | 正しいpadIDを指定する |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のためトランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常50ms以内
- 単一キーのサブフィールド読み取りで完了

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- パッドIDはサニタイズされる

## 備考

- タイムスタンプはJavaScriptのDate.now()で生成されたエポックミリ秒
- クライアント側でのフォーマット変換が必要

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pad.ts | `src/node/db/Pad.ts` | リビジョンデータ構造（113-123行目のappendRevision） |

**読解のコツ**: リビジョンは`{changeset, meta: {author, timestamp, ...}}`形式で保存される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/lastEdited`エンドポイント定義（643-657行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | getLastEdited関数のパラメータ定義（55行目）|

**主要処理フロー**:
1. **643-657行目** (RestAPI.ts): エンドポイント定義とレスポンス形式
2. **55行目** (APIHandler.ts): `getLastEdited: ['padID']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | getLastEdited関数の実装（488-493行目）|

**主要処理フロー**:
- **488-493行目**: パッド取得と最終編集日時の返却

#### Step 4: Padクラスのメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pad.ts | `src/node/db/Pad.ts` | getLastEdit メソッド（162-166行目）|

**主要処理フロー**:
- **162-166行目**: ヘッドリビジョンのタイムスタンプをDBから取得

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: GET /api/2/pads/lastEdited
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.getLastEdited (API.ts:488-493)
    │                    │
    │                    ├─ getPadSafe (API.ts:894-920)
    │                    │      │
    │                    │      └─ padManager.getPad (PadManager.ts)
    │                    │
    │                    └─ Pad.getLastEdit (Pad.ts:162-166)
    │                           │
    │                           ├─ getHeadRevisionNumber (Pad.ts:73-75)
    │                           │
    │                           └─ db.getSub('pad:{id}:revs:{revNum}', ['meta', 'timestamp'])
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> getPadSafe ─────────────────> Pad Object
                              │
                              v
                    getLastEdit
                              │
                              ├─ getHeadRevisionNumber → revNum
                              │
                              └─ db.getSub → timestamp
                              │
                              v
                    ───────────────────────────────> {lastEdited: number}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | getLastEdited関数の実装 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| Pad.ts | `src/node/db/Pad.ts` | ソース | Padクラスと最終編集日時取得メソッド |
| PadManager.ts | `src/node/db/PadManager.ts` | ソース | パッド管理とキャッシュ |
| pad.ts | `src/tests/backend/specs/api/pad.ts` | テスト | APIテストケース（290-297行目、311-317行目） |
