# 機能設計書 24-パッド著者一覧取得

## 概要

本ドキュメントは、Etherpadにおけるパッド著者一覧取得機能の設計を定義するものである。

### 本機能の処理概要

この機能は、指定されたパッドに貢献（編集）したすべての著者のIDを一覧で取得する機能である。著者IDはパッドの属性プールに格納されている`author`属性から抽出される。

**業務上の目的・背景**：パッドの編集者を特定することは、コラボレーション管理において重要である。誰がパッドに貢献したかを確認することで、コンテンツの責任者を特定したり、編集履歴の監査を行ったりできる。また、タイムスライダー画面では著者ごとに異なる色で編集内容を表示するため、著者一覧の取得が必要となる。

**機能の利用シーン**：
- タイムスライダー画面でのリビジョンに貢献した著者一覧の表示
- パッドの編集者リストの取得
- 監査・コンプライアンス用途での編集者追跡
- コラボレーション分析（誰が最も貢献したか等）
- 著者への通知送信時の宛先リスト取得

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID）
2. パッドの存在確認と取得
3. パッドの属性プールから著者ID一覧を抽出
4. 著者ID配列をJSON形式で返却

**関連システム・外部連携**：
- ueberDB2データベース層を経由してパッドデータを取得
- REST API（`GET /api/2/pads/authors`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 3 | タイムスライダー画面 | 主機能 | リビジョンに貢献した著者一覧を表示 |

## 機能種別

データ取得（SELECT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | パッドの識別子 | 文字列型であること、有効なパッドIDであること |

### 入力データソース

- HTTPリクエストのクエリパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data.authorIDs | string[] | パッドに貢献した著者ID一覧 |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ GET /api/2/pads/authors?padID=xxx

2. 入力パラメータのバリデーション
   └─ padIDの文字列型チェック

3. パッドの取得
   └─ getPadSafe()でパッドIDの妥当性確認とパッド取得

4. 著者一覧の取得
   └─ pad.getAllAuthors()で属性プールから著者IDを抽出

5. レスポンスの返却
   └─ {authorIDs: string[]}形式でJSON返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[padIDバリデーション]
    C --> D{padIDは有効?}
    D -->|No| E[エラー: padID is not a string]
    D -->|Yes| F[パッド取得 getPadSafe]
    F --> G{パッド存在?}
    G -->|No| H[エラー: padID does not exist]
    G -->|Yes| I[getAllAuthors実行]
    I --> J[著者ID一覧を返却]
    J --> K[終了]
    E --> K
    H --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-24-01 | 著者ID形式 | 著者IDは`a.`プレフィックス付きの文字列 | 常に適用 |
| BR-24-02 | 空著者の除外 | 空文字の著者IDは結果に含まれない | getAllAuthors内で除外 |
| BR-24-03 | パッド存在確認 | 存在しないパッドIDの場合はエラーを返却 | 常に適用 |
| BR-24-04 | 重複なし | 同一著者は1回のみ結果に含まれる | 属性プールの構造による |

### 計算ロジック

`getAllAuthors()`メソッドは、パッドの属性プール（`pool.numToAttrib`）を走査し、キーが`author`で値が空でない属性を収集する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padID} | SELECT | パッドオブジェクト（poolプロパティ含む）を取得 |

### テーブル別操作詳細

#### pad:{padID}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | pool | キー: pad:{padID} | AttributePoolオブジェクト |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| apierror | パラメータ型エラー | padIDが文字列でない | 文字列型のpadIDを指定する |
| apierror | パッド不存在 | 指定されたpadIDが存在しない | 正しいpadIDを指定する |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のためトランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常50ms以内
- 属性プールはメモリ上に保持されているため高速にアクセス可能

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- パッドIDはサニタイズされる
- 著者IDのみを返却し、著者の個人情報は含まない

## 備考

- 著者IDは編集操作時に属性プールに追加される
- 新規パッドの場合は空の配列が返却される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | AttributePool.ts | `src/static/js/AttributePool.ts` | 属性プールの構造（numToAttrib） |
| 1-2 | Pad.ts | `src/node/db/Pad.ts` | poolプロパティの定義（44行目） |

**読解のコツ**: 属性プールは`{numToAttrib: {0: ['author', 'a.xxx'], ...}}`形式で著者情報を保持。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/authors`エンドポイント定義（737-751行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | listAuthorsOfPad関数のパラメータ定義（60行目）|

**主要処理フロー**:
1. **737-751行目** (RestAPI.ts): エンドポイント定義とレスポンス形式
2. **60行目** (APIHandler.ts): `listAuthorsOfPad: ['padID']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | listAuthorsOfPad関数の実装（746-751行目）|

**主要処理フロー**:
- **746-751行目**: パッド取得と著者ID一覧の返却

#### Step 4: Padクラスのメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pad.ts | `src/node/db/Pad.ts` | getAllAuthors メソッド（196-206行目）|

**主要処理フロー**:
- **196-206行目**: 属性プールを走査して著者IDを収集

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: GET /api/2/pads/authors
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.listAuthorsOfPad (API.ts:746-751)
    │                    │
    │                    ├─ getPadSafe (API.ts:894-920)
    │                    │      │
    │                    │      └─ padManager.getPad (PadManager.ts)
    │                    │
    │                    └─ Pad.getAllAuthors (Pad.ts:196-206)
    │                           │
    │                           └─ pool.numToAttribを走査
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> getPadSafe ─────────────────> Pad Object
                              │
                              v
                    getAllAuthors
                              │
                              ├─ pool.numToAttrib を走査
                              │
                              └─ 'author' 属性を抽出
                              │
                              v
                    ───────────────────────────────> {authorIDs: string[]}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | listAuthorsOfPad関数の実装 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| Pad.ts | `src/node/db/Pad.ts` | ソース | Padクラスと著者一覧取得メソッド |
| AttributePool.ts | `src/static/js/AttributePool.ts` | ソース | 属性プールの実装 |
| PadManager.ts | `src/node/db/PadManager.ts` | ソース | パッド管理とキャッシュ |
| pad.ts | `src/tests/backend/specs/api/pad.ts` | テスト | APIテストケース（282-288行目） |
