# 機能設計書 26-アクティブユーザー一覧取得

## 概要

本ドキュメントは、Etherpadにおけるアクティブユーザー一覧取得機能の設計を定義するものである。

### 本機能の処理概要

この機能は、指定されたパッドを現在編集中（接続中）のユーザー情報一覧を取得する機能である。各ユーザーの著者ID、名前、色IDなどの情報をリアルタイムで取得して返却する。

**業務上の目的・背景**：リアルタイムコラボレーションにおいて、現在パッドを編集している具体的なユーザー情報を把握することは重要である。パッド編集画面ではユーザーパネルにアクティブユーザー一覧を表示し、各ユーザーの名前と色を確認できる。また、外部システムとの連携やコラボレーション分析にも活用できる。

**機能の利用シーン**：
- パッド編集画面でのユーザーパネル表示
- 接続中ユーザーへの通知送信前のユーザー確認
- コラボレーション分析（誰が参加しているか）
- 会議やワークショップでの参加者リスト表示
- 管理者による編集者監視

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID）
2. Socket.IOルームに接続しているソケットを取得
3. 各ソケットに対応する著者情報をAuthorManagerから取得
4. ユーザー情報一覧をJSON形式で返却

**関連システム・外部連携**：
- Socket.IOサーバーのルーム情報を参照
- AuthorManagerを通じて著者情報を取得
- REST API（`GET /api/2/pads/users`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | パッド編集画面 | API連携 | ユーザーパネルにアクティブユーザー一覧を表示 |

## 機能種別

データ取得（リアルタイム情報）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | パッドの識別子 | 文字列型であること |

### 入力データソース

- HTTPリクエストのクエリパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data.padUsers | object[] | ユーザー情報の配列 |
| data.padUsers[].id | string | 著者ID |
| data.padUsers[].colorId | string | 色ID（16進カラーコードまたはパレット番号） |
| data.padUsers[].name | string | ユーザー名 |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ GET /api/2/pads/users?padID=xxx

2. パラメータの取得
   └─ padIDを取得

3. ルームソケットの取得
   └─ _getRoomSockets(padID)でソケット配列を取得

4. 各ソケットの著者情報取得
   └─ 並列でauthorManager.getAuthor(authorId)を実行

5. ユーザー情報の整形
   └─ id, colorId, nameを含むオブジェクト配列を作成

6. レスポンスの返却
   └─ {padUsers: object[]}形式でJSON返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[padID取得]
    C --> D[_getRoomSockets実行]
    D --> E{ソケットあり?}
    E -->|No| F[空配列を返却]
    E -->|Yes| G[各ソケットの著者ID取得]
    G --> H[authorManager.getAuthor並列実行]
    H --> I[ユーザー情報配列作成]
    I --> J[ユーザー一覧を返却]
    F --> K[終了]
    J --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-26-01 | リアルタイム計測 | 結果はAPI呼び出し時点の接続ユーザー | 常に適用 |
| BR-26-02 | 空配列返却 | 誰も接続していない場合は空配列を返却 | 常に適用 |
| BR-26-03 | 著者情報不在時除外 | 著者情報がDBに存在しない場合は結果に含めない | 常に適用 |
| BR-26-04 | 並列取得 | 複数ユーザーの情報は並列で取得 | 常に適用 |

### 計算ロジック

`padUsers`関数は、以下の処理を行う：
1. `_getRoomSockets(padID)`でソケット配列を取得
2. 各ソケットのセッション情報から著者IDを取得
3. `authorManager.getAuthor(authorId)`で著者情報を取得
4. 有効な著者情報にIDを付加して配列にまとめる

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| 著者情報取得 | globalAuthor:{authorId} | SELECT | 各接続ユーザーの著者情報を取得 |

### テーブル別操作詳細

#### globalAuthor:{authorId}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | name, colorId | キー: globalAuthor:{authorId} | authorManager.getAuthor使用 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | - | 本機能は通常エラーを発生させない | - |

### リトライ仕様

特になし

## トランザクション仕様

読み取り専用操作のためトランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常50ms以内（接続ユーザー数に依存）
- 著者情報取得は並列で実行される

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- ユーザー名は公開情報として扱われる

## 備考

- パッドが存在しない場合でも空配列が返却される
- 著者情報がデータベースから取得できない場合はスキップされる

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | PadType.ts | `src/node/types/PadType.ts` | PadAuthor型の構造 |
| 1-2 | PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | sessioninfos構造（94-95行目） |

**読解のコツ**: `sessioninfos`はソケットIDをキーとし、`author`プロパティに著者IDを保持。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/users`エンドポイント定義（785-821行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | padUsers関数のパラメータ定義（67行目）|

**主要処理フロー**:
1. **785-821行目** (RestAPI.ts): エンドポイント定義とレスポンス形式
2. **67行目** (APIHandler.ts): `padUsers: ['padID']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | padUsers関数のエクスポート（65行目）|

**主要処理フロー**:
- **65行目**: `exports.padUsers = padMessageHandler.padUsers;`（委譲）

#### Step 4: 実装詳細を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | padUsers関数（1334-1352行目）|
| 4-2 | AuthorManager.ts | `src/node/db/AuthorManager.ts` | getAuthor関数 |

**主要処理フロー**:
- **1334-1352行目**: ソケット走査と著者情報取得
- **1338-1349行目**: 並列で著者情報を取得し配列に追加

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: GET /api/2/pads/users
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.padUsers (API.ts:65)
    │                    │
    │                    └─ padMessageHandler.padUsers (PadMessageHandler.ts:1334-1352)
    │                           │
    │                           ├─ _getRoomSockets (PadMessageHandler.ts:1310-1322)
    │                           │
    │                           └─ Promise.all → authorManager.getAuthor (並列実行)
    │                                  │
    │                                  └─ db.get('globalAuthor:{authorId}')
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> _getRoomSockets ────────────> Socket Array
                              │
                              v
                    sessioninfos[socket.id].author
                              │
                              v
                    authorManager.getAuthor (並列)
                              │
                              v
                    ───────────────────────────────> {padUsers: [{id, name, colorId}...]}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | padUsers関数のエクスポート |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | ソース | padUsers実装と_getRoomSockets |
| AuthorManager.ts | `src/node/db/AuthorManager.ts` | ソース | 著者情報の取得 |
| PadType.ts | `src/node/types/PadType.ts` | 型定義 | PadAuthor型 |
| pad.ts | `src/tests/backend/specs/api/pad.ts` | テスト | APIテストケース（319-325行目） |
