# 機能設計書 27-公開ステータス取得

## 概要

本ドキュメントは、Etherpadにおける公開ステータス取得機能の設計を定義するものである。

### 本機能の処理概要

この機能は、グループパッドの公開ステータス（公開/非公開）を取得する機能である。グループパッドは通常セッション認証が必要だが、公開ステータスがtrueの場合は認証なしでアクセスできる。

**業務上の目的・背景**：グループパッドのアクセス制御において、公開/非公開の設定状態を確認することは重要である。管理者は公開ステータスを確認して適切なアクセス制御を行い、外部システムとの連携では公開パッドのみを対象とした処理が必要になることがある。

**機能の利用シーン**：
- 管理画面でのグループパッドの公開設定確認
- アクセス制御ロジックでの公開状態チェック
- 公開パッドの一覧作成
- セキュリティ監査での公開設定確認
- 外部共有リンク生成前の状態確認

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID）
2. グループパッドであることの確認（`$`を含むpadID）
3. パッドの存在確認と取得
4. パッドの公開ステータスを取得して返却

**関連システム・外部連携**：
- ueberDB2データベース層を経由してパッドデータを取得
- REST API（`GET /api/2/pads/publicStatus`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。グループパッドのみが対象。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面からの直接利用なし（API経由のみ） |

## 機能種別

データ取得（SELECT）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | グループパッドの識別子 | 文字列型であること、`$`を含むこと（グループパッド） |

### 入力データソース

- HTTPリクエストのクエリパラメータ（GETリクエスト）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data.publicStatus | boolean | 公開ステータス（true: 公開、false: 非公開） |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ GET /api/2/pads/publicStatus?padID=g.xxx$yyy

2. グループパッドチェック
   └─ checkGroupPad()でpadIDに$が含まれることを確認

3. パッドの取得
   └─ getPadSafe()でパッドIDの妥当性確認とパッド取得

4. 公開ステータスの取得
   └─ pad.getPublicStatus()で現在の公開ステータスを取得

5. レスポンスの返却
   └─ {publicStatus: boolean}形式でJSON返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[checkGroupPad実行]
    C --> D{グループパッド?}
    D -->|No| E[エラー: グループパッドのみ対応]
    D -->|Yes| F[パッド取得 getPadSafe]
    F --> G{パッド存在?}
    G -->|No| H[エラー: padID does not exist]
    G -->|Yes| I[getPublicStatus実行]
    I --> J[公開ステータスを返却]
    J --> K[終了]
    E --> K
    H --> K
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-27-01 | グループパッド限定 | この機能はグループパッドのみ対象 | 常に適用 |
| BR-27-02 | デフォルト値 | 新規パッドのデフォルト公開ステータスはfalse | パッド作成時 |
| BR-27-03 | グループパッド識別 | padIDに`$`が含まれる場合はグループパッド | 常に適用 |

### 計算ロジック

`getPublicStatus()`メソッドは、Padクラスの`publicStatus`プロパティを直接返却する。このプロパティはPadオブジェクトの初期化時にデータベースから読み込まれる。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padID} | SELECT | パッドオブジェクト（publicStatusプロパティ含む）を取得 |

### テーブル別操作詳細

#### pad:{padID}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | publicStatus | キー: pad:{padID} | Padオブジェクト内のpublicStatusプロパティ |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| apierror | 非グループパッド | padIDに`$`が含まれない | グループパッドのpadIDを指定する |
| apierror | パッド不存在 | 指定されたpadIDが存在しない | 正しいpadIDを指定する |

### リトライ仕様

特になし（読み取り専用操作のため）

## トランザクション仕様

読み取り専用操作のためトランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常50ms以内
- パッドオブジェクトはメモリキャッシュされている

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- パッドIDはサニタイズされる
- グループパッドのみを対象とすることでセキュリティ境界を明確化

## 備考

- 通常のパッド（非グループパッド）にはこの機能は使用できない
- 公開ステータスはSecurityManagerでアクセス制御に使用される

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pad.ts | `src/node/db/Pad.ts` | publicStatusプロパティ（47行目、64行目） |

**読解のコツ**: `publicStatus`はbooleanプロパティで、デフォルトはfalse。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/publicStatus` GETエンドポイント定義（722-736行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | getPublicStatus関数のパラメータ定義（59行目）|

**主要処理フロー**:
1. **722-736行目** (RestAPI.ts): GETエンドポイント定義
2. **59行目** (APIHandler.ts): `getPublicStatus: ['padID']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | getPublicStatus関数の実装（728-735行目）|

**主要処理フロー**:
- **729-730行目**: checkGroupPadでグループパッドチェック
- **733行目**: getPadSafeでパッド取得
- **734行目**: pad.getPublicStatus()で公開ステータス返却

#### Step 4: Padクラスのメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pad.ts | `src/node/db/Pad.ts` | getPublicStatus メソッド（87-89行目）|

**主要処理フロー**:
- **87-89行目**: `this.publicStatus`を返却するシンプルなゲッター

#### Step 5: グループパッドチェックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | API.ts | `src/node/db/API.ts` | checkGroupPad関数（923-929行目）|

**主要処理フロー**:
- **925-928行目**: padIDに`$`が含まれない場合はエラー

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: GET /api/2/pads/publicStatus
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.getPublicStatus (API.ts:728-735)
    │                    │
    │                    ├─ checkGroupPad (API.ts:923-929)
    │                    │
    │                    ├─ getPadSafe (API.ts:894-920)
    │                    │      │
    │                    │      └─ padManager.getPad (PadManager.ts)
    │                    │
    │                    └─ Pad.getPublicStatus (Pad.ts:87-89)
    │                           │
    │                           └─ return this.publicStatus
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> checkGroupPad ──────────────> グループパッドか確認
                              │
                              v
                    getPadSafe ─────────────────────> Pad Object
                              │
                              v
                    getPublicStatus
                              │
                              v
                    ───────────────────────────────> {publicStatus: boolean}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | getPublicStatus関数の実装 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| Pad.ts | `src/node/db/Pad.ts` | ソース | Padクラスと公開ステータス取得メソッド |
| SecurityManager.ts | `src/node/db/SecurityManager.ts` | ソース | アクセス制御での公開ステータス使用 |
| sessionsAndGroups.ts | `src/tests/backend/specs/api/sessionsAndGroups.ts` | テスト | APIテストケース |
