# 機能設計書 28-公開ステータス設定

## 概要

本ドキュメントは、Etherpadにおける公開ステータス設定機能の設計を定義するものである。

### 本機能の処理概要

この機能は、グループパッドの公開ステータス（公開/非公開）を設定する機能である。公開ステータスをtrueに設定すると、グループパッドはセッション認証なしでアクセス可能になる。

**業務上の目的・背景**：グループパッドのアクセス制御を柔軟に管理するために、公開/非公開の設定が必要である。デフォルトでは非公開だが、外部に公開したいパッドは公開ステータスをtrueに設定することで、URLを知っていれば誰でもアクセスできるようになる。

**機能の利用シーン**：
- グループパッドを外部公開する際の設定変更
- 会議終了後のパッドの一般公開
- 期間限定公開パッドの設定
- セキュリティ要件変更に伴う非公開化
- 管理画面からのアクセス設定変更

**主要な処理内容**：
1. リクエストパラメータのバリデーション（padID、publicStatus）
2. グループパッドであることの確認（`$`を含むpadID）
3. パッドの存在確認と取得
4. 公開ステータスの設定とデータベースへの保存

**関連システム・外部連携**：
- ueberDB2データベース層を経由してパッドデータを更新
- REST API（`POST /api/2/pads/publicStatus`）として外部システムから呼び出し可能

**権限による制御**：API認証（APIキーまたはOAuth2トークン）が必要。グループパッドのみが対象。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面からの直接利用なし（API経由のみ） |

## 機能種別

データ更新（UPDATE）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| padID | string | Yes | グループパッドの識別子 | 文字列型であること、`$`を含むこと（グループパッド） |
| publicStatus | boolean/string | Yes | 公開ステータス | boolean、または"true"/"false"文字列 |

### 入力データソース

- HTTPリクエストボディ（POSTリクエスト、JSON形式）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | integer | レスポンスコード（0: 成功） |
| message | string | レスポンスメッセージ（"ok"） |
| data | null | データなし |

### 出力先

- HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. APIリクエストの受信
   └─ POST /api/2/pads/publicStatus

2. グループパッドチェック
   └─ checkGroupPad()でpadIDに$が含まれることを確認

3. パッドの取得
   └─ getPadSafe()でパッドIDの妥当性確認とパッド取得

4. publicStatusの型変換
   └─ 文字列の場合はbooleanに変換

5. 公開ステータスの設定
   └─ pad.setPublicStatus(publicStatus)で設定

6. データベースへの保存
   └─ pad.saveToDatabase()で永続化

7. レスポンスの返却
   └─ 成功レスポンスを返却
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[リクエスト受信]
    B --> C[checkGroupPad実行]
    C --> D{グループパッド?}
    D -->|No| E[エラー: グループパッドのみ対応]
    D -->|Yes| F[パッド取得 getPadSafe]
    F --> G{パッド存在?}
    G -->|No| H[エラー: padID does not exist]
    G -->|Yes| I{publicStatusは文字列?}
    I -->|Yes| J[booleanに変換]
    I -->|No| K[そのまま使用]
    J --> L[setPublicStatus実行]
    K --> L
    L --> M[saveToDatabase実行]
    M --> N[成功レスポンス返却]
    N --> O[終了]
    E --> O
    H --> O
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-28-01 | グループパッド限定 | この機能はグループパッドのみ対象 | 常に適用 |
| BR-28-02 | 文字列変換 | "true"/"false"文字列はbooleanに変換 | publicStatusが文字列の場合 |
| BR-28-03 | 即時反映 | 設定変更は即座にアクセス制御に反映 | 常に適用 |

### 計算ロジック

`setPublicStatus()`メソッドは、引数の値を`this.publicStatus`に設定し、`saveToDatabase()`を呼び出してデータベースに永続化する。

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| パッド取得 | pad:{padID} | SELECT | パッドオブジェクトを取得 |
| パッド更新 | pad:{padID} | UPDATE | publicStatusを更新 |

### テーブル別操作詳細

#### pad:{padID}

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | publicStatus | true または false | Padオブジェクト全体を保存 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| apierror | 非グループパッド | padIDに`$`が含まれない | グループパッドのpadIDを指定する |
| apierror | パッド不存在 | 指定されたpadIDが存在しない | 正しいpadIDを指定する |

### リトライ仕様

特になし

## トランザクション仕様

単一パッドの更新のため、トランザクション管理は不要。ueberDB2が自動的にキャッシュとデータベースの一貫性を保証。

## パフォーマンス要件

- レスポンス時間: 通常100ms以内
- データベース書き込みを伴うため、読み取り専用操作より若干遅い

## セキュリティ考慮事項

- API認証（APIキーまたはOAuth2トークン）が必須
- パッドIDはサニタイズされる
- 公開設定はセキュリティに直接影響するため、慎重に操作する必要がある
- 公開設定変更の監査ログを記録することを推奨

## 備考

- 公開設定は即座にSecurityManagerのアクセス制御に反映される
- 通常のパッド（非グループパッド）にはこの機能は使用できない

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Pad.ts | `src/node/db/Pad.ts` | publicStatusプロパティ（47行目、64行目） |

**読解のコツ**: `publicStatus`はbooleanプロパティで、デフォルトはfalse。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | `/pads/publicStatus` POSTエンドポイント定義（697-721行目）|
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | setPublicStatus関数のパラメータ定義（58行目）|

**主要処理フロー**:
1. **697-721行目** (RestAPI.ts): POSTエンドポイント定義
2. **58行目** (APIHandler.ts): `setPublicStatus: ['padID', 'publicStatus']`

#### Step 3: API関数の実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | setPublicStatus関数の実装（704-717行目）|

**主要処理フロー**:
- **705-706行目**: checkGroupPadでグループパッドチェック
- **709行目**: getPadSafeでパッド取得
- **712-714行目**: 文字列の場合はbooleanに変換
- **716行目**: pad.setPublicStatus()で設定

#### Step 4: Padクラスのメソッドを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Pad.ts | `src/node/db/Pad.ts` | setPublicStatus メソッド（618-621行目）|

**主要処理フロー**:
- **618-621行目**: publicStatusを設定し、saveToDatabase()を呼び出し

### プログラム呼び出し階層図

```
RestAPI.expressCreateServer (RestAPI.ts)
    │
    ├─ Express Router: POST /api/2/pads/publicStatus
    │      │
    │      └─ APIHandler.handle (APIHandler.ts)
    │             │
    │             └─ API.setPublicStatus (API.ts:704-717)
    │                    │
    │                    ├─ checkGroupPad (API.ts:923-929)
    │                    │
    │                    ├─ getPadSafe (API.ts:894-920)
    │                    │      │
    │                    │      └─ padManager.getPad (PadManager.ts)
    │                    │
    │                    └─ Pad.setPublicStatus (Pad.ts:618-621)
    │                           │
    │                           ├─ this.publicStatus = publicStatus
    │                           │
    │                           └─ this.saveToDatabase()
    │                                  │
    │                                  └─ db.set('pad:{id}', this)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

padID ─────────────────> checkGroupPad ──────────────> グループパッドか確認
                              │
publicStatus ─────────────────┤
                              │
                              v
                    getPadSafe ─────────────────────> Pad Object
                              │
                              v
                    文字列ならboolean変換
                              │
                              v
                    setPublicStatus
                              │
                              v
                    saveToDatabase ─────────────────> DB更新
                              │
                              v
                    ───────────────────────────────> {code: 0, message: "ok"}
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| API.ts | `src/node/db/API.ts` | ソース | setPublicStatus関数の実装 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | APIバージョン管理とパラメータ定義 |
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | RESTエンドポイント定義 |
| Pad.ts | `src/node/db/Pad.ts` | ソース | Padクラスと公開ステータス設定メソッド |
| SecurityManager.ts | `src/node/db/SecurityManager.ts` | ソース | アクセス制御での公開ステータス使用 |
| sessionsAndGroups.ts | `src/tests/backend/specs/api/sessionsAndGroups.ts` | テスト | APIテストケース |
