# 機能設計書 3-グループ一覧取得

## 概要

本ドキュメントは、Etherpad APIにおける「グループ一覧取得」機能の設計仕様を記載する。

### 本機能の処理概要

システムに存在するすべてのグループIDを一覧で取得する機能である。グループの管理・監視や、バッチ処理の対象特定などに利用される。

**業務上の目的・背景**：
Etherpadを運用する管理者やシステム連携において、どのグループが存在するかを把握する必要がある。本機能により、システム全体のグループ状況を確認でき、管理ダッシュボードの構築やデータ移行時のグループ特定が可能になる。

**機能の利用シーン**：
- 管理者がシステム内の全グループを確認する場合
- グループの統計情報を収集する場合
- データ移行やバックアップ時に対象グループを特定する場合
- 監査やコンプライアンス対応でグループ一覧が必要な場合

**主要な処理内容**：
1. グローバルなグループ一覧レコード（`groups`）を取得
2. レコードが存在しない場合は空オブジェクトとして処理
3. オブジェクトのキーをグループIDの配列として抽出
4. グループID配列をクライアントに返却

**関連システム・外部連携**：
- ueberDB2データベースからのデータ取得

**権限による制御**：
APIキーまたはOAuth2トークンによる認証が必要。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | - | - | 画面からの直接操作はなく、API経由でのみ利用される |

## 機能種別

CRUD操作（Read）

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| apikey | string | Yes（APIキー認証時） | API認証キー | 設定ファイルのAPIキーと一致すること |
| authorization | string | Yes（OAuth2認証時） | Bearerトークン | 有効なJWTトークンであること |

### 入力データソース

HTTP GETリクエスト（`/api/2/groups`）のヘッダーまたはクエリパラメータから認証情報を取得。

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| code | number | 処理結果コード（0: 成功） |
| message | string | 処理結果メッセージ（"ok"） |
| data.groupIDs | string[] | グループIDの配列 |

### 出力先

HTTPレスポンス（JSON形式）

## 処理フロー

### 処理シーケンス

```
1. API認証
   └─ APIキーまたはOAuth2トークンを検証
2. グループ一覧取得
   └─ db.get('groups') を実行
3. 結果の正規化
   └─ 取得結果がnullの場合は空オブジェクトに変換
4. キー抽出
   └─ Object.keys(groups) でグループID配列を生成
5. レスポンス返却
   └─ {groupIDs: [...]} を返却
```

### フローチャート

```mermaid
flowchart TD
    A[GET /api/2/groups] --> B{認証検証}
    B -->|失敗| C[401 Unauthorized]
    B -->|成功| D["db.get('groups')"]
    D --> E{結果がnull?}
    E -->|Yes| F["groups = {}"]
    E -->|No| G[取得結果を使用]
    F --> H["groupIDs = Object.keys(groups)"]
    G --> H
    H --> I["返却 {groupIDs}"]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-001 | 空配列返却 | グループが存在しない場合は空配列を返す | groupsレコードがnullまたは空 |
| BR-002 | 順序不定 | 返却されるグループIDの順序は保証されない | 常に |

### 計算ロジック

- グループID抽出: `Object.keys(groups || {})`

## データベース操作仕様

### 操作別データベース影響一覧

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| グループ一覧取得 | groups | SELECT | グローバルなグループ一覧を取得 |

### テーブル別操作詳細

#### groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全体 | {groupID: 1, ...}形式 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 4 | 認証エラー | APIキーが無効または未指定 | 正しいAPIキーを指定 |
| 2 | 内部エラー | データベース操作失敗 | サーバーログを確認 |

### リトライ仕様

データベース操作失敗時のリトライはueberDB2層で処理される。

## トランザクション仕様

単一のデータベース読み取り操作のみのため、トランザクション管理は不要。

## パフォーマンス要件

- レスポンス時間: 通常100ms以下（グループ数に依存）
- 注意: グループ数が多い場合はレスポンスサイズが大きくなる

## セキュリティ考慮事項

- APIキーまたはOAuth2トークンによる認証が必須
- グループIDは公開されるが、グループ内のパッドへのアクセスにはセッションが必要

## 備考

- APIバージョン1.1から利用可能
- 大量のグループが存在する場合のページネーション機能は未実装

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

グループ一覧データの構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | GroupManager.ts | `src/node/db/GroupManager.ts` | groupsレコードの構造（{groupID: 1, ...}形式） |

**読解のコツ**: `groups`レコードはオブジェクトで、各グループIDがキー、値は1（存在フラグ）として保存される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | RestAPI.ts | `src/node/handler/RestAPI.ts` | GET /groups のルーティング |
| 2-2 | APIHandler.ts | `src/node/handler/APIHandler.ts` | listAllGroupsパラメータ定義（パラメータなし） |

**主要処理フロー**:
1. **850-855行目（RestAPI.ts）**: GET /groups のルーティング定義
2. **69行目（APIHandler.ts）**: `listAllGroups: []` パラメータなし

#### Step 3: コアロジックを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | API.ts | `src/node/db/API.ts` | listAllGroups関数のエクスポート |
| 3-2 | GroupManager.ts | `src/node/db/GroupManager.ts` | listAllGroups関数の実装 |

**主要処理フロー**:
- **44行目（API.ts）**: `exports.listAllGroups = groupManager.listAllGroups;`
- **32-38行目（GroupManager.ts）**: listAllGroups関数の実装
  - **33行目**: `db.get('groups')` でグループ一覧取得
  - **34行目**: null対策で空オブジェクト代入
  - **36行目**: `Object.keys(groups)` でID配列生成

### プログラム呼び出し階層図

```
GET /api/2/groups (RestAPI.ts)
    │
    ├─ APIHandler.handle() (APIHandler.ts:161)
    │      │
    │      ├─ 認証検証 (APIHandler.ts:175-200)
    │      │
    │      └─ api.listAllGroups() (API.ts:44)
    │              │
    │              └─ groupManager.listAllGroups() (GroupManager.ts:32)
    │                      │
    │                      └─ db.get('groups')
    │
    └─ Response: {code: 0, message: "ok", data: {groupIDs: [...]}}
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTP GET        ─────▶ RestAPI.ts
/api/2/groups          ルーティング
                           │
apikey/token   ─────▶ APIHandler.ts
                       認証検証
                           │
                       GroupManager.ts
                       │ db.get('groups')
                       │ Object.keys()
                           │
                           ▼
                       {groupIDs: [...]} ─────▶ JSON Response
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| RestAPI.ts | `src/node/handler/RestAPI.ts` | ソース | APIルーティング定義 |
| APIHandler.ts | `src/node/handler/APIHandler.ts` | ソース | API認証・パラメータ処理 |
| API.ts | `src/node/db/API.ts` | ソース | API関数エクスポート |
| GroupManager.ts | `src/node/db/GroupManager.ts` | ソース | グループ管理コアロジック |
| DB.ts | `src/node/db/DB.ts` | ソース | データベースアクセス層 |
