# 機能設計書 59-カーソル位置同期

## 概要

本ドキュメントは、Etherpadにおけるカーソル位置同期機能の設計仕様を記載する。ユーザーのカーソル位置をリアルタイムで他のユーザーと同期する機能について詳細に解説する。

### 本機能の処理概要

カーソル位置同期機能は、パッド上での各ユーザーのカーソル位置（キャレット位置や選択範囲）をリアルタイムで他の接続ユーザーに通知し、共同編集時の編集位置の可視化を提供する機能である。

**業務上の目的・背景**：
複数ユーザーが同時に編集する際、他のユーザーがドキュメントのどの部分を編集しているかを把握することは非常に重要である。カーソル位置の共有により、編集の衝突を避けたり、同じ箇所への重複編集を防いだり、効率的なコラボレーションが可能になる。

**機能の利用シーン**：
- 複数人でドキュメントを同時編集している場合
- ペアプログラミングやペアライティングを行う場合
- リモートでの共同作業で相手の作業箇所を確認したい場合
- 会議中のリアルタイム議事録作成

**主要な処理内容**：
1. クライアントでカーソル位置変更を検知
2. カーソル位置情報をSocket.IO経由で送信
3. サーバーで他クライアントにブロードキャスト
4. 各クライアントで他ユーザーのカーソルを表示

**関連システム・外部連携**：
- Socket.IO: WebSocket経由のリアルタイム通信
- クライアントサイドエディタ（ACE）: カーソル位置の検知と表示

**権限による制御**：
読み取り専用ユーザーのカーソル位置も他ユーザーに共有される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 2 | パッド編集画面 | 主機能 | ユーザーのカーソル位置をリアルタイムで他のユーザーと同期 |

## 機能種別

リアルタイム通信 / UI同期

## 入力仕様

### 入力パラメータ

カーソル位置情報はクライアントサイドで処理されるため、サーバーサイドでの直接的な入力パラメータ定義はない。クライアント間でSocket.IO経由で直接やり取りされる。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| type | string | Yes | メッセージタイプ（COLLABROOM） | 固定値 |
| data.type | string | Yes | データタイプ | カーソル関連メッセージ |
| data.userId | string | Yes | ユーザー（著者）ID | |
| data.cursorPosition | object | No | カーソル位置情報 | |

### 入力データソース

- クライアントのエディタ（ACE）からのカーソル位置変更イベント
- Socket.IOメッセージ

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| userId | string | カーソル位置を持つユーザーID |
| cursorPosition | object | カーソル位置情報（行、列、選択範囲等） |
| colorId | string | ユーザーの表示カラー |

### 出力先

- Socket.IO経由で同一パッドの他クライアントにブロードキャスト

## 処理フロー

### 処理シーケンス

```
1. クライアントAでカーソル移動
   └─ ACEエディタがカーソル位置変更を検知
2. カーソル位置情報を構築
   └─ 行番号、列番号、選択範囲等
3. Socket.IOでサーバーに送信
   └─ COLLABROOMメッセージとして送信
4. サーバーで受信
   └─ PadMessageHandlerで処理
5. 同一パッドの他クライアントにブロードキャスト
   └─ socket.broadcast.to(padId)
6. クライアントBでカーソル表示
   └─ 他ユーザーのカーソルをエディタ上に表示
```

### フローチャート

```mermaid
flowchart TD
    A[ユーザーAがカーソル移動] --> B[ACEエディタで位置検知]
    B --> C[カーソル位置情報構築]
    C --> D[Socket.IOで送信]
    D --> E[サーバー受信]
    E --> F[PadMessageHandler]
    F --> G[同一パッドの他ユーザーにブロードキャスト]
    G --> H[ユーザーBのクライアント受信]
    H --> I[他ユーザーカーソル表示更新]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-59-01 | カラー表示 | 各ユーザーのカーソルはそのユーザーのカラーで表示 | 常時 |
| BR-59-02 | 同一パッド限定 | カーソル位置は同一パッドの参加者のみに共有 | 常時 |
| BR-59-03 | リアルタイム更新 | カーソル移動は即座に他ユーザーに反映 | 常時 |

### 計算ロジック

特になし（クライアントサイドで処理）

## データベース操作仕様

### 操作別データベース影響一覧

カーソル位置情報はデータベースに永続化されない。リアルタイム通信のみで処理。

| 操作 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | - | - | DB操作なし |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 接続切断 | 通信エラー | WebSocket切断 | 自動再接続 |

### リトライ仕様

カーソル位置情報は一時的なものであり、送信失敗時のリトライは行わない。次回のカーソル移動時に最新位置が送信される。

## トランザクション仕様

データベース操作がないためトランザクション管理は不要。

## パフォーマンス要件

- カーソル移動は高頻度で発生するため、軽量なメッセージ形式を使用
- スロットリング/デバウンス処理はクライアントサイドで実装
- サーバーは単純にブロードキャストするのみ

## セキュリティ考慮事項

- 同一パッドの参加者のみにカーソル位置を共有
- ユーザーIDは著者IDとして検証済み

## 備考

- カーソル位置同期の詳細実装はクライアントサイド（ACEエディタ、collab_client等）に依存
- サーバーサイドはメッセージの転送（ブロードキャスト）が主な役割
- 具体的なカーソル位置のデータ構造はクライアントサイドで定義

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: クライアントサイドのカーソル処理を理解する

カーソル位置同期の主要ロジックはクライアントサイドにある。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | collab_client.js | `src/static/js/collab_client.js` | 共同編集クライアントのメイン処理 |
| 1-2 | ace.js | `src/static/js/ace.js` | エディタコアとカーソル管理 |

**読解のコツ**: クライアントサイドでカーソル位置の検知、メッセージ送信、他ユーザーカーソル表示を行う。サーバーはメッセージの転送のみ。

#### Step 2: サーバーサイドのメッセージ転送を理解する

サーバーでのブロードキャスト処理を確認。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | COLLABROOMメッセージ処理 |

**主要処理フロー**:
- **398-429行目**: COLLABROOMメッセージの振り分け
- カーソル位置メッセージは特別な処理なしでクライアント間でやり取り

**読解のコツ**: サーバーサイドでは明示的なカーソル位置処理は少なく、クライアントサイドのcollab_clientとACEエディタが主要な実装を担う。

#### Step 3: ユーザー情報との連携を理解する

カーソル表示にはユーザーカラーが使用される。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | USER_NEWINFO、historicalAuthorData |

**読解のコツ**: カーソルカラーは著者のcolorIdから取得。USER_NEWINFOで色情報が共有される。

### プログラム呼び出し階層図

```
[クライアントサイド]
エディタ (ACE)
    │
    ├─ カーソル位置変更検知
    │
    └─ collab_client.js
           │
           └─ Socket.IO送信
                  │
[サーバーサイド]    │
                  ▼
           PadMessageHandler
                  │
                  └─ socket.broadcast.to(padId)
                         │
[クライアントサイド]    │
                  ▼
           collab_client.js (他ユーザー)
                  │
                  └─ カーソル表示更新
```

### データフロー図

```
[入力]                      [処理]                           [出力]

ユーザーA            ┌─────────────────┐
カーソル移動 ───────▶│  ACEエディタ    │
                    │  位置検知       │
                    └────────┬────────┘
                             │
                             ▼
                    ┌─────────────────┐
                    │  collab_client  │
                    │  メッセージ構築 │
                    └────────┬────────┘
                             │
                             ▼
                    ┌─────────────────┐
                    │  Socket.IO      │
                    │  送信           │
                    └────────┬────────┘
                             │
                             ▼
                    ┌─────────────────┐
                    │  サーバー       │
                    │  (転送のみ)     │
                    └────────┬────────┘
                             │
                             ▼
                    ┌─────────────────┐
ユーザーB ◀─────────│  Socket.IO      │
カーソル表示        │  ブロードキャスト│
                    └─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | ソース | サーバーサイドメッセージ処理 |
| collab_client.js | `src/static/js/collab_client.js` | ソース | クライアント共同編集ロジック |
| ace.js | `src/static/js/ace.js` | ソース | エディタコア |
| SocketIORouter.ts | `src/node/handler/SocketIORouter.ts` | ソース | Socket.IOルーティング |
| AuthorManager.ts | `src/node/db/AuthorManager.ts` | ソース | カラー情報管理 |
