# 機能設計書 64-統計情報取得

## 概要

本ドキュメントは、Etherpadの統計情報取得機能の設計を記載する。この機能により、パッド数、セッション数、アクティブパッド数などの統計情報をREST APIおよびPrometheusメトリクス形式で取得できる。

### 本機能の処理概要

統計情報取得機能は、Etherpadの稼働状況をモニタリングするための各種メトリクスを提供する機能である。measured-coreライブラリを使用した内部統計と、Prometheus互換のメトリクスエクスポート機能を持つ。

**業務上の目的・背景**：Etherpadの運用において、システムの健全性やリソース使用状況を把握することは重要である。統計情報を外部モニタリングツール（Prometheus/Grafana等）と連携することで、アラート設定やトレンド分析が可能となり、プロアクティブな運用が実現できる。

**機能の利用シーン**：
- ダッシュボードでアクティブユーザー数を確認する場合
- Prometheusでメトリクスを収集してGrafanaで可視化する場合
- システム負荷を監視してスケーリング判断に利用する場合
- ueberDBのメトリクス（キャッシュヒット率等）を確認する場合

**主要な処理内容**：
1. measured-coreによる統計情報の収集
2. /statsエンドポイントでのJSON形式での統計出力
3. /stats/prometheusエンドポイントでのPrometheus形式での統計出力
4. ueberDBメトリクスの収集とエクスポート
5. アクティブパッド数・ユーザー数のリアルタイム取得

**関連システム・外部連携**：
- Prometheus（メトリクス収集）
- Grafana（可視化）
- ueberDB2（データベースメトリクス）

**権限による制御**：統計エンドポイントは認証なしでアクセス可能（enableMetrics設定がtrueの場合）。ただし、本番環境ではリバースプロキシ等でアクセス制限することが推奨される。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 7 | プラグイン管理画面 | API連携 | 接続ユーザー数などの統計情報を取得して表示 |
| 9 | ヘルプ/情報画面 | 主機能 | Etherpadのバージョン情報を取得して表示 |
| 11 | コミュニケーション画面 | 補助機能 | 現在接続中のユーザー数を取得して表示 |

## 機能種別

データ取得 / モニタリング

## 入力仕様

### 入力パラメータ

本機能はクエリパラメータを必要としない。

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| - | - | - | パラメータなし | - |

### 入力データソース

- PadMessageHandler（アクティブユーザー・パッド情報）
- ueberDB2（データベースメトリクス）
- measured-core（内部統計）

## 出力仕様

### 出力データ

#### /stats（JSON形式）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| (各種メトリクス) | object | measured-coreによる統計情報 |

#### /stats/prometheus（Prometheus形式）

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ueberdb_stats | gauge | ueberDBのメトリクス（type別） |
| etherpad_total_users | gauge | 総接続ユーザー数 |
| etherpad_active_pads | gauge | アクティブパッド数 |
| (デフォルトメトリクス) | various | Node.jsプロセスのメトリクス |

### 出力先

- HTTPレスポンス（JSON形式またはPrometheus形式）

## 処理フロー

### 処理シーケンス

```
1. HTTPリクエスト受信
   └─ /stats または /stats/prometheus
2. enableMetrics設定確認
   └─ falseの場合は404
3. 統計情報収集
   └─ /stats: measured-core.toJSON()
   └─ /stats/prometheus: prometheusモジュール呼び出し
4. レスポンス生成
   └─ /stats: JSON形式
   └─ /stats/prometheus: text/plain形式
5. レスポンス返却
```

### フローチャート

```mermaid
flowchart TD
    A[HTTPリクエスト] --> B{enableMetrics?}
    B -->|No| C[404 Not Found]
    B -->|Yes| D{エンドポイント}
    D -->|/stats| E[stats.toJSON]
    D -->|/stats/prometheus| F[prometheus関数]
    E --> G[JSON返却]
    F --> H[ueberDBメトリクス取得]
    H --> I[activePads取得]
    I --> J[totalUsers取得]
    J --> K[Prometheus形式返却]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-64-01 | メトリクス有効化 | enableMetrics設定がtrueの場合のみエンドポイントが有効 | 常時 |
| BR-64-02 | デフォルトメトリクス | Node.jsのデフォルトメトリクスも収集 | Prometheus形式 |

### 計算ロジック

アクティブパッド数の取得:
```typescript
PadMessageHandler.getActivePadCountFromSessionInfos()
```

総接続ユーザー数の取得:
```typescript
PadMessageHandler.getTotalActiveUsers()
```

## データベース操作仕様

### 操作別データベース影響一覧

本機能はデータベースを直接操作しない。ueberDBのメトリクスはueberDBライブラリから取得。

| 操作 | 対象 | 操作種別 | 概要 |
|-----|-----|---------|------|
| メトリクス取得 | db.metrics | READ | ueberDBの統計情報取得 |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 404 | Not Found | enableMetrics=false | 設定変更を案内 |

### リトライ仕様

エラー時は自動リトライなし。

## トランザクション仕様

読み取り専用のため、トランザクション制御は不要。

## パフォーマンス要件

- 統計取得: 100ms以内
- Prometheusスクレイプ間隔に対応（通常15秒〜1分）

## セキュリティ考慮事項

- 統計エンドポイントは認証なしでアクセス可能
- 本番環境ではリバースプロキシでアクセス制限を推奨
- 統計情報に機密データは含まれない

## 備考

- Prometheusメトリクスはprom-clientライブラリを使用
- measured-coreは内部統計の収集に使用

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | prometheus.ts | `src/node/prometheus.ts` | Prometheusメトリクスの定義を確認 |

**読解のコツ**: prom-clientライブラリのGaugeオブジェクトがメトリクスを表現する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | specialpages.ts | `src/node/hooks/express/specialpages.ts` | HTTPエンドポイントの定義 |

**主要処理フロー**:
1. **37行目**: enableMetrics設定チェック
2. **38-40行目**: /statsエンドポイント - JSON形式の統計
3. **42-46行目**: /stats/prometheusエンドポイント - Prometheus形式

#### Step 3: 統計収集モジュールを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stats.ts | `src/node/stats.ts` | measured-coreによる統計収集 |
| 3-2 | prometheus.ts | `src/node/prometheus.ts` | Prometheusメトリクス定義 |

**主要処理フロー**:
- **stats.ts 5行目**: measured.createCollection()で統計コレクション作成
- **prometheus.ts 7-12行目**: ueberdb_statsゲージ定義
- **prometheus.ts 14-18行目**: etherpad_total_usersゲージ定義
- **prometheus.ts 20-24行目**: etherpad_active_padsゲージ定義
- **prometheus.ts 28-36行目**: monitor関数でメトリクス更新

#### Step 4: データソースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | アクティブユーザー・パッド情報 |
| 4-2 | DB.ts | `src/node/db/DB.ts` | ueberDBメトリクス |

**主要処理フロー**:
- **DB.ts 42-47行目**: ueberDBメトリクスの登録

### プログラム呼び出し階層図

```
HTTPリクエスト
    │
    ├─ GET /stats
    │      │
    │      └─ specialpages.ts: app.get('/stats')
    │             └─ stats.toJSON()
    │                    └─ measured-core
    │
    └─ GET /stats/prometheus
           │
           └─ specialpages.ts: app.get('/stats/prometheus')
                  └─ prometheus()
                         ├─ db.metrics (ueberDB)
                         ├─ PadMessageHandler.getActivePadCountFromSessionInfos()
                         └─ PadMessageHandler.getTotalActiveUsers()
```

### データフロー図

```
[入力]               [処理]                    [出力]

HTTPリクエスト ───▶ specialpages.ts
                         │
                         ▼
         ┌───────────────┼───────────────┐
         │               │               │
         ▼               ▼               ▼
     stats.ts    prometheus.ts    PadMessageHandler
         │               │               │
         │               ▼               │
         │         prom-client ◀─────────┘
         │               │
         ▼               ▼
   JSON形式 ───▶  HTTPレスポンス ◀─── Prometheus形式
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| specialpages.ts | `src/node/hooks/express/specialpages.ts` | ソース | HTTPエンドポイント |
| stats.ts | `src/node/stats.ts` | ソース | measured-core統計 |
| prometheus.ts | `src/node/prometheus.ts` | ソース | Prometheusメトリクス |
| DB.ts | `src/node/db/DB.ts` | ソース | ueberDBメトリクス登録 |
| PadMessageHandler.ts | `src/node/handler/PadMessageHandler.ts` | ソース | アクティブ情報取得 |
| Settings.ts | `src/node/utils/Settings.ts` | ソース | enableMetrics設定 |
