# 機能設計書 71-ログ設定

## 概要

本ドキュメントは、Etherpadにおけるログ設定機能の設計を定義する。log4jsライブラリを使用したログ出力の設定・管理機能について記述する。

### 本機能の処理概要

log4jsを使用してアプリケーション全体のログ出力を制御する機能である。ログレベルの設定、出力先の指定、フォーマットのカスタマイズが可能である。

**業務上の目的・背景**：運用時のトラブルシューティングや監査、パフォーマンス分析のためにアプリケーションの動作状況を記録する必要がある。適切なログ出力により、問題発生時の原因特定が容易になり、システムの安定運用に寄与する。また、開発時にはデバッグ情報の出力により開発効率を向上させる。

**機能の利用シーン**：
- システム管理者がログレベルを変更して詳細なデバッグ情報を取得する場面
- 本番環境で警告以上のログのみを出力してディスク容量を節約する場面
- 複数のアペンダーを設定してログをファイルとコンソールに同時出力する場面

**主要な処理内容**：
1. settings.jsonからログ設定（loglevel、logLayoutType、logconfig）を読み込み
2. デフォルトのログ設定を生成（レベル：INFO、レイアウト：colored）
3. log4js.configure()を呼び出してログシステムを初期化
4. console.debug/log/warn/errorをloggerのメソッドにオーバーライド
5. カスタムlogconfigが指定されている場合はそれを適用

**関連システム・外部連携**：log4jsライブラリを使用。設定はsettings.jsonで管理される。

**権限による制御**：設定ファイルの編集権限を持つ管理者のみがログ設定を変更可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 8 | 設定管理画面 | 参照画面 | settings.jsonでログ設定を編集 |

## 機能種別

システム設定 / 初期化処理

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| loglevel | string | No | ログレベル（DEBUG/INFO/WARN/ERROR） | デフォルト：INFO |
| logLayoutType | string | No | ログ出力レイアウトタイプ | デフォルト：colored |
| logconfig | object | No | log4jsのカスタム設定オブジェクト | log4jsの設定形式に従う |

### 入力データソース

- settings.json: メインの設定ファイル
- 環境変数: 設定値の上書きに使用可能

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| ログ出力 | string | 設定に基づいたフォーマットでのログメッセージ |

### 出力先

- コンソール（標準出力/標準エラー出力）
- ファイル（logconfig設定時）
- カスタムアペンダー（logconfig設定時）

## 処理フロー

### 処理シーケンス

```
1. デフォルトログ設定の生成
   └─ defaultLogConfig関数でINFO/coloredをデフォルトとして設定
2. 初期ログシステムの起動
   └─ モジュール読み込み時にデフォルト設定でinitLogging()を実行
3. settings.jsonの読み込み
   └─ parseSettings()でloglevel/logLayoutType/logconfigを取得
4. ログ設定の再初期化
   └─ reloadSettings()内でログ設定を再構築しinitLogging()を再実行
5. consoleメソッドのオーバーライド
   └─ console.log等をloggerのメソッドにバインド
```

### フローチャート

```mermaid
flowchart TD
    A[モジュール読み込み開始] --> B[defaultLogConfig生成]
    B --> C[initLogging実行 - デフォルト設定]
    C --> D[settings.json読み込み]
    D --> E{logconfig設定あり?}
    E -->|Yes| F[カスタムlogconfigを使用]
    E -->|No| G[loglevel/logLayoutTypeから設定生成]
    F --> H[initLogging再実行]
    G --> H
    H --> I[consoleメソッドをオーバーライド]
    I --> J[ログシステム初期化完了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-71-01 | デフォルトログレベル | loglevelが未指定の場合はINFOを使用 | loglevelがnull/undefinedの場合 |
| BR-71-02 | デフォルトレイアウト | logLayoutTypeが未指定の場合はcoloredを使用 | logLayoutTypeがnull/undefinedの場合 |
| BR-71-03 | カスタム設定優先 | logconfigが指定されている場合はそれを優先 | logconfigがオブジェクトとして設定されている場合 |

### 計算ロジック

特になし

## データベース操作仕様

本機能ではデータベース操作は行わない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | 設定エラー | 不正なlogconfig形式 | log4jsがエラーをスロー、デフォルト設定にフォールバック |

### リトライ仕様

なし

## トランザクション仕様

なし

## パフォーマンス要件

- ログ初期化は起動時に1回のみ実行
- ログ出力はアプリケーション性能に影響を与えないよう非同期で処理

## セキュリティ考慮事項

- disableIPlogging設定によりIPアドレスのログ出力を抑制可能
- 認証情報や機密情報のログ出力を避けること
- ログファイルへのアクセス権限を適切に設定すること

## 備考

- log4jsの詳細な設定オプションは公式ドキュメントを参照
- settings.json.templateにログ設定の例が記載されている

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、ログ設定に関連するデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Settings.ts | `src/node/utils/Settings.ts` | SettingsType型定義でloglevel、logLayoutType、logconfigの型を確認 |

**読解のコツ**: TypeScriptの型定義を確認することで、設定可能なパラメータとその型が把握できる。

#### Step 2: エントリーポイントを理解する

処理の起点となる設定読み込み部分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Settings.ts | `src/node/utils/Settings.ts` | モジュール初期化時のログ設定処理 |

**主要処理フロー**:
1. **55-62行目**: defaultLogConfig関数でデフォルト設定オブジェクトを生成
2. **64-74行目**: initLogging関数でlog4js.configure()を実行しconsoleメソッドをオーバーライド
3. **78行目**: モジュール読み込み時にデフォルト設定でログを初期化
4. **940-953行目**: reloadSettings()内でログ設定を再初期化

#### Step 3: ログ設定適用処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Settings.ts | `src/node/utils/Settings.ts` | reloadSettings関数内のログ初期化処理 |

**主要処理フロー**:
- **946-950行目**: settings.logconfigにデフォルト設定を代入（カスタム設定がない場合）
- **951-952行目**: ログレベルとレイアウトタイプをログ出力
- **953行目**: initLogging()を呼び出してログシステムを再初期化

### プログラム呼び出し階層図

```
Settings.ts (モジュール初期化)
    │
    ├─ defaultLogConfig() [55-62行目]
    │      └─ ログ設定オブジェクトを生成
    │
    ├─ initLogging() [64-74行目] ※初回呼び出し
    │      ├─ log4js.configure()
    │      └─ console.* のオーバーライド
    │
    └─ reloadSettings() [940-1088行目]
           │
           ├─ parseSettings() [92-131行目]
           │      └─ settings.jsonを読み込み
           │
           ├─ storeSettings() [712-740行目]
           │      └─ 設定値をモジュール変数に反映
           │
           └─ initLogging() [953行目] ※再初期化
                  ├─ log4js.configure()
                  └─ console.* のオーバーライド
```

### データフロー図

```
[入力]                    [処理]                         [出力]

settings.json ─────▶ parseSettings() ─────▶ settings.loglevel
                                            settings.logLayoutType
                                            settings.logconfig
                           │
                           ▼
                    defaultLogConfig()
                           │
                           ▼
                    initLogging()
                           │
                           ▼
                    log4js.configure() ─────▶ Logger インスタンス
                           │
                           ▼
                    console.* override ─────▶ コンソール出力
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Settings.ts | `src/node/utils/Settings.ts` | ソース | ログ設定のメイン実装 |
| settings.json | プロジェクトルート | 設定 | ユーザー設定ファイル |
| settings.json.template | プロジェクトルート | テンプレート | 設定例を含むテンプレート |
| package.json | `src/package.json` | 設定 | log4js依存関係の定義 |
