---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：1-グループ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/node/db/GroupManager.ts` 96-104行目（createGroup関数実装）
- E-02: `src/node/db/GroupManager.ts` 23行目（randomStringインポート）
- E-03: `src/static/js/pad_utils.ts` 34-43行目（randomString関数実装）
- E-04: `src/node/handler/RestAPI.ts` 323-327行目（POST /groups ルーティング）
- E-05: `src/node/db/API.ts` 45行目（createGroupエクスポート）
- E-06: `src/node/handler/APIHandler.ts` 36行目（createGroup パラメータ定義）
- E-07: `src/node/handler/APIHandler.ts` 175-200行目（認証処理）
- E-08: `src/node/db/DB.ts` 39-54行目（データベース初期化・操作関数）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` 2行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | グループ作成はPOST /api/2/groupsエンドポイントで提供される | E-04 | ○ |
| C-02 | グループIDは"g."プレフィックス + 16文字のランダム文字列 | E-01, E-02, E-03 | ○ |
| C-03 | randomString関数は62種類の文字から選択する | E-03 | ○ |
| C-04 | グループデータは{pads: {}, mappings: {}}の構造で初期化される | E-01 | ○ |
| C-05 | グループ個別レコードはdb.setで保存される | E-01 | ○ |
| C-06 | グループ一覧はdb.setSubで更新される | E-01 | ○ |
| C-07 | createGroup関数はパラメータを取らない | E-06 | ○ |
| C-08 | API.tsはgroupManager.createGroupを再エクスポートする | E-05 | ○ |
| C-09 | APIキー認証が必要 | E-07 | ○ |
| C-10 | OAuth2認証がサポートされている | E-07 | ○ |
| C-11 | レスポンスはcode, message, dataの構造 | E-04 | ○ |
| C-12 | グループレコード保存後に一覧を更新する順序 | E-01 | ○ |
| C-13 | 機能名は「グループ作成」である | E-09 | ○ |
| C-14 | APIバージョン1から利用可能 | E-06 | ○ |
| C-15 | ueberDB2がデータベースバックエンドとして使用される | E-08 | ○ |
| C-16 | グループ作成後の戻り値は{groupID: string} | E-01 | ○ |
| C-17 | RestAPI.tsでswagger定義が含まれている | E-04 | ○ |
| C-18 | 認証失敗時は401エラーが返される | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] GroupManager.ts の createGroup 関数実装が設計書と一致しているか確認
- [ ] randomString 関数の文字種（62種類）が正確か確認
- [ ] データベース保存順序（個別レコード → 一覧）が意図通りか確認
