---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-履歴なしパッドコピー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 633-636行目（copyPadWithoutHistory関数実装）
- E-02: `src/node/db/Pad.ts` 500-555行目（copyPadWithoutHistory関数実装）
- E-03: `src/node/db/Pad.ts` 502行目（saveToDatabase）
- E-04: `src/node/db/Pad.ts` 505行目（checkIfGroupExistAndReturnIt）
- E-05: `src/node/db/Pad.ts` 508行目（removePadIfForceIsTrueAndAlreadyExist）
- E-06: `src/node/db/Pad.ts` 510行目（copyAuthorInfoToDestinationPad）
- E-07: `src/node/db/Pad.ts` 513-515行目（グループ登録）
- E-08: `src/node/db/Pad.ts` 518行目（padManager.getPad）
- E-09: `src/node/db/Pad.ts` 519行目（pool.clone）
- E-10: `src/node/db/Pad.ts` 524行目（SmartOpAssembler）
- E-11: `src/node/db/Pad.ts` 530行目（oldLength = 2）
- E-12: `src/node/db/Pad.ts` 537行目（pack）
- E-13: `src/node/db/Pad.ts` 538行目（appendRevision）
- E-14: `src/node/handler/RestAPI.ts` 1246-1275行目（ルーティング定義）
- E-15: `src/node/handler/APIHandler.ts` 131行目, 137行目（パラメータ定義）
- E-16: `docs/code-to-docs/機能一覧/機能一覧.csv` 11行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントはPOST /api/2/pads/copyWithoutHistory | E-14 | ○ |
| C-02 | sourceID, destinationID, force, authorIdがパラメータ | E-15 | ○ |
| C-03 | getPadSafeでコピー元パッド取得 | E-01 | ○ |
| C-04 | saveToDatabaseでフラッシュ | E-03 | ○ |
| C-05 | checkIfGroupExistAndReturnItでグループ確認 | E-04 | ○ |
| C-06 | removePadIfForceIsTrueAndAlreadyExistで既存削除 | E-05 | ○ |
| C-07 | copyAuthorInfoToDestinationPadで著者コピー | E-06 | ○ |
| C-08 | グループパッドはdb.setSubでグループに登録 | E-07 | ○ |
| C-09 | padManager.getPadで新規パッド作成（'\n'初期化） | E-08 | ○ |
| C-10 | pool.clone()で属性プールクローン | E-09 | ○ |
| C-11 | SmartOpAssemblerでChangeset組み立て | E-10 | ○ |
| C-12 | 初期パッド長は2（"\n\n"） | E-11 | ○ |
| C-13 | packでChangeset生成 | E-12 | ○ |
| C-14 | appendRevisionでリビジョン追加 | E-13 | ○ |
| C-15 | padCopyフックが実行される | E-02 | ○ |
| C-16 | 機能名は「履歴なしパッドコピー」 | E-16 | ○ |
| C-17 | APIバージョン1.2.15から利用可能 | E-15 | ○ |
| C-18 | APIバージョン1.3.0でauthorId追加 | E-15 | ○ |
| C-19 | チャット履歴はコピーされない | E-02（処理なし） | ○ |
| C-20 | 戻り値は{padID: destinationID} | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] copyPadWithoutHistory関数の実装が設計書と一致しているか確認
- [ ] pool.clone()が正しく動作するか確認
- [ ] SmartOpAssemblerによるChangeset生成が正しいか確認
- [ ] 初期パッド長（oldLength = 2）の根拠を確認
