---
generated_at: 2026-02-10 10:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：11-パッド移動

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **C-25 トランザクション保証の限界**：実装検証が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 650-654行目 - movePad関数定義
- E-02: `src/node/db/Pad.ts` 403-454行目 - copy関数
- E-03: `src/node/db/Pad.ts` 557-615行目 - remove関数
- E-04: `src/node/handler/RestAPI.ts` 1064-1090行目 - REST APIマッピング
- E-05: `src/node/handler/APIHandler.ts` 98-99行目 - movePadパラメータ定義
- E-06: `src/node/db/PadManager.ts` 195行目 - パッドID正規表現
- E-07: `src/node/db/Pad.ts` 456-469行目 - グループ存在確認
- E-08: `src/node/db/Pad.ts` 471-492行目 - 強制上書き処理
- E-09: `src/node/db/Pad.ts` 494-498行目 - 著者情報コピー
- E-10: `src/node/db/Pad.ts` 562行目 - kickSessionsFromPad呼び出し
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-12: `src/node/db/Pad.ts` 418-433行目 - データコピー処理

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | movePadはコピー+削除で実装 | E-01 | ○ |
| C-02 | API パス POST /api/2/pads/movePad | E-04 | ○ |
| C-03 | sourceID, destinationID, forceパラメータ | E-05 | ○ |
| C-04 | パッドID正規表現検証 | E-06 | ○ |
| C-05 | 移動元パッドの存在確認 | E-01 | ○ |
| C-06 | コピー処理の実行 | E-02 | ○ |
| C-07 | 元パッドの削除処理 | E-03 | ○ |
| C-08 | グループ存在確認処理 | E-07 | ○ |
| C-09 | 強制上書きオプション | E-08 | ○ |
| C-10 | 著者情報の関連付け | E-09 | ○ |
| C-11 | 接続クライアントのキック | E-10 | ○ |
| C-12 | リビジョン履歴のコピー | E-12 | ○ |
| C-13 | チャット履歴のコピー | E-12 | ○ |
| C-14 | 成功時レスポンス形式 | E-01, E-02 | ○ |
| C-15 | エラーコード体系 | E-04 | ○ |
| C-16 | forceの文字列対応 | E-08 | ○ |
| C-17 | pad:{id}レコードのコピー | E-12 | ○ |
| C-18 | revs:レコードのコピー | E-12 | ○ |
| C-19 | chat:レコードのコピー | E-12 | ○ |
| C-20 | readonly関連の削除 | E-03 | ○ |
| C-21 | グループパッド登録 | E-02 | ○ |
| C-22 | 100件単位バッチ処理 | E-02 | ○ |
| C-23 | APIキー認証 | E-05 | ○ |
| C-24 | OAuth2認証対応 | E-05 | ○ |
| C-25 | 完全なトランザクション保証なし | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-25: トランザクション保証に関する明示的なドキュメントがない
  - 候補：ueberDB2ドキュメント / 実装テスト / 開発者コメント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な機能仕様は明確に実装から読み取れる
- 1: 中リスク - トランザクション整合性の記述は推論に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] movePad関数の処理順序がコピー→削除であることを確認
- [ ] グループパッド移動時のグループ存在確認ロジックを確認
- [ ] 強制上書き時の既存パッド削除処理を確認
- [ ] 著者情報の移動先への関連付けを確認
- [ ] 接続クライアントのキックアウトタイミングを確認
- [ ] トランザクション失敗時の状態を実際にテストで確認
