---
generated_at: 2026-02-10 11:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-HTML取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 252-274行目 - getHTML関数定義
- E-02: `src/node/utils/ExportHtml.ts` 34-44行目 - getPadHTML関数
- E-03: `src/node/utils/ExportHtml.ts` 46-477行目 - getHTMLFromAtext関数
- E-04: `src/node/handler/RestAPI.ts` 612-626行目 - REST APIマッピング
- E-05: `src/node/handler/APIHandler.ts` 52行目 - getHTMLパラメータ
- E-06: `src/node/db/API.ts` 272行目 - HTMLラッピング処理
- E-07: `src/node/utils/ExportHtml.ts` 286行目 - rel="noreferrer noopener"
- E-08: `src/node/utils/ExportHtml.ts` 51-70行目 - プラグインフック
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API パス GET /api/2/pads/html | E-04 | ○ |
| C-02 | padIDとrevパラメータ | E-05 | ○ |
| C-03 | htmlを返却 | E-01 | ○ |
| C-04 | rev未指定時は最新HTML | E-01, E-02 | ○ |
| C-05 | rev指定時は過去リビジョン | E-01, E-02 | ○ |
| C-06 | リビジョン範囲チェック | E-01 | ○ |
| C-07 | getPadHTML関数の呼び出し | E-01, E-02 | ○ |
| C-08 | getHTMLFromAtext関数 | E-02, E-03 | ○ |
| C-09 | DOCTYPE付きHTML | E-06 | ○ |
| C-10 | html+bodyタグでラップ | E-06 | ○ |
| C-11 | 属性→タグ変換 | E-03 | ○ |
| C-12 | strong/em/h1等のタグ | E-03 | ○ |
| C-13 | ol/ulタグ生成 | E-03 | ○ |
| C-14 | URL自動リンク | E-03 | ○ |
| C-15 | rel="noreferrer noopener" | E-07 | ○ |
| C-16 | HTMLエスケープ | E-03 | ○ |
| C-17 | プラグインフック対応 | E-08 | ○ |
| C-18 | exportHtmlAdditionalTags | E-08 | ○ |
| C-19 | 属性プール使用 | E-03 | ○ |
| C-20 | splitAttributionLines | E-03 | ○ |
| C-21 | _analyzeLine | E-03 | ○ |
| C-22 | エラーメッセージ | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用APIで、XSS対策も実装済み

## 6) レビュアーチェックリスト（最小）
- [ ] getPadHTML関数が正しくATextを取得することを確認
- [ ] getHTMLFromAtextの属性→タグ変換を確認
- [ ] DOCTYPE付きの完全HTMLが返されることを確認
- [ ] URLのリンク化とrel属性を確認
- [ ] HTMLエスケープが適切に行われることを確認
