---
generated_at: 2026-02-10 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-グループ条件付き作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/GroupManager.ts` 111-127行目（createGroupIfNotExistsFor関数実装）
- E-02: `src/node/db/GroupManager.ts` 112-114行目（型バリデーション）
- E-03: `src/node/db/GroupManager.ts` 115行目（マッピング検索）
- E-04: `src/node/db/GroupManager.ts` 116行目（グループ存在確認と返却）
- E-05: `src/node/db/GroupManager.ts` 117行目（createGroup呼び出し）
- E-06: `src/node/db/GroupManager.ts` 118-125行目（マッピング保存Promise.all）
- E-07: `src/node/db/GroupManager.ts` 85-90行目（doesGroupExist関数）
- E-08: `src/node/handler/RestAPI.ts` 329-348行目（ルーティング定義）
- E-09: `src/node/handler/APIHandler.ts` 37行目（パラメータ定義）
- E-10: `src/node/db/API.ts` 46行目（関数エクスポート）
- E-11: `docs/code-to-docs/機能一覧/機能一覧.csv` 3行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントはPOST /api/2/groups/createIfNotExistsFor | E-08 | ○ |
| C-02 | groupMapperは必須パラメータ | E-09 | ○ |
| C-03 | groupMapperが文字列でない場合エラー | E-02 | ○ |
| C-04 | mapper2group:{groupMapper}でマッピングを検索 | E-03 | ○ |
| C-05 | グループ存在確認はdoesGroupExist関数で行う | E-04, E-07 | ○ |
| C-06 | 既存グループがあれば既存IDを返却 | E-04 | ○ |
| C-07 | グループ不在時はcreateGroup()を呼び出す | E-05 | ○ |
| C-08 | マッピング保存はPromise.allで並列実行 | E-06 | ○ |
| C-09 | mapper2groupレコードにgroupIDを保存 | E-06 | ○ |
| C-10 | group内mappingsにもマッパー情報を記録 | E-06 | ○ |
| C-11 | API.tsでgroupManager.createGroupIfNotExistsForを再エクスポート | E-10 | ○ |
| C-12 | 冪等性が保証される（同じマッパーで同じIDが返る） | E-04 | ○ |
| C-13 | グループ削除時にマッピングも削除される | E-01（コメント参照） | ○ |
| C-14 | 複数マッピングがサポートされる設計 | E-01（コメント参照） | ○ |
| C-15 | 機能名は「グループ条件付き作成」 | E-11 | ○ |
| C-16 | APIバージョン1から利用可能 | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] createGroupIfNotExistsFor関数の実装が設計書と一致しているか確認
- [ ] マッピング検索とグループ存在確認の順序が正しいか確認
- [ ] Promise.allによる並列保存の動作が意図通りか確認
