---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-属性プール取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` 109-112行目 - getAttributePool関数定義
- E-02: `src/node/db/API.ts` 83-106行目 - 返却値のコメント例
- E-03: `src/static/js/AttributePool.ts` 59-102行目 - AttributePoolクラス定義
- E-04: `src/static/js/AttributePool.ts` 60-66行目 - プロパティ定義
- E-05: `src/static/js/AttributePool.ts` 127-141行目 - putAttribメソッド
- E-06: `src/static/js/AttributePool.ts` 148-154行目 - getAttribメソッド
- E-07: `src/node/db/Pad.ts` 61行目 - pool プロパティ初期化
- E-08: `src/node/handler/RestAPI.ts` 996-1010行目 - REST APIマッピング
- E-09: `src/node/handler/APIHandler.ts` 91行目 - getAttributePoolパラメータ
- E-10: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | API パス GET /api/2/pads/attributePool | E-08 | ○ |
| C-02 | padIDパラメータ | E-09 | ○ |
| C-03 | poolオブジェクトを返却 | E-01 | ○ |
| C-04 | getPadSafe呼び出し | E-01 | ○ |
| C-05 | pad.poolで属性プール取得 | E-01, E-07 | ○ |
| C-06 | numToAttribの構造 | E-02, E-03, E-04 | ○ |
| C-07 | attribToNumの構造 | E-02, E-03, E-04 | ○ |
| C-08 | nextNumの存在 | E-02, E-04 | ○ |
| C-09 | 双方向マッピング | E-05, E-06 | ○ |
| C-10 | APIバージョン1.2.8 | E-08 | ○ |
| C-11 | GETメソッド使用 | E-08 | ○ |
| C-12 | 属性は[key,value]配列 | E-03 | ○ |
| C-13 | 著者属性の例 | E-02 | ○ |
| C-14 | bold属性の例 | E-02 | ○ |
| C-15 | 履歴属性も含む | E-03 (コメント56-57行目) | ○ |
| C-16 | 属性IDは連番 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用APIで、内部構造の参照のみ

## 6) レビュアーチェックリスト（最小）
- [ ] getAttributePool関数がpad.poolを返すことを確認
- [ ] AttributePoolの構造（numToAttrib, attribToNum, nextNum）を確認
- [ ] 双方向マッピングの整合性を確認
- [ ] パッド存在チェックが行われることを確認
