---
generated_at: 2026-02-10 10:50:00
metrics:
  claims_total: 13
  claims_with_evidence: 13
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-アクティブユーザー数取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：13 / 13、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - padUsersCount関数エクスポート（66行目）
- E-02: `src/node/handler/RestAPI.ts` - APIエンドポイント定義（752-766行目）
- E-03: `src/node/handler/APIHandler.ts` - バージョン定義（61行目）
- E-04: `src/node/handler/PadMessageHandler.ts` - padUsersCount関数（1327-1329行目）、_getRoomSockets関数（1310-1322行目）
- E-05: `src/tests/backend/specs/api/pad.ts` - テストケース（266-272行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /api/2/pads/usersCount | E-02 | ○ |
| C-02 | padIDは必須パラメータ | E-03 | ○ |
| C-03 | 戻り値はpadUsersCount（整数） | E-04（1328行目）, E-02（754行目） | ○ |
| C-04 | _getRoomSockets(padID).lengthで計算 | E-04（1328行目） | ○ |
| C-05 | Socket.IOルームからソケット取得 | E-04（1315-1320行目） | ○ |
| C-06 | API認証が必要 | E-03 | ○ |
| C-07 | padMessageHandlerに委譲 | E-01（66行目） | ○ |
| C-08 | APIバージョン1で追加 | E-03（61行目） | ○ |
| C-09 | 関連画面にパッド編集画面含む | E-07 | ○ |
| C-10 | 関連画面にパッド管理画面含む | E-07 | ○ |
| C-11 | 誰も接続していない場合は0 | E-05（271行目：assert.equal(res.body.data.padUsersCount, 0)） | ○ |
| C-12 | データベースアクセスなし | E-04（インメモリ操作のみ） | ○ |
| C-13 | adapter.rooms.getでルーム情報取得 | E-04（1315行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - API仕様は明確にソースコードから確認できる
- 0: 低リスク - テストケースで動作が検証されている

## 6) レビュアーチェックリスト（最小）

- [ ] E-01のpadUsersCount委譲を確認
- [ ] E-04の_getRoomSockets関数を確認
- [ ] Socket.IOのルーム構造を理解しているか確認
