---
generated_at: 2026-02-10 10:55:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-アクティブユーザー一覧取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - padUsers関数エクスポート（65行目）
- E-02: `src/node/handler/RestAPI.ts` - APIエンドポイント定義（785-821行目）
- E-03: `src/node/handler/APIHandler.ts` - バージョン定義（67行目）
- E-04: `src/node/handler/PadMessageHandler.ts` - padUsers関数（1334-1352行目）
- E-05: `src/tests/backend/specs/api/pad.ts` - テストケース（319-325行目）
- E-06: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは GET /api/2/pads/users | E-02 | ○ |
| C-02 | padIDは必須パラメータ | E-03 | ○ |
| C-03 | 戻り値はpadUsers（オブジェクト配列） | E-04（1351行目）, E-02 | ○ |
| C-04 | 各ユーザーにid, colorId, nameを含む | E-04（1345行目）, E-02（792-803行目） | ○ |
| C-05 | _getRoomSocketsでソケット取得 | E-04（1338行目） | ○ |
| C-06 | authorManager.getAuthorで著者情報取得 | E-04（1341行目） | ○ |
| C-07 | 並列でPromise.all実行 | E-04（1338行目） | ○ |
| C-08 | API認証が必要 | E-03 | ○ |
| C-09 | padMessageHandlerに委譲 | E-01（65行目） | ○ |
| C-10 | APIバージョン1.1で追加 | E-03（67行目） | ○ |
| C-11 | 関連画面にパッド編集画面含む | E-07 | ○ |
| C-12 | 誰も接続していない場合は空配列 | E-05（324行目：assert.equal(res.body.data.padUsers.length, 0)） | ○ |
| C-13 | 著者情報不在時はスキップ | E-04（1344行目：if (author)） | ○ |
| C-14 | セッション情報から著者ID取得 | E-04（1340行目） | ○ |
| C-15 | 著者にIDを付加 | E-04（1345行目） | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - API仕様は明確にソースコードから確認できる
- 0: 低リスク - テストケースで動作が検証されている

## 6) レビュアーチェックリスト（最小）

- [ ] E-01のpadUsers委譲を確認
- [ ] E-04のpadUsers関数実装を確認
- [ ] authorManager.getAuthorの戻り値形式を確認
