---
generated_at: 2026-02-10 10:40:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-グループ一覧取得

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/GroupManager.ts` 32-38行目（listAllGroups関数実装）
- E-02: `src/node/db/GroupManager.ts` 33行目（db.get呼び出し）
- E-03: `src/node/db/GroupManager.ts` 34行目（null対策）
- E-04: `src/node/db/GroupManager.ts` 36行目（Object.keys）
- E-05: `src/node/handler/RestAPI.ts` 850-855行目（ルーティング定義）
- E-06: `src/node/handler/APIHandler.ts` 69行目（パラメータ定義）
- E-07: `src/node/db/API.ts` 44行目（関数エクスポート）
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv` 4行目（機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントはGET /api/2/groups | E-05 | ○ |
| C-02 | パラメータは不要（認証のみ） | E-06 | ○ |
| C-03 | db.get('groups')でグループ一覧を取得 | E-02 | ○ |
| C-04 | 結果がnullの場合は空オブジェクトに変換 | E-03 | ○ |
| C-05 | Object.keysでグループID配列を生成 | E-04 | ○ |
| C-06 | 戻り値は{groupIDs: string[]} | E-01 | ○ |
| C-07 | API.tsでgroupManager.listAllGroupsを再エクスポート | E-07 | ○ |
| C-08 | グループが存在しない場合は空配列を返す | E-03, E-04 | ○ |
| C-09 | 機能名は「グループ一覧取得」 | E-08 | ○ |
| C-10 | APIバージョン1.1から利用可能 | E-06 | ○ |
| C-11 | groupsレコードは{groupID: 1, ...}形式 | E-01（構造から推定） | ○ |
| C-12 | 順序は保証されない | E-04（Object.keysの仕様） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] listAllGroups関数の実装が設計書と一致しているか確認
- [ ] null対策の処理が正しく動作するか確認
- [ ] 大量グループ時のパフォーマンスを検証
