---
generated_at: 2026-02-10 11:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：30-リビジョン保存

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `src/node/db/API.ts` - saveRevision関数（455-476行目）
- E-02: `src/node/handler/RestAPI.ts` - APIエンドポイント定義（1133-1156行目）
- E-03: `src/node/handler/APIHandler.ts` - バージョン定義（110行目）
- E-04: `src/node/db/Pad.ts` - addSavedRevision メソッド（623-642行目）、saveToDatabase（156-159行目）
- E-05: `src/node/handler/PadMessageHandler.ts` - handleSaveRevisionMessage関数（444-448行目）
- E-06: `src/node/db/AuthorManager.ts` - createAuthor関数
- E-07: `src/node/utils/checkValidRev.ts` - リビジョン番号バリデーション
- E-08: `src/tests/backend/specs/api/pad.ts` - テストケース（240-246行目）
- E-09: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | APIエンドポイントは POST /api/2/savedRevisions | E-02 | ○ |
| C-02 | padIDは必須パラメータ | E-01, E-03 | ○ |
| C-03 | revは任意パラメータ | E-03（110行目：`saveRevision: ['padID', 'rev']`） | ○ |
| C-04 | rev未指定時はヘッドリビジョンを使用 | E-01（466-469行目） | ○ |
| C-05 | revがヘッドリビジョンを超える場合はエラー | E-01（470-472行目） | ○ |
| C-06 | API認証が必要 | E-03 | ○ |
| C-07 | getPadSafeでパッド取得 | E-01（462行目） | ○ |
| C-08 | checkValidRevでリビジョンバリデーション | E-01（457-459行目）, E-07 | ○ |
| C-09 | authorManager.createAuthor('API')で著者作成 | E-01（474行目） | ○ |
| C-10 | pad.addSavedRevisionでリビジョン保存 | E-01（475行目）, E-04 | ○ |
| C-11 | 重複チェックで既存リビジョンは無視 | E-04（625-628行目） | ○ |
| C-12 | savedRevisionsオブジェクト形式 | E-04（631-637行目） | ○ |
| C-13 | saveToDatabaseで永続化 | E-04（641行目） | ○ |
| C-14 | APIバージョン1.2.11で追加 | E-03（110行目） | ○ |
| C-15 | Socket.IO経由でも呼び出し可能 | E-05（444-448行目） | ○ |
| C-16 | ラベルは"Saved through API call" | E-01（475行目の第3引数） | ○ |
| C-17 | 成功時はnullデータを返却 | E-01（関数の戻り値なし） | ○ |
| C-18 | リクエストボディはJSON形式 | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）

- 特になし

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - API仕様は明確にソースコードから確認できる
- 0: 低リスク - テストケースで動作が検証されている
- 1: 中リスク - 保存済みリビジョンの削除APIがないため、一度保存すると削除不可

## 6) レビュアーチェックリスト（最小）

- [ ] E-01のsaveRevision関数実装を確認
- [ ] E-04のaddSavedRevisionメソッドを確認
- [ ] E-05のSocket.IO経由の呼び出しを確認
- [ ] E-08のテストケースが期待動作を網羅しているか確認
- [ ] 重複保存時のサイレント成功動作を確認
